/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jmxdebug.web.beanlib;

import java.beans.PropertyEditor;
import javax.management.MBeanAttributeInfo;
import org.apache.geronimo.common.propertyeditor.PropertyEditors;

public class AttributeData {
    private final String name;
    private final String value;
    private final String type;
    private final boolean readable;
    private final boolean writable;

    public AttributeData(String name, String value, String type, boolean readable, boolean writable) {
        this.name = name;
        this.value = value;
        this.type = type;
        this.readable = readable;
        this.writable = writable;
    }

    public AttributeData(MBeanAttributeInfo attributeInfo, Object value, ClassLoader cl) throws ClassNotFoundException {
        this.name = attributeInfo.getName();
        PropertyEditor editor = PropertyEditors.findEditor((String)attributeInfo.getType(), (ClassLoader)cl);
        editor.setValue(value);
        this.value = editor.getAsText();
        this.type = attributeInfo.getType();
        this.readable = attributeInfo.isReadable();
        this.writable = attributeInfo.isWritable();
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String getType() {
        return this.type;
    }

    public boolean isReadable() {
        return this.readable;
    }

    public boolean isWritable() {
        return this.writable;
    }
}

