/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jmxdebug.web.beanlib;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.apache.geronimo.jmxdebug.util.ObjectInstanceComparator;

public class MBeanServerHelper {
    private final MBeanServer server = MBeanServerHelper.getMBeanServer();

    public static MBeanServer getMBeanServer() {
        ArrayList<MBeanServer> l = MBeanServerFactory.findMBeanServer(null);
        if (l.size() > 0) {
            return (MBeanServer)l.get(0);
        }
        return null;
    }

    public Collection getMBeans() {
        return this.getMBeans("*:*");
    }

    public Collection getMBeans(String filterString) {
        if (this.server != null) {
            ObjectName objectName = null;
            try {
                objectName = new ObjectName(filterString == null ? "*:*" : filterString);
                Set<ObjectInstance> s = this.server.queryMBeans(objectName, null);
                ArrayList<ObjectInstance> list = new ArrayList<ObjectInstance>();
                list.addAll(s);
                ObjectInstanceComparator comparator = new ObjectInstanceComparator();
                Collections.sort(list, comparator);
                return list;
            }
            catch (MalformedObjectNameException e) {
                e.printStackTrace();
            }
        } else {
            System.out.println("MBeanServerHelper : error : no mbean server");
        }
        return null;
    }
}

