/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jmxdebug.web.beanlib;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeMBeanException;
import org.apache.geronimo.jmxdebug.web.beanlib.MBeanServerHelper;

public class MBeanInfoHelper {
    ObjectName oName;
    MBeanInfo info;

    public MBeanInfoHelper(String name) {
        MBeanServer server = MBeanServerHelper.getMBeanServer();
        if (server != null) {
            this.init(server, name);
        }
    }

    void init(MBeanServer server, String name) {
        try {
            this.oName = new ObjectName(name);
            this.info = server.getMBeanInfo(this.oName);
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
        }
        catch (ReflectionException e) {
            e.printStackTrace();
        }
        catch (InstanceNotFoundException e) {
            e.printStackTrace();
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
        }
    }

    public String getCanonicalName() {
        return this.oName.getCanonicalName();
    }

    public String getDomain() {
        return this.oName.getDomain();
    }

    public List getKeyProperties() {
        Hashtable<String, String> h = this.oName.getKeyPropertyList();
        Iterator<String> it = h.keySet().iterator();
        ArrayList l = new ArrayList();
        while (it.hasNext()) {
            String key = it.next();
            HashMap<String, String> m = new HashMap<String, String>();
            m.put("key", key);
            m.put("value", h.get(key));
            l.add(m);
        }
        return l;
    }

    public String getDescription() {
        return this.info.getDescription();
    }

    public String getClassName() {
        return this.info.getClassName();
    }

    public List getAttributes() {
        ArrayList l = new ArrayList();
        MBeanAttributeInfo[] arr = this.info.getAttributes();
        MBeanServer server = MBeanServerHelper.getMBeanServer();
        for (int i = 0; i < arr.length; ++i) {
            MBeanAttributeInfo foo = arr[i];
            Object value = null;
            try {
                value = server.getAttribute(this.oName, foo.getName());
            }
            catch (MBeanException e) {
                e.printStackTrace();
            }
            catch (AttributeNotFoundException e) {
                e.printStackTrace();
            }
            catch (InstanceNotFoundException e) {
                e.printStackTrace();
            }
            catch (ReflectionException e) {
                e.printStackTrace();
            }
            catch (RuntimeMBeanException rme) {
                rme.printStackTrace();
            }
            HashMap<String, Object> m = new HashMap<String, Object>();
            m.put("info", foo);
            m.put("value", value);
            l.add(m);
        }
        return l;
    }

    public MBeanOperationInfo[] getOperationInfo() {
        return this.info.getOperations();
    }
}

