/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.schema;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.geronimo.schema.ElementConverter;
import org.apache.geronimo.schema.GBeanElementConverter;
import org.apache.geronimo.schema.NamespaceElementConverter;
import org.apache.geronimo.schema.SecurityElementConverter;
import org.apache.geronimo.xbeans.j2ee.ApplicationClientDocument;
import org.apache.geronimo.xbeans.j2ee.ApplicationDocument;
import org.apache.geronimo.xbeans.j2ee.ConnectorDocument;
import org.apache.geronimo.xbeans.j2ee.EjbJarDocument;
import org.apache.geronimo.xbeans.j2ee.WebAppDocument;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlDocumentProperties;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;

public class SchemaConversionUtils {
    static final String J2EE_NAMESPACE = "http://java.sun.com/xml/ns/j2ee";
    static final String GERONIMO_NAMING_NAMESPACE = "http://geronimo.apache.org/xml/ns/naming-1.1";
    private static final String GERONIMO_SECURITY_NAMESPACE = "http://geronimo.apache.org/xml/ns/security-1.1";
    private static final String GERONIMO_SERVICE_NAMESPACE = "http://geronimo.apache.org/xml/ns/deployment-1.1";
    private static final QName RESOURCE_ADAPTER_VERSION;
    private static final QName TAGLIB;
    private static final QName CMP_VERSION;
    private static final Map GERONIMO_SCHEMA_CONVERSIONS;
    static final /* synthetic */ boolean $assertionsDisabled;

    private SchemaConversionUtils() {
    }

    public static void registerNamespaceConversions(Map conversions) {
        GERONIMO_SCHEMA_CONVERSIONS.putAll(conversions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ApplicationDocument convertToApplicationSchema(XmlObject xmlObject) throws XmlException {
        if (ApplicationDocument.type.equals(xmlObject.schemaType())) {
            SchemaConversionUtils.validateDD(xmlObject);
            return (ApplicationDocument)xmlObject;
        }
        XmlCursor cursor = xmlObject.newCursor();
        XmlCursor moveable = xmlObject.newCursor();
        String schemaLocationURL = "http://java.sun.com/xml/ns/j2ee/application_1_4.xsd";
        String version = "1.4";
        try {
            SchemaConversionUtils.convertToSchema(cursor, J2EE_NAMESPACE, schemaLocationURL, version);
            cursor.toStartDoc();
            cursor.toChild(J2EE_NAMESPACE, "application");
            cursor.toFirstChild();
            SchemaConversionUtils.convertToDescriptionGroup(cursor, moveable);
        }
        finally {
            cursor.dispose();
            moveable.dispose();
        }
        XmlObject result = xmlObject.changeType(ApplicationDocument.type);
        if (result != null) {
            SchemaConversionUtils.validateDD(result);
            return (ApplicationDocument)result;
        }
        SchemaConversionUtils.validateDD(xmlObject);
        return (ApplicationDocument)xmlObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ApplicationClientDocument convertToApplicationClientSchema(XmlObject xmlObject) throws XmlException {
        if (ApplicationClientDocument.type.equals(xmlObject.schemaType())) {
            SchemaConversionUtils.validateDD(xmlObject);
            return (ApplicationClientDocument)xmlObject;
        }
        XmlCursor cursor = xmlObject.newCursor();
        XmlCursor moveable = xmlObject.newCursor();
        String schemaLocationURL = "http://java.sun.com/xml/ns/j2ee/application-client_1_4.xsd";
        String version = "1.4";
        try {
            SchemaConversionUtils.convertToSchema(cursor, J2EE_NAMESPACE, schemaLocationURL, version);
            cursor.toStartDoc();
            cursor.toChild(J2EE_NAMESPACE, "application-client");
            cursor.toFirstChild();
            SchemaConversionUtils.convertToDescriptionGroup(cursor, moveable);
        }
        finally {
            cursor.dispose();
            moveable.dispose();
        }
        XmlObject result = xmlObject.changeType(ApplicationClientDocument.type);
        if (result != null) {
            SchemaConversionUtils.validateDD(result);
            return (ApplicationClientDocument)result;
        }
        SchemaConversionUtils.validateDD(xmlObject);
        return (ApplicationClientDocument)xmlObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConnectorDocument convertToConnectorSchema(XmlObject xmlObject) throws XmlException {
        block10: {
            if (ConnectorDocument.type.equals(xmlObject.schemaType())) {
                SchemaConversionUtils.validateDD(xmlObject);
                return (ConnectorDocument)xmlObject;
            }
            XmlCursor cursor = xmlObject.newCursor();
            XmlDocumentProperties xmlDocumentProperties = cursor.documentProperties();
            String publicId = xmlDocumentProperties.getDoctypePublicId();
            try {
                if (!"-//Sun Microsystems, Inc.//DTD Connector 1.0//EN".equals(publicId)) break block10;
                XmlCursor moveable = xmlObject.newCursor();
                try {
                    String schemaLocationURL = "http://java.sun.com/xml/ns/j2ee/connector_1_5.xsd";
                    String version = "1.5";
                    SchemaConversionUtils.convertToSchema(cursor, J2EE_NAMESPACE, schemaLocationURL, version);
                    cursor.toStartDoc();
                    cursor.toChild(J2EE_NAMESPACE, "connector");
                    cursor.toFirstChild();
                    SchemaConversionUtils.convertToDescriptionGroup(cursor, moveable);
                    cursor.toNextSibling(J2EE_NAMESPACE, "spec-version");
                    cursor.removeXml();
                    cursor.toNextSibling(J2EE_NAMESPACE, "version");
                    cursor.setName(RESOURCE_ADAPTER_VERSION);
                    cursor.toNextSibling(J2EE_NAMESPACE, "resourceadapter");
                    moveable.toCursor(cursor);
                    cursor.toFirstChild();
                    cursor.beginElement("outbound-resourceadapter", J2EE_NAMESPACE);
                    cursor.beginElement("connection-definition", J2EE_NAMESPACE);
                    moveable.toChild(J2EE_NAMESPACE, "managedconnectionfactory-class");
                    moveable.push();
                    moveable.moveXml(cursor);
                    while (moveable.toNextSibling(J2EE_NAMESPACE, "config-property")) {
                        moveable.moveXml(cursor);
                    }
                    moveable.pop();
                    moveable.toNextSibling(J2EE_NAMESPACE, "connectionfactory-interface");
                    moveable.moveXml(cursor);
                    moveable.toNextSibling(J2EE_NAMESPACE, "connectionfactory-impl-class");
                    moveable.moveXml(cursor);
                    moveable.toNextSibling(J2EE_NAMESPACE, "connection-interface");
                    moveable.moveXml(cursor);
                    moveable.toNextSibling(J2EE_NAMESPACE, "connection-impl-class");
                    moveable.moveXml(cursor);
                    cursor.toNextToken();
                    moveable.toNextSibling(J2EE_NAMESPACE, "transaction-support");
                    moveable.moveXml(cursor);
                    while (moveable.toNextSibling(J2EE_NAMESPACE, "authentication-mechanism")) {
                        moveable.moveXml(cursor);
                    }
                    moveable.toNextSibling(J2EE_NAMESPACE, "reauthentication-support");
                    moveable.moveXml(cursor);
                }
                finally {
                    moveable.dispose();
                }
            }
            finally {
                cursor.dispose();
            }
        }
        XmlObject result = xmlObject.changeType(ConnectorDocument.type);
        if (result != null) {
            SchemaConversionUtils.validateDD(result);
            return (ConnectorDocument)result;
        }
        SchemaConversionUtils.validateDD(xmlObject);
        return (ConnectorDocument)xmlObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static EjbJarDocument convertToEJBSchema(XmlObject xmlObject) throws XmlException {
        if (EjbJarDocument.type.equals(xmlObject.schemaType())) {
            SchemaConversionUtils.validateDD(xmlObject);
            return (EjbJarDocument)xmlObject;
        }
        XmlCursor cursor = xmlObject.newCursor();
        XmlCursor moveable = xmlObject.newCursor();
        try {
            void var5_7;
            String cmpVersion;
            cursor.toFirstChild();
            if (J2EE_NAMESPACE.equals(cursor.getName().getNamespaceURI())) {
                XmlObject result = xmlObject.changeType(EjbJarDocument.type);
                SchemaConversionUtils.validateDD(result);
                EjbJarDocument ejbJarDocument = (EjbJarDocument)result;
                return ejbJarDocument;
            }
            XmlDocumentProperties xmlDocumentProperties = cursor.documentProperties();
            String publicId = xmlDocumentProperties.getDoctypePublicId();
            if ("-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 1.1//EN".equals(publicId)) {
                cmpVersion = "1.x";
            } else if ("-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 2.0//EN".equals(publicId)) {
                cmpVersion = null;
            } else {
                throw new XmlException("Unrecognized document type: " + publicId);
            }
            String schemaLocationURL = "http://java.sun.com/xml/ns/j2ee/ejb-jar_2_1.xsd";
            String version = "2.1";
            SchemaConversionUtils.convertToSchema(cursor, J2EE_NAMESPACE, schemaLocationURL, version);
            cursor.toStartDoc();
            SchemaConversionUtils.convertBeans(cursor, moveable, (String)var5_7);
        }
        finally {
            cursor.dispose();
            moveable.dispose();
        }
        XmlObject result = xmlObject.changeType(EjbJarDocument.type);
        if (result != null) {
            SchemaConversionUtils.validateDD(result);
            return (EjbJarDocument)result;
        }
        SchemaConversionUtils.validateDD(xmlObject);
        return (EjbJarDocument)xmlObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WebAppDocument convertToServletSchema(XmlObject xmlObject) throws XmlException {
        block14: {
            if (WebAppDocument.type.equals(xmlObject.schemaType())) {
                SchemaConversionUtils.validateDD(xmlObject);
                return (WebAppDocument)xmlObject;
            }
            XmlCursor cursor = xmlObject.newCursor();
            try {
                cursor.toStartDoc();
                cursor.toFirstChild();
                if (J2EE_NAMESPACE.equals(cursor.getName().getNamespaceURI())) {
                    XmlObject result = xmlObject.changeType(WebAppDocument.type);
                    SchemaConversionUtils.validateDD(result);
                    WebAppDocument webAppDocument = (WebAppDocument)result;
                    return webAppDocument;
                }
                XmlDocumentProperties xmlDocumentProperties = cursor.documentProperties();
                String publicId = xmlDocumentProperties.getDoctypePublicId();
                if (!"-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN".equals(publicId) && !"-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN".equals(publicId)) break block14;
                XmlCursor moveable = xmlObject.newCursor();
                try {
                    moveable.toStartDoc();
                    moveable.toFirstChild();
                    String schemaLocationURL = "http://java.sun.com/xml/ns/j2ee/web-app_2_4.xsd";
                    String version = "2.4";
                    SchemaConversionUtils.convertToSchema(cursor, J2EE_NAMESPACE, schemaLocationURL, version);
                    cursor.toStartDoc();
                    cursor.toChild(J2EE_NAMESPACE, "web-app");
                    cursor.toFirstChild();
                    SchemaConversionUtils.convertToDescriptionGroup(cursor, moveable);
                    SchemaConversionUtils.convertToJNDIEnvironmentRefsGroup(cursor, moveable);
                    cursor.push();
                    if (cursor.toNextSibling(TAGLIB)) {
                        cursor.toPrevSibling();
                        moveable.toCursor(cursor);
                        cursor.beginElement("jsp-config", J2EE_NAMESPACE);
                        while (moveable.toNextSibling(TAGLIB)) {
                            moveable.moveXml(cursor);
                        }
                    }
                    cursor.pop();
                    do {
                        String name;
                        if (!"filter".equals(name = cursor.getName().getLocalPart()) && !"servlet".equals(name) && !"context-param".equals(name)) continue;
                        cursor.push();
                        cursor.toFirstChild();
                        SchemaConversionUtils.convertToDescriptionGroup(cursor, moveable);
                        while (cursor.toNextSibling(J2EE_NAMESPACE, "init-param")) {
                            cursor.push();
                            cursor.toFirstChild();
                            SchemaConversionUtils.convertToDescriptionGroup(cursor, moveable);
                            cursor.pop();
                        }
                        cursor.pop();
                    } while (cursor.toNextSibling());
                }
                finally {
                    moveable.dispose();
                }
            }
            finally {
                cursor.dispose();
            }
        }
        XmlObject result = xmlObject.changeType(WebAppDocument.type);
        if (result != null) {
            SchemaConversionUtils.validateDD(result);
            return (WebAppDocument)result;
        }
        SchemaConversionUtils.validateDD(xmlObject);
        return (WebAppDocument)xmlObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void convertToGeronimoSubSchemas(XmlCursor cursor) {
        cursor.toStartDoc();
        XmlCursor end = cursor.newCursor();
        try {
            while (cursor.hasNextToken()) {
                SchemaConversionUtils.convertSingleElementToGeronimoSubSchemas(cursor, end);
                cursor.toNextToken();
            }
        }
        finally {
            end.dispose();
        }
    }

    public static boolean convertSingleElementToGeronimoSubSchemas(XmlCursor cursor, XmlCursor end) {
        if (cursor.isStart()) {
            String localName = cursor.getName().getLocalPart();
            ElementConverter converter = (ElementConverter)GERONIMO_SCHEMA_CONVERSIONS.get(localName);
            if (converter != null) {
                converter.convertElement(cursor, end);
                return true;
            }
            return false;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XmlObject fixGeronimoSchema(XmlObject rawPlan, QName desiredElement, SchemaType desiredType) throws XmlException {
        XmlCursor cursor = rawPlan.newCursor();
        try {
            if (SchemaConversionUtils.findNestedElement(cursor, desiredElement)) {
                cursor.push();
                SchemaConversionUtils.convertToGeronimoSubSchemas(cursor);
                cursor.pop();
                XmlObject temp = cursor.getObject();
                XmlObject result = temp.changeType(desiredType);
                if (result == null || result.schemaType() != desiredType) {
                    result = temp.copy().changeType(desiredType);
                }
                SchemaConversionUtils.validateDD(result);
                XmlObject xmlObject = result;
                return xmlObject;
            }
            XmlObject xmlObject = null;
            return xmlObject;
        }
        finally {
            cursor.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XmlObject getNestedObject(XmlObject xmlObject, QName desiredElement) {
        XmlCursor cursor = xmlObject.newCursor();
        try {
            if (SchemaConversionUtils.findNestedElement(cursor, desiredElement)) {
                XmlObject child = cursor.getObject();
                XmlObject xmlObject2 = child.copy();
                return xmlObject2;
            }
        }
        finally {
            cursor.dispose();
        }
        throw new IllegalArgumentException("xmlobject did not have desired element: " + desiredElement + "/n" + xmlObject);
    }

    public static boolean findNestedElement(XmlCursor cursor, QName desiredElement) {
        while (cursor.hasNextToken()) {
            QName element;
            if (cursor.isStart() && (element = cursor.getName()).equals(desiredElement)) {
                return true;
            }
            cursor.toNextToken();
        }
        return false;
    }

    public static boolean findNestedElement(XmlCursor cursor, String desiredElement) {
        while (cursor.hasNextToken()) {
            String element;
            if (cursor.isStart() && (element = cursor.getName().getLocalPart()).equals(desiredElement)) {
                return true;
            }
            cursor.toNextToken();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XmlObject getNestedObjectAsType(XmlObject xmlObject, QName desiredElement, SchemaType type) {
        XmlCursor cursor = xmlObject.newCursor();
        try {
            if (SchemaConversionUtils.findNestedElement(cursor, desiredElement)) {
                XmlObject child = cursor.getObject();
                XmlObject result = child.copy().changeType(type);
                if (!$assertionsDisabled && result.schemaType() != type) {
                    throw new AssertionError();
                }
                XmlObject xmlObject2 = result;
                return xmlObject2;
            }
        }
        finally {
            cursor.dispose();
        }
        throw new IllegalArgumentException("xmlobject did not have desired element: " + desiredElement + "\n" + xmlObject);
    }

    public static boolean convertToSchema(XmlCursor cursor, String namespace, String schemaLocationURL, String version) {
        XmlDocumentProperties xmlDocumentProperties = cursor.documentProperties();
        xmlDocumentProperties.remove(XmlDocumentProperties.DOCTYPE_NAME);
        xmlDocumentProperties.remove(XmlDocumentProperties.DOCTYPE_PUBLIC_ID);
        xmlDocumentProperties.remove(XmlDocumentProperties.DOCTYPE_SYSTEM_ID);
        boolean isFirstStart = true;
        while (cursor.hasNextToken()) {
            if (cursor.isStart()) {
                if (namespace.equals(cursor.getName().getNamespaceURI())) {
                    return false;
                }
                cursor.setName(new QName(namespace, cursor.getName().getLocalPart()));
                cursor.toNextToken();
                if (!isFirstStart) continue;
                cursor.insertNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
                cursor.insertAttributeWithValue(new QName("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation", "xsi"), namespace + schemaLocationURL);
                cursor.insertAttributeWithValue(new QName("version"), version);
                isFirstStart = false;
                continue;
            }
            cursor.toNextToken();
        }
        return true;
    }

    public static void convertBeans(XmlCursor cursor, XmlCursor moveable, String cmpVersion) {
        cursor.toChild(J2EE_NAMESPACE, "ejb-jar");
        cursor.toChild(J2EE_NAMESPACE, "enterprise-beans");
        if (cursor.toFirstChild()) {
            do {
                cursor.push();
                String type = cursor.getName().getLocalPart();
                if ("session".equals(type)) {
                    cursor.toChild(J2EE_NAMESPACE, "transaction-type");
                    cursor.toNextSibling();
                    SchemaConversionUtils.convertToJNDIEnvironmentRefsGroup(cursor, moveable);
                } else if ("entity".equals(type)) {
                    cursor.toChild(J2EE_NAMESPACE, "persistence-type");
                    String persistenceType = cursor.getTextValue();
                    cursor.toNextSibling(J2EE_NAMESPACE, "reentrant");
                    cursor.setTextValue(cursor.getTextValue().toLowerCase());
                    if (cmpVersion != null && !cursor.toNextSibling(CMP_VERSION) && "Container".equals(persistenceType)) {
                        cursor.toNextSibling();
                        cursor.insertElementWithText(CMP_VERSION, cmpVersion);
                    }
                    cursor.toNextSibling(J2EE_NAMESPACE, "abstract-schema-name");
                    while (cursor.toNextSibling(J2EE_NAMESPACE, "cmp-field")) {
                    }
                    cursor.toNextSibling(J2EE_NAMESPACE, "primkey-field");
                    cursor.toNextSibling();
                    SchemaConversionUtils.convertToJNDIEnvironmentRefsGroup(cursor, moveable);
                } else if ("message-driven".equals(type)) {
                    cursor.toFirstChild();
                    if (cursor.toNextSibling(J2EE_NAMESPACE, "messaging-type")) {
                        cursor.toNextSibling(J2EE_NAMESPACE, "transaction-type");
                    } else {
                        cursor.toNextSibling(J2EE_NAMESPACE, "transaction-type");
                        cursor.insertElementWithText("messaging-type", J2EE_NAMESPACE, "javax.jms.MessageListener");
                    }
                    if (!cursor.toNextSibling(J2EE_NAMESPACE, "activation-config")) {
                        boolean hasProperties = false;
                        cursor.toNextSibling();
                        moveable.toCursor(cursor);
                        cursor.push();
                        cursor.beginElement("activation-config", J2EE_NAMESPACE);
                        hasProperties |= SchemaConversionUtils.addActivationConfigProperty(moveable, cursor, "message-selector", "messageSelector");
                        hasProperties |= SchemaConversionUtils.addActivationConfigProperty(moveable, cursor, "acknowledge-mode", "acknowledgeMode");
                        if (new QName(J2EE_NAMESPACE, "message-driven-destination").equals(moveable.getName()) || moveable.toNextSibling(J2EE_NAMESPACE, "message-driven-destination")) {
                            moveable.push();
                            moveable.toFirstChild();
                            hasProperties |= SchemaConversionUtils.addActivationConfigProperty(moveable, cursor, "destination-type", "destinationType");
                            hasProperties |= SchemaConversionUtils.addActivationConfigProperty(moveable, cursor, "subscription-durability", "subscriptionDurability");
                            moveable.pop();
                            moveable.removeXml();
                        }
                        cursor.pop();
                        if (!hasProperties) {
                            cursor.toPrevSibling();
                            cursor.removeXml();
                        }
                    } else {
                        cursor.toNextSibling();
                    }
                    SchemaConversionUtils.convertToJNDIEnvironmentRefsGroup(cursor, moveable);
                }
                cursor.pop();
            } while (cursor.toNextSibling());
        }
    }

    private static boolean addActivationConfigProperty(XmlCursor moveable, XmlCursor cursor, String elementName, String propertyName) {
        QName name = new QName(J2EE_NAMESPACE, elementName);
        if (name.equals(moveable.getName()) || moveable.toNextSibling(name)) {
            cursor.push();
            cursor.beginElement("activation-config-property", J2EE_NAMESPACE);
            cursor.insertElementWithText("activation-config-property-name", J2EE_NAMESPACE, propertyName);
            cursor.insertElementWithText("activation-config-property-value", J2EE_NAMESPACE, moveable.getTextValue());
            moveable.removeXml();
            cursor.pop();
            cursor.toNextSibling();
            return true;
        }
        return false;
    }

    public static void convertToDescriptionGroup(XmlCursor cursor, XmlCursor moveable) {
        moveable.toCursor(cursor);
        SchemaConversionUtils.moveElements("description", moveable, cursor);
        SchemaConversionUtils.moveElements("display-name", moveable, cursor);
        SchemaConversionUtils.moveElements("icon", moveable, cursor);
    }

    public static void convertToJNDIEnvironmentRefsGroup(XmlCursor cursor, XmlCursor moveable) {
        SchemaConversionUtils.moveElements("env-entry", moveable, cursor);
        SchemaConversionUtils.moveElements("ejb-ref", moveable, cursor);
        SchemaConversionUtils.moveElements("ejb-local-ref", moveable, cursor);
        SchemaConversionUtils.moveElements("resource-ref", moveable, cursor);
        SchemaConversionUtils.moveElements("resource-env-ref", moveable, cursor);
        SchemaConversionUtils.moveElements("message-destination-ref", moveable, cursor);
        if (cursor.toPrevSibling()) {
            do {
                String name;
                if (!"env-entry".equals(name = cursor.getName().getLocalPart())) continue;
                cursor.push();
                cursor.toFirstChild();
                SchemaConversionUtils.convertToDescriptionGroup(cursor, moveable);
                SchemaConversionUtils.convertToEnvEntryGroup(cursor, moveable);
                cursor.pop();
            } while (cursor.toPrevSibling());
        }
    }

    public static void convertToEnvEntryGroup(XmlCursor cursor, XmlCursor moveable) {
        SchemaConversionUtils.moveElements("env-entry-name", moveable, cursor);
        SchemaConversionUtils.moveElements("env-entry-type", moveable, cursor);
        SchemaConversionUtils.moveElements("env-entry-value", moveable, cursor);
    }

    public static void validateDD(XmlObject dd) throws XmlException {
        XmlOptions xmlOptions = new XmlOptions();
        xmlOptions.setLoadLineNumbers();
        ArrayList errors = new ArrayList();
        xmlOptions.setErrorListener(errors);
        if (!dd.validate(xmlOptions)) {
            throw new XmlException("Invalid deployment descriptor: " + errors + "\nDescriptor: " + dd.toString(), null, errors);
        }
    }

    private static void moveElements(String localName, XmlCursor moveable, XmlCursor toHere) {
        QName name = new QName(J2EE_NAMESPACE, localName);
        while (name.equals(toHere.getName()) && toHere.toNextSibling()) {
        }
        moveable.toCursor(toHere);
        while (moveable.toNextSibling(name)) {
            moveable.moveXml(toHere);
        }
    }

    static {
        $assertionsDisabled = !SchemaConversionUtils.class.desiredAssertionStatus();
        RESOURCE_ADAPTER_VERSION = new QName(J2EE_NAMESPACE, "resourceadapter-version");
        TAGLIB = new QName(J2EE_NAMESPACE, "taglib");
        CMP_VERSION = new QName(J2EE_NAMESPACE, "cmp-version");
        GERONIMO_SCHEMA_CONVERSIONS = new HashMap();
        GERONIMO_SCHEMA_CONVERSIONS.put("gbean-ref", new NamespaceElementConverter(GERONIMO_NAMING_NAMESPACE));
        GERONIMO_SCHEMA_CONVERSIONS.put("ejb-ref", new NamespaceElementConverter(GERONIMO_NAMING_NAMESPACE));
        GERONIMO_SCHEMA_CONVERSIONS.put("ejb-local-ref", new NamespaceElementConverter(GERONIMO_NAMING_NAMESPACE));
        GERONIMO_SCHEMA_CONVERSIONS.put("service-ref", new NamespaceElementConverter(GERONIMO_NAMING_NAMESPACE));
        GERONIMO_SCHEMA_CONVERSIONS.put("resource-ref", new NamespaceElementConverter(GERONIMO_NAMING_NAMESPACE));
        GERONIMO_SCHEMA_CONVERSIONS.put("resource-env-ref", new NamespaceElementConverter(GERONIMO_NAMING_NAMESPACE));
        GERONIMO_SCHEMA_CONVERSIONS.put("message-destination", new NamespaceElementConverter(GERONIMO_NAMING_NAMESPACE));
        GERONIMO_SCHEMA_CONVERSIONS.put("cmp-connection-factory", new NamespaceElementConverter(GERONIMO_NAMING_NAMESPACE));
        GERONIMO_SCHEMA_CONVERSIONS.put("workmanager", new NamespaceElementConverter(GERONIMO_NAMING_NAMESPACE));
        GERONIMO_SCHEMA_CONVERSIONS.put("resource-adapter", new NamespaceElementConverter(GERONIMO_NAMING_NAMESPACE));
        GERONIMO_SCHEMA_CONVERSIONS.put("web-container", new NamespaceElementConverter(GERONIMO_NAMING_NAMESPACE));
        GERONIMO_SCHEMA_CONVERSIONS.put("security", new SecurityElementConverter());
        GERONIMO_SCHEMA_CONVERSIONS.put("default-principal", new NamespaceElementConverter(GERONIMO_SECURITY_NAMESPACE));
        GERONIMO_SCHEMA_CONVERSIONS.put("gbean", new GBeanElementConverter());
        GERONIMO_SCHEMA_CONVERSIONS.put("environment", new NamespaceElementConverter(GERONIMO_SERVICE_NAMESPACE));
        GERONIMO_SCHEMA_CONVERSIONS.put("client-environment", new NamespaceElementConverter(GERONIMO_SERVICE_NAMESPACE));
        GERONIMO_SCHEMA_CONVERSIONS.put("server-environment", new NamespaceElementConverter(GERONIMO_SERVICE_NAMESPACE));
    }
}

