/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.schema;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.apache.geronimo.xbeans.j2ee.ApplicationDocument;
import org.apache.geronimo.xbeans.j2ee.EjbJarDocument;
import org.apache.geronimo.xbeans.j2ee.WebAppDocument;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;

public class SchemaConversionUtils {
    private static final String J2EE_NAMESPACE = "http://java.sun.com/xml/ns/j2ee";

    private SchemaConversionUtils() {
    }

    public static XmlObject parse(InputStream is) throws IOException, XmlException {
        ArrayList errors = new ArrayList();
        XmlOptions options = new XmlOptions();
        options.setLoadLineNumbers();
        options.setErrorListener(errors);
        XmlObject parsed = XmlObject.Factory.parse((InputStream)is, (XmlOptions)options);
        if (errors.size() != 0) {
            throw new XmlException(errors.toArray().toString());
        }
        return parsed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ApplicationDocument convertToApplicationSchema(XmlObject xmlObject) throws XmlException {
        if (ApplicationDocument.type.equals(xmlObject.schemaType())) {
            SchemaConversionUtils.validateDD(xmlObject);
            return (ApplicationDocument)xmlObject;
        }
        XmlCursor cursor = xmlObject.newCursor();
        XmlCursor moveable = xmlObject.newCursor();
        String schemaLocationURL = "http://java.sun.com/xml/ns/j2ee/application_1_4.xsd";
        String version = "1.4";
        try {
            SchemaConversionUtils.convertToSchema(cursor, schemaLocationURL, version);
            cursor.toStartDoc();
            cursor.toChild(J2EE_NAMESPACE, "application");
            cursor.toFirstChild();
            SchemaConversionUtils.convertToDescriptionGroup(cursor, moveable);
        }
        finally {
            cursor.dispose();
            moveable.dispose();
        }
        XmlObject result = xmlObject.changeType(ApplicationDocument.type);
        if (result != null) {
            SchemaConversionUtils.validateDD(result);
            return (ApplicationDocument)result;
        }
        SchemaConversionUtils.validateDD(xmlObject);
        return (ApplicationDocument)xmlObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EjbJarDocument convertToEJBSchema(XmlObject xmlObject) throws XmlException {
        if (EjbJarDocument.type.equals(xmlObject.schemaType())) {
            SchemaConversionUtils.validateDD(xmlObject);
            return (EjbJarDocument)xmlObject;
        }
        XmlCursor cursor = xmlObject.newCursor();
        XmlCursor moveable = xmlObject.newCursor();
        String schemaLocationURL = "http://java.sun.com/xml/ns/j2ee/ejb-jar_2_1.xsd";
        String version = "2.1";
        try {
            SchemaConversionUtils.convertToSchema(cursor, schemaLocationURL, version);
            cursor.toStartDoc();
            SchemaConversionUtils.convertBeans(cursor, moveable);
        }
        finally {
            cursor.dispose();
            moveable.dispose();
        }
        XmlObject result = xmlObject.changeType(EjbJarDocument.type);
        if (result != null) {
            SchemaConversionUtils.validateDD(result);
            return (EjbJarDocument)result;
        }
        SchemaConversionUtils.validateDD(xmlObject);
        return (EjbJarDocument)xmlObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WebAppDocument convertToServletSchema(XmlObject xmlObject) throws XmlException {
        if (WebAppDocument.type.equals(xmlObject.schemaType())) {
            SchemaConversionUtils.validateDD(xmlObject);
            return (WebAppDocument)xmlObject;
        }
        XmlCursor cursor = xmlObject.newCursor();
        XmlCursor moveable = xmlObject.newCursor();
        String schemaLocationURL = "http://java.sun.com/xml/ns/j2ee/web-app_2_4.xsd";
        String version = "2.4";
        try {
            SchemaConversionUtils.convertToSchema(cursor, schemaLocationURL, version);
            cursor.toStartDoc();
            cursor.toChild(J2EE_NAMESPACE, "web-app");
            cursor.toFirstChild();
            SchemaConversionUtils.convertToDescriptionGroup(cursor, moveable);
            SchemaConversionUtils.convertToJNDIEnvironmentRefsGroup(cursor, moveable);
            do {
                String name;
                if (!"filter".equals(name = cursor.getName().getLocalPart()) && !"servlet".equals(name)) continue;
                cursor.push();
                cursor.toFirstChild();
                SchemaConversionUtils.convertToDescriptionGroup(cursor, moveable);
                if (cursor.toNextSibling(J2EE_NAMESPACE, "init-param")) {
                    cursor.toFirstChild();
                    SchemaConversionUtils.convertToDescriptionGroup(cursor, moveable);
                }
                cursor.pop();
            } while (cursor.toNextSibling());
        }
        finally {
            cursor.dispose();
            moveable.dispose();
        }
        XmlObject result = xmlObject.changeType(WebAppDocument.type);
        if (result != null) {
            SchemaConversionUtils.validateDD(result);
            return (WebAppDocument)result;
        }
        SchemaConversionUtils.validateDD(xmlObject);
        return (WebAppDocument)xmlObject;
    }

    public static boolean convertToSchema(XmlCursor cursor, String schemaLocationURL, String version) {
        boolean isFirstStart = true;
        while (cursor.hasNextToken()) {
            if (cursor.isStart()) {
                if (J2EE_NAMESPACE.equals(cursor.getName().getNamespaceURI())) {
                    return false;
                }
                cursor.setName(new QName(J2EE_NAMESPACE, cursor.getName().getLocalPart()));
                cursor.toNextToken();
                if (!isFirstStart) continue;
                cursor.insertNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
                cursor.insertAttributeWithValue(new QName("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation", "xsi"), "http://java.sun.com/xml/ns/j2ee " + schemaLocationURL);
                cursor.insertAttributeWithValue(new QName("version"), version);
                isFirstStart = false;
                continue;
            }
            cursor.toNextToken();
        }
        return true;
    }

    public static void convertBeans(XmlCursor cursor, XmlCursor moveable) {
        cursor.toChild(J2EE_NAMESPACE, "ejb-jar");
        cursor.toChild(J2EE_NAMESPACE, "enterprise-beans");
        if (cursor.toFirstChild()) {
            do {
                cursor.push();
                String type = cursor.getName().getLocalPart();
                if ("session".equals(type)) {
                    cursor.toChild(J2EE_NAMESPACE, "transaction-type");
                    cursor.toNextSibling();
                    SchemaConversionUtils.convertToJNDIEnvironmentRefsGroup(cursor, moveable);
                } else if ("entity".equals(type)) {
                    cursor.toChild(J2EE_NAMESPACE, "reentrant");
                    cursor.setTextValue(cursor.getTextValue().toLowerCase());
                    cursor.toNextSibling(J2EE_NAMESPACE, "cmp-version");
                    cursor.toNextSibling(J2EE_NAMESPACE, "abstract-schema-name");
                    while (cursor.toNextSibling(J2EE_NAMESPACE, "cmp-field")) {
                    }
                    cursor.toNextSibling(J2EE_NAMESPACE, "primkey-field");
                    cursor.toNextSibling();
                    SchemaConversionUtils.convertToJNDIEnvironmentRefsGroup(cursor, moveable);
                } else if ("message-driven".equals(type)) {
                    cursor.toFirstChild();
                    if (cursor.toNextSibling(J2EE_NAMESPACE, "messaging-type")) {
                        cursor.toNextSibling(J2EE_NAMESPACE, "transaction-type");
                    } else {
                        cursor.toNextSibling(J2EE_NAMESPACE, "transaction-type");
                        cursor.insertElementWithText("messaging-type", J2EE_NAMESPACE, "javax.jms.MessageListener");
                    }
                    if (!cursor.toNextSibling(J2EE_NAMESPACE, "activation-config")) {
                        boolean hasProperties = false;
                        cursor.toNextSibling();
                        moveable.toCursor(cursor);
                        cursor.push();
                        cursor.beginElement("activation-config", J2EE_NAMESPACE);
                        hasProperties |= SchemaConversionUtils.addActivationConfigProperty(moveable, cursor, "message-selector", "messageSelector");
                        hasProperties |= SchemaConversionUtils.addActivationConfigProperty(moveable, cursor, "acknowledge-mode", "acknowledgeMode");
                        if (new QName(J2EE_NAMESPACE, "message-driven-destination").equals(moveable.getName()) || moveable.toNextSibling(J2EE_NAMESPACE, "message-driven-destination")) {
                            moveable.push();
                            moveable.toFirstChild();
                            hasProperties |= SchemaConversionUtils.addActivationConfigProperty(moveable, cursor, "destination-type", "destinationType");
                            hasProperties |= SchemaConversionUtils.addActivationConfigProperty(moveable, cursor, "subscription-durability", "subscriptionDurability");
                            moveable.pop();
                            moveable.removeXml();
                        }
                        cursor.pop();
                        if (!hasProperties) {
                            cursor.toPrevSibling();
                            cursor.removeXml();
                        }
                    }
                    cursor.toNextSibling();
                    SchemaConversionUtils.convertToJNDIEnvironmentRefsGroup(cursor, moveable);
                }
                cursor.pop();
            } while (cursor.toNextSibling());
        }
    }

    private static boolean addActivationConfigProperty(XmlCursor moveable, XmlCursor cursor, String elementName, String propertyName) {
        QName name = new QName(J2EE_NAMESPACE, elementName);
        if (name.equals(moveable.getName()) || moveable.toNextSibling(name)) {
            cursor.push();
            cursor.beginElement("activation-config-property", J2EE_NAMESPACE);
            cursor.insertElementWithText("activation-config-property-name", J2EE_NAMESPACE, propertyName);
            cursor.insertElementWithText("activation-config-property-value", J2EE_NAMESPACE, moveable.getTextValue());
            moveable.removeXml();
            cursor.pop();
            cursor.toNextSibling();
            return true;
        }
        return false;
    }

    public static void convertToDescriptionGroup(XmlCursor cursor, XmlCursor moveable) {
        moveable.toCursor(cursor);
        SchemaConversionUtils.moveElements("description", moveable, cursor);
        SchemaConversionUtils.moveElements("display-name", moveable, cursor);
        SchemaConversionUtils.moveElements("icon", moveable, cursor);
    }

    public static void convertToJNDIEnvironmentRefsGroup(XmlCursor cursor, XmlCursor moveable) {
        SchemaConversionUtils.moveElements("env-entry", moveable, cursor);
        SchemaConversionUtils.moveElements("ejb-ref", moveable, cursor);
        SchemaConversionUtils.moveElements("ejb-local-ref", moveable, cursor);
        SchemaConversionUtils.moveElements("resource-ref", moveable, cursor);
        SchemaConversionUtils.moveElements("resource-env-ref", moveable, cursor);
        SchemaConversionUtils.moveElements("message-destination-ref", moveable, cursor);
        if (cursor.toPrevSibling()) {
            do {
                String name;
                if (!"env-entry".equals(name = cursor.getName().getLocalPart())) continue;
                cursor.push();
                cursor.toFirstChild();
                SchemaConversionUtils.convertToDescriptionGroup(cursor, moveable);
                SchemaConversionUtils.convertToEnvEntryGroup(cursor, moveable);
                cursor.pop();
            } while (cursor.toPrevSibling());
        }
    }

    public static void convertToEnvEntryGroup(XmlCursor cursor, XmlCursor moveable) {
        SchemaConversionUtils.moveElements("env-entry-name", moveable, cursor);
        SchemaConversionUtils.moveElements("env-entry-type", moveable, cursor);
        SchemaConversionUtils.moveElements("env-entry-value", moveable, cursor);
    }

    public static void validateDD(XmlObject dd) throws XmlException {
        XmlOptions xmlOptions = new XmlOptions();
        xmlOptions.setLoadLineNumbers();
        ArrayList errors = new ArrayList();
        xmlOptions.setErrorListener(errors);
        if (!dd.validate(xmlOptions)) {
            throw new XmlException("Invalid deployment descriptor: " + errors, null, errors);
        }
    }

    private static void moveElements(String localName, XmlCursor moveable, XmlCursor toHere) {
        QName name = new QName(J2EE_NAMESPACE, localName);
        while (name.equals(toHere.getName()) && toHere.toNextSibling()) {
        }
        moveable.toCursor(toHere);
        while (moveable.toNextSibling(name)) {
            moveable.moveXml(toHere);
        }
    }
}

