/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.j2ee.deployment;

import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.naming.Reference;
import javax.xml.namespace.QName;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.DeploymentContext;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.j2ee.deployment.EJBReferenceBuilder;
import org.apache.geronimo.j2ee.deployment.Module;
import org.apache.geronimo.j2ee.deployment.ResourceReferenceBuilder;
import org.apache.geronimo.j2ee.deployment.ServiceReferenceBuilder;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.config.Configuration;
import org.apache.geronimo.kernel.repository.Artifact;

public class RefContext {
    private final EJBReferenceBuilder ejbReferenceBuilder;
    private final ResourceReferenceBuilder resourceReferenceBuilder;
    private final ServiceReferenceBuilder serviceReferenceBuilder;
    private final Map messageDestinations = new HashMap();
    static final /* synthetic */ boolean $assertionsDisabled;

    public RefContext(EJBReferenceBuilder ejbReferenceBuilder, ResourceReferenceBuilder resourceReferenceBuilder, ServiceReferenceBuilder serviceReferenceBuilder) {
        if (!$assertionsDisabled && ejbReferenceBuilder == null) {
            throw new AssertionError((Object)"ejbReferenceBuilder is null");
        }
        if (!$assertionsDisabled && resourceReferenceBuilder == null) {
            throw new AssertionError((Object)"resourceReferenceBuilder is null");
        }
        if (!$assertionsDisabled && serviceReferenceBuilder == null) {
            throw new AssertionError((Object)"serviceReferenceBuilder is null");
        }
        this.ejbReferenceBuilder = ejbReferenceBuilder;
        this.resourceReferenceBuilder = resourceReferenceBuilder;
        this.serviceReferenceBuilder = serviceReferenceBuilder;
    }

    public void registerMessageDestionations(String moduleName, Map nameMap) throws DeploymentException {
        this.messageDestinations.put(moduleName, nameMap);
    }

    public Reference getCORBARemoteRef(Configuration configuration, AbstractNameQuery cssNameQuery, URI nsCorbaloc, String objectName, String home) throws DeploymentException {
        return this.ejbReferenceBuilder.createCORBAReference(configuration, cssNameQuery, nsCorbaloc, objectName, home);
    }

    public Reference getEJBRemoteRef(String refName, Configuration configuration, String name, String requiredModule, String optionalModule, Artifact targetConfigId, AbstractNameQuery query, boolean isSession, String home, String remote) throws DeploymentException {
        return this.ejbReferenceBuilder.createEJBRemoteRef(refName, configuration, name, requiredModule, optionalModule, targetConfigId, query, isSession, home, remote);
    }

    public Reference getEJBLocalRef(String refName, Configuration configuration, String name, String requiredModule, String optionalModule, Artifact targetConfigId, AbstractNameQuery query, boolean isSession, String localHome, String local) throws DeploymentException {
        return this.ejbReferenceBuilder.createEJBLocalRef(refName, configuration, name, requiredModule, optionalModule, targetConfigId, query, isSession, localHome, local);
    }

    public Reference getConnectionFactoryRef(AbstractNameQuery containerId, Class iface, Configuration configuration) throws DeploymentException {
        return this.resourceReferenceBuilder.createResourceRef(containerId, iface, configuration);
    }

    public Reference getAdminObjectRef(AbstractNameQuery containerId, Class iface, Configuration configuration) throws DeploymentException {
        return this.resourceReferenceBuilder.createAdminObjectRef(containerId, iface, configuration);
    }

    public Object getServiceReference(Class serviceInterface, URI wsdlURI, URI jaxrpcMappingURI, QName serviceQName, Map portComponentRefMap, List handlerInfos, Object serviceRefType, DeploymentContext deploymentContext, Module module, ClassLoader classLoader) throws DeploymentException {
        return this.serviceReferenceBuilder.createService(serviceInterface, wsdlURI, jaxrpcMappingURI, serviceQName, portComponentRefMap, handlerInfos, serviceRefType, deploymentContext, module, classLoader);
    }

    public Object getMessageDestination(String messageDestinationLink) throws DeploymentException {
        Object destination = null;
        int pos = messageDestinationLink.indexOf(35);
        if (pos > -1) {
            String targetModule = messageDestinationLink.substring(0, pos);
            Map destinations = (Map)this.messageDestinations.get(targetModule);
            if (destinations == null) {
                StringBuffer sb = new StringBuffer();
                Iterator mapIterator = this.messageDestinations.keySet().iterator();
                while (mapIterator.hasNext()) {
                    sb.append(mapIterator.next()).append("\n");
                }
                throw new DeploymentException("Unknown module " + targetModule + " when processing message destination " + messageDestinationLink + "\nKnown modules in deployable unit are:\n" + sb.toString());
            }
            messageDestinationLink = messageDestinationLink.substring(pos + 1);
            destination = destinations.get(messageDestinationLink);
        } else {
            Iterator iterator = this.messageDestinations.values().iterator();
            while (iterator.hasNext()) {
                Map destinations = (Map)iterator.next();
                Object destinationTest = destinations.get(messageDestinationLink);
                if (destinationTest == null) continue;
                if (destination != null) {
                    throw new DeploymentException("Duplicate message destination " + messageDestinationLink + " accessed from a message-destination-link without a module");
                }
                destination = destinationTest;
            }
        }
        return destination;
    }

    public GBeanData getActivationSpecInfo(AbstractNameQuery resourceAdapterInstanceName, String messageListenerInterfaceName, Configuration configuration) throws DeploymentException {
        return this.resourceReferenceBuilder.locateActivationSpecInfo(resourceAdapterInstanceName, messageListenerInterfaceName, configuration);
    }

    public AbstractName getMEJBName(Configuration configuration) throws DeploymentException {
        AbstractNameQuery query = new AbstractNameQuery(null, Collections.singletonMap("name", "ejb/mgmt/MEJB"), (String)null);
        try {
            return configuration.findGBean(query);
        }
        catch (GBeanNotFoundException e) {
            throw new DeploymentException("Could not locate a MEJB in the configuration ancestors");
        }
    }

    static {
        $assertionsDisabled = !RefContext.class.desiredAssertionStatus();
    }
}

