/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.j2ee.deployment;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.DeploymentContext;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.j2ee.deployment.RefContext;
import org.apache.geronimo.kernel.Naming;
import org.apache.geronimo.kernel.config.ConfigurationManager;
import org.apache.geronimo.kernel.config.ConfigurationModuleType;
import org.apache.geronimo.kernel.repository.Environment;
import org.apache.geronimo.security.deployment.SecurityConfiguration;

public class EARContext
extends DeploymentContext {
    private final AbstractNameQuery transactionContextManagerObjectName;
    private final AbstractNameQuery connectionTrackerObjectName;
    private final AbstractNameQuery transactedTimerName;
    private final AbstractNameQuery nonTransactedTimerName;
    private final AbstractNameQuery corbaGBeanObjectName;
    private final RefContext refContext;
    private final AbstractName moduleName;
    private final AbstractNameQuery serverName;
    private final Map contextIDToPermissionsMap = new HashMap();
    private AbstractName jaccManagerName;
    private SecurityConfiguration securityConfiguration;

    public EARContext(File baseDir, File inPlaceConfigurationDir, Environment environment, ConfigurationModuleType moduleType, Naming naming, ConfigurationManager configurationManager, Collection repositories, AbstractNameQuery serverName, AbstractName baseName, AbstractNameQuery transactionContextManagerObjectName, AbstractNameQuery connectionTrackerObjectName, AbstractNameQuery transactedTimerName, AbstractNameQuery nonTransactedTimerName, AbstractNameQuery corbaGBeanObjectName, RefContext refContext) throws DeploymentException {
        super(baseDir, inPlaceConfigurationDir, environment, moduleType, naming, configurationManager, repositories);
        this.moduleName = baseName;
        this.serverName = serverName;
        this.transactionContextManagerObjectName = transactionContextManagerObjectName;
        this.connectionTrackerObjectName = connectionTrackerObjectName;
        this.transactedTimerName = transactedTimerName;
        this.nonTransactedTimerName = nonTransactedTimerName;
        this.corbaGBeanObjectName = corbaGBeanObjectName;
        this.refContext = refContext;
    }

    public EARContext(File baseDir, File inPlaceConfigurationDir, Environment environment, ConfigurationModuleType moduleType, Naming naming, ConfigurationManager configurationManager, AbstractNameQuery serverName, AbstractName baseName, AbstractNameQuery transactionContextManagerObjectName, AbstractNameQuery connectionTrackerObjectName, AbstractNameQuery transactedTimerName, AbstractNameQuery nonTransactedTimerName, AbstractNameQuery corbaGBeanObjectName, RefContext refContext) throws DeploymentException {
        super(baseDir, inPlaceConfigurationDir, environment, moduleType, naming, configurationManager);
        this.moduleName = baseName;
        this.serverName = serverName;
        this.transactionContextManagerObjectName = transactionContextManagerObjectName;
        this.connectionTrackerObjectName = connectionTrackerObjectName;
        this.transactedTimerName = transactedTimerName;
        this.nonTransactedTimerName = nonTransactedTimerName;
        this.corbaGBeanObjectName = corbaGBeanObjectName;
        this.refContext = refContext;
    }

    public EARContext(File baseDir, File inPlaceConfigurationDir, Environment environment, ConfigurationModuleType moduleType, AbstractName baseName, EARContext parent) throws DeploymentException {
        super(baseDir, inPlaceConfigurationDir, environment, moduleType, parent.getNaming(), parent.getConfigurationManager());
        this.moduleName = baseName;
        this.serverName = parent.getServerName();
        this.transactionContextManagerObjectName = parent.getTransactionContextManagerObjectName();
        this.connectionTrackerObjectName = parent.getConnectionTrackerObjectName();
        this.transactedTimerName = parent.getTransactedTimerName();
        this.nonTransactedTimerName = parent.getNonTransactedTimerName();
        this.corbaGBeanObjectName = parent.getCORBAGBeanObjectName();
        this.refContext = parent.getRefContext();
    }

    public AbstractNameQuery getServerName() {
        return this.serverName;
    }

    public AbstractNameQuery getTransactionContextManagerObjectName() {
        return this.transactionContextManagerObjectName;
    }

    public AbstractNameQuery getConnectionTrackerObjectName() {
        return this.connectionTrackerObjectName;
    }

    public AbstractNameQuery getTransactedTimerName() {
        return this.transactedTimerName;
    }

    public AbstractNameQuery getNonTransactedTimerName() {
        return this.nonTransactedTimerName;
    }

    public AbstractNameQuery getCORBAGBeanObjectName() {
        return this.corbaGBeanObjectName;
    }

    public RefContext getRefContext() {
        return this.refContext;
    }

    public AbstractName getModuleName() {
        return this.moduleName;
    }

    public Map getContextIDToPermissionsMap() {
        return this.contextIDToPermissionsMap;
    }

    public void addSecurityContext(String contextID, Object componentPermissions) throws DeploymentException {
        Object old = this.contextIDToPermissionsMap.put(contextID, componentPermissions);
        if (old != null) {
            throw new DeploymentException("Duplicate contextID registered! " + contextID);
        }
    }

    public void setJaccManagerName(AbstractName jaccManagerName) {
        this.jaccManagerName = jaccManagerName;
    }

    public AbstractName getJaccManagerName() {
        return this.jaccManagerName;
    }

    public void setSecurityConfiguration(SecurityConfiguration securityConfiguration) throws DeploymentException {
        if (this.securityConfiguration != null) {
            throw new DeploymentException("Only one security configuration allowed per application");
        }
        this.securityConfiguration = securityConfiguration;
    }

    public SecurityConfiguration getSecurityConfiguration() {
        return this.securityConfiguration;
    }
}

