/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.j2ee.deployment;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.jar.JarFile;
import org.apache.geronimo.deployment.DeploymentContext;
import org.apache.geronimo.deployment.util.DeploymentUtil;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.j2ee.deployment.EARContext;
import org.apache.geronimo.kernel.config.ConfigurationModuleType;
import org.apache.geronimo.kernel.repository.Environment;
import org.apache.xmlbeans.XmlObject;

public abstract class Module {
    private final boolean standAlone;
    private final AbstractName moduleName;
    private final String name;
    private final Environment environment;
    private final URI moduleURI;
    private final JarFile moduleFile;
    private final String targetPath;
    private final URI targetPathURI;
    private final XmlObject specDD;
    private final XmlObject vendorDD;
    private final String originalSpecDD;
    private final String namespace;
    private EARContext earContext;
    private URI uniqueModuleLocation;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected Module(boolean standAlone, AbstractName moduleName, Environment environment, JarFile moduleFile, String targetPath, XmlObject specDD, XmlObject vendorDD, String originalSpecDD, String namespace) {
        if (!$assertionsDisabled && targetPath == null) {
            throw new AssertionError((Object)"targetPath is null");
        }
        if (!$assertionsDisabled && moduleName == null) {
            throw new AssertionError((Object)"moduleName is null");
        }
        this.standAlone = standAlone;
        this.moduleName = moduleName;
        this.environment = environment;
        this.moduleFile = moduleFile;
        this.targetPath = targetPath;
        this.specDD = specDD;
        this.vendorDD = vendorDD;
        this.originalSpecDD = originalSpecDD;
        this.namespace = namespace;
        if (standAlone) {
            this.name = environment.getConfigId().toString();
            this.moduleURI = URI.create("");
        } else {
            this.name = targetPath;
            this.moduleURI = URI.create(targetPath);
        }
        this.targetPathURI = URI.create(targetPath + "/");
    }

    public abstract ConfigurationModuleType getType();

    public String getName() {
        return this.name;
    }

    public boolean isStandAlone() {
        return this.standAlone;
    }

    public AbstractName getModuleName() {
        return this.moduleName;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public URI getModuleURI() {
        return this.moduleURI;
    }

    public JarFile getModuleFile() {
        return this.moduleFile;
    }

    public String getTargetPath() {
        return this.targetPath;
    }

    public URI getTargetPathURI() {
        return this.targetPathURI;
    }

    public XmlObject getSpecDD() {
        return this.specDD;
    }

    public XmlObject getVendorDD() {
        return this.vendorDD;
    }

    public String getOriginalSpecDD() {
        return this.originalSpecDD;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Module) {
            Module module = (Module)obj;
            return this.name.equals(module.name);
        }
        return false;
    }

    public void close() {
        DeploymentUtil.close((JarFile)this.moduleFile);
    }

    public void addClass(String fqcn, byte[] bytes, DeploymentContext context) throws IOException, URISyntaxException {
        URI location = this.getUniqueModuleLocation(context);
        this.addClass(location, fqcn, bytes, context);
    }

    private URI getUniqueModuleLocation(DeploymentContext context) throws IOException {
        if (this.uniqueModuleLocation == null) {
            URI generatedUri;
            File generatedDir;
            URI metainfUri = URI.create("META-INF/");
            File metainfDir = context.getTargetFile(metainfUri);
            if (!metainfDir.exists()) {
                metainfDir.mkdirs();
            }
            if (!metainfDir.isDirectory()) {
                throw new IOException("META-INF directory exists but is not a directory: " + metainfDir.getAbsolutePath());
            }
            if (!metainfDir.canRead()) {
                throw new IOException("META-INF directory is not readable: " + metainfDir.getAbsolutePath());
            }
            if (!metainfDir.canWrite()) {
                throw new IOException("META-INF directory is not writable: " + metainfDir.getAbsolutePath());
            }
            String suffix = "";
            int i = 0;
            do {
                generatedUri = metainfUri.resolve("geronimo-generated" + suffix + "/");
                generatedDir = context.getTargetFile(generatedUri);
                suffix = "" + i++;
            } while (generatedDir.exists());
            generatedDir.mkdirs();
            if (!generatedDir.isDirectory()) {
                throw new IOException("Geronimo generated classes directory exists but is not a directory: " + generatedDir.getAbsolutePath());
            }
            if (!generatedDir.canRead()) {
                throw new IOException("Geronimo generated classes directory is not readable: " + generatedDir.getAbsolutePath());
            }
            if (!generatedDir.canWrite()) {
                throw new IOException("Geronimo generated classes directory is not writable: " + generatedDir.getAbsolutePath());
            }
            this.uniqueModuleLocation = generatedUri;
        }
        return this.uniqueModuleLocation;
    }

    public EARContext getEarContext() {
        return this.earContext;
    }

    public void setEarContext(EARContext earContext) {
        this.earContext = earContext;
    }

    public abstract void addClass(URI var1, String var2, byte[] var3, DeploymentContext var4) throws IOException, URISyntaxException;

    static {
        $assertionsDisabled = !Module.class.desiredAssertionStatus();
    }
}

