/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.j2ee.deployment;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.ConfigurationBuilder;
import org.apache.geronimo.deployment.DeploymentContext;
import org.apache.geronimo.deployment.ModuleIDBuilder;
import org.apache.geronimo.deployment.service.EnvironmentBuilder;
import org.apache.geronimo.deployment.service.ServiceConfigBuilder;
import org.apache.geronimo.deployment.util.DeploymentUtil;
import org.apache.geronimo.deployment.util.NestedJarFile;
import org.apache.geronimo.deployment.xbeans.ArtifactType;
import org.apache.geronimo.deployment.xbeans.EnvironmentType;
import org.apache.geronimo.deployment.xbeans.GbeanType;
import org.apache.geronimo.deployment.xmlbeans.XmlBeansUtil;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.ReferencePatterns;
import org.apache.geronimo.gbean.SingleElementCollection;
import org.apache.geronimo.j2ee.ApplicationInfo;
import org.apache.geronimo.j2ee.deployment.AppClientModule;
import org.apache.geronimo.j2ee.deployment.ConnectorModule;
import org.apache.geronimo.j2ee.deployment.EARContext;
import org.apache.geronimo.j2ee.deployment.EJBModule;
import org.apache.geronimo.j2ee.deployment.EJBReferenceBuilder;
import org.apache.geronimo.j2ee.deployment.Module;
import org.apache.geronimo.j2ee.deployment.ModuleBuilder;
import org.apache.geronimo.j2ee.deployment.RefContext;
import org.apache.geronimo.j2ee.deployment.ResourceReferenceBuilder;
import org.apache.geronimo.j2ee.deployment.ServiceReferenceBuilder;
import org.apache.geronimo.j2ee.deployment.WebModule;
import org.apache.geronimo.j2ee.management.impl.J2EEApplicationImpl;
import org.apache.geronimo.kernel.GBeanAlreadyExistsException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.Naming;
import org.apache.geronimo.kernel.config.ConfigurationAlreadyExistsException;
import org.apache.geronimo.kernel.config.ConfigurationData;
import org.apache.geronimo.kernel.config.ConfigurationManager;
import org.apache.geronimo.kernel.config.ConfigurationModuleType;
import org.apache.geronimo.kernel.config.ConfigurationStore;
import org.apache.geronimo.kernel.config.ConfigurationUtil;
import org.apache.geronimo.kernel.config.SimpleConfigurationManager;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.ArtifactResolver;
import org.apache.geronimo.kernel.repository.Environment;
import org.apache.geronimo.kernel.repository.Repository;
import org.apache.geronimo.management.J2EEResource;
import org.apache.geronimo.management.J2EEServer;
import org.apache.geronimo.management.geronimo.ResourceAdapterModule;
import org.apache.geronimo.schema.SchemaConversionUtils;
import org.apache.geronimo.security.deployment.SecurityBuilder;
import org.apache.geronimo.security.deployment.SecurityConfiguration;
import org.apache.geronimo.xbeans.geronimo.j2ee.GerApplicationDocument;
import org.apache.geronimo.xbeans.geronimo.j2ee.GerApplicationType;
import org.apache.geronimo.xbeans.geronimo.j2ee.GerExtModuleType;
import org.apache.geronimo.xbeans.geronimo.j2ee.GerModuleType;
import org.apache.geronimo.xbeans.geronimo.security.GerSecurityType;
import org.apache.geronimo.xbeans.j2ee.ApplicationType;
import org.apache.geronimo.xbeans.j2ee.ModuleType;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;

public class EARConfigBuilder
implements ConfigurationBuilder {
    private static final Log log;
    private static final String LINE_SEP;
    private static final QName APPLICATION_QNAME;
    private final ConfigurationManager configurationManager;
    private final Collection repositories;
    private final SingleElementCollection ejbConfigBuilder;
    private final SingleElementCollection webConfigBuilder;
    private final SingleElementCollection connectorConfigBuilder;
    private final SingleElementCollection appClientConfigBuilder;
    private final SingleElementCollection ejbReferenceBuilder;
    private final SingleElementCollection resourceReferenceBuilder;
    private final SingleElementCollection serviceReferenceBuilder;
    private final Environment defaultEnvironment;
    private final AbstractNameQuery serverName;
    private final AbstractNameQuery transactionContextManagerObjectName;
    private final AbstractNameQuery connectionTrackerObjectName;
    private final AbstractNameQuery transactionalTimerObjectName;
    private final AbstractNameQuery nonTransactionalTimerObjectName;
    private final AbstractNameQuery corbaGBeanObjectName;
    private final Naming naming;
    public static final GBeanInfo GBEAN_INFO;
    static final /* synthetic */ boolean $assertionsDisabled;

    public EARConfigBuilder(Environment defaultEnvironment, AbstractNameQuery transactionContextManagerAbstractName, AbstractNameQuery connectionTrackerAbstractName, AbstractNameQuery transactionalTimerAbstractName, AbstractNameQuery nonTransactionalTimerAbstractName, AbstractNameQuery corbaGBeanAbstractName, AbstractNameQuery serverName, Collection repositories, Collection ejbConfigBuilder, Collection ejbReferenceBuilder, Collection webConfigBuilder, Collection connectorConfigBuilder, Collection resourceReferenceBuilder, Collection appClientConfigBuilder, Collection serviceReferenceBuilder, Kernel kernel) {
        this(defaultEnvironment, transactionContextManagerAbstractName, connectionTrackerAbstractName, transactionalTimerAbstractName, nonTransactionalTimerAbstractName, corbaGBeanAbstractName, serverName, ConfigurationUtil.getConfigurationManager((Kernel)kernel), repositories, new SingleElementCollection(ejbConfigBuilder), new SingleElementCollection(ejbReferenceBuilder), new SingleElementCollection(webConfigBuilder), new SingleElementCollection(connectorConfigBuilder), new SingleElementCollection(resourceReferenceBuilder), new SingleElementCollection(appClientConfigBuilder), new SingleElementCollection(serviceReferenceBuilder), kernel.getNaming());
    }

    public EARConfigBuilder(Environment defaultEnvironment, AbstractNameQuery transactionContextManagerAbstractName, AbstractNameQuery connectionTrackerAbstractName, AbstractNameQuery transactionalTimerAbstractName, AbstractNameQuery nonTransactionalTimerAbstractName, AbstractNameQuery corbaGBeanAbstractName, AbstractNameQuery serverName, Collection repositories, ModuleBuilder ejbConfigBuilder, EJBReferenceBuilder ejbReferenceBuilder, ModuleBuilder webConfigBuilder, ModuleBuilder connectorConfigBuilder, ResourceReferenceBuilder resourceReferenceBuilder, ModuleBuilder appClientConfigBuilder, ServiceReferenceBuilder serviceReferenceBuilder, Naming naming) {
        this(defaultEnvironment, transactionContextManagerAbstractName, connectionTrackerAbstractName, transactionalTimerAbstractName, nonTransactionalTimerAbstractName, corbaGBeanAbstractName, serverName, null, repositories, new SingleElementCollection((Object)ejbConfigBuilder), new SingleElementCollection((Object)ejbReferenceBuilder), new SingleElementCollection((Object)webConfigBuilder), new SingleElementCollection((Object)connectorConfigBuilder), new SingleElementCollection((Object)resourceReferenceBuilder), new SingleElementCollection((Object)appClientConfigBuilder), new SingleElementCollection((Object)serviceReferenceBuilder), naming);
    }

    private EARConfigBuilder(Environment defaultEnvironment, AbstractNameQuery transactionContextManagerAbstractName, AbstractNameQuery connectionTrackerAbstractName, AbstractNameQuery transactionalTimerAbstractName, AbstractNameQuery nonTransactionalTimerAbstractName, AbstractNameQuery corbaGBeanAbstractName, AbstractNameQuery serverName, ConfigurationManager configurationManager, Collection repositories, SingleElementCollection ejbConfigBuilder, SingleElementCollection ejbReferenceBuilder, SingleElementCollection webConfigBuilder, SingleElementCollection connectorConfigBuilder, SingleElementCollection resourceReferenceBuilder, SingleElementCollection appClientConfigBuilder, SingleElementCollection serviceReferenceBuilder, Naming naming) {
        this.configurationManager = configurationManager;
        this.repositories = repositories;
        this.defaultEnvironment = defaultEnvironment;
        this.ejbConfigBuilder = ejbConfigBuilder;
        this.ejbReferenceBuilder = ejbReferenceBuilder;
        this.resourceReferenceBuilder = resourceReferenceBuilder;
        this.webConfigBuilder = webConfigBuilder;
        this.connectorConfigBuilder = connectorConfigBuilder;
        this.appClientConfigBuilder = appClientConfigBuilder;
        this.serviceReferenceBuilder = serviceReferenceBuilder;
        this.transactionContextManagerObjectName = transactionContextManagerAbstractName;
        this.connectionTrackerObjectName = connectionTrackerAbstractName;
        this.transactionalTimerObjectName = transactionalTimerAbstractName;
        this.nonTransactionalTimerObjectName = nonTransactionalTimerAbstractName;
        this.corbaGBeanObjectName = corbaGBeanAbstractName;
        this.serverName = serverName;
        this.naming = naming;
    }

    private ModuleBuilder getEjbConfigBuilder() {
        return (ModuleBuilder)this.ejbConfigBuilder.getElement();
    }

    private ModuleBuilder getWebConfigBuilder() {
        return (ModuleBuilder)this.webConfigBuilder.getElement();
    }

    private ModuleBuilder getConnectorConfigBuilder() {
        return (ModuleBuilder)this.connectorConfigBuilder.getElement();
    }

    private ModuleBuilder getAppClientConfigBuilder() {
        return (ModuleBuilder)this.appClientConfigBuilder.getElement();
    }

    private EJBReferenceBuilder getEjbReferenceBuilder() {
        return (EJBReferenceBuilder)this.ejbReferenceBuilder.getElement();
    }

    private ResourceReferenceBuilder getResourceReferenceBuilder() {
        return (ResourceReferenceBuilder)this.resourceReferenceBuilder.getElement();
    }

    private ServiceReferenceBuilder getServiceReferenceBuilder() {
        return (ServiceReferenceBuilder)this.serviceReferenceBuilder.getElement();
    }

    public Object getDeploymentPlan(File planFile, JarFile jarFile, ModuleIDBuilder idBuilder) throws DeploymentException {
        if (planFile == null && jarFile == null) {
            return null;
        }
        ApplicationInfo plan = this.getEarPlan(planFile, jarFile, idBuilder);
        if (plan != null) {
            return plan;
        }
        if (jarFile == null) {
            return null;
        }
        Module module = null;
        if (this.getWebConfigBuilder() != null) {
            module = this.getWebConfigBuilder().createModule(planFile, jarFile, this.naming, idBuilder);
        }
        if (module == null && this.getEjbConfigBuilder() != null) {
            module = this.getEjbConfigBuilder().createModule(planFile, jarFile, this.naming, idBuilder);
        }
        if (module == null && this.getConnectorConfigBuilder() != null) {
            module = this.getConnectorConfigBuilder().createModule(planFile, jarFile, this.naming, idBuilder);
        }
        if (module == null && this.getAppClientConfigBuilder() != null) {
            module = this.getAppClientConfigBuilder().createModule(planFile, jarFile, this.naming, idBuilder);
        }
        if (module == null) {
            return null;
        }
        return new ApplicationInfo(module.getType(), module.getEnvironment(), module.getModuleName(), null, null, new LinkedHashSet<Module>(Collections.singleton(module)), Collections.EMPTY_SET, null);
    }

    private ApplicationInfo getEarPlan(File planFile, JarFile earFile, ModuleIDBuilder idBuilder) throws DeploymentException {
        ApplicationType application = null;
        if (earFile != null) {
            String specDD;
            try {
                URL applicationXmlUrl = DeploymentUtil.createJarURL((JarFile)earFile, (String)"META-INF/application.xml");
                specDD = DeploymentUtil.readAll((URL)applicationXmlUrl);
            }
            catch (Exception e) {
                return null;
            }
            try {
                XmlObject xmlObject = XmlBeansUtil.parse((String)specDD);
                application = SchemaConversionUtils.convertToApplicationSchema((XmlObject)xmlObject).getApplication();
            }
            catch (XmlException e) {
                throw new DeploymentException("Could not parse application.xml", (Throwable)e);
            }
        }
        GerApplicationType gerApplication = null;
        try {
            try {
                XmlObject rawPlan;
                if (planFile != null) {
                    rawPlan = XmlBeansUtil.parse((URL)planFile.toURL());
                    gerApplication = (GerApplicationType)SchemaConversionUtils.fixGeronimoSchema((XmlObject)rawPlan, (QName)APPLICATION_QNAME, (SchemaType)GerApplicationType.type);
                    if (gerApplication == null) {
                        return null;
                    }
                } else {
                    URL path = DeploymentUtil.createJarURL((JarFile)earFile, (String)"META-INF/geronimo-application.xml");
                    rawPlan = XmlBeansUtil.parse((URL)path);
                    gerApplication = (GerApplicationType)SchemaConversionUtils.fixGeronimoSchema((XmlObject)rawPlan, (QName)APPLICATION_QNAME, (SchemaType)GerApplicationType.type);
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            if (gerApplication == null) {
                gerApplication = this.createDefaultPlan(application, earFile);
            }
        }
        catch (XmlException e) {
            throw new DeploymentException((Throwable)e);
        }
        EnvironmentType environmentType = gerApplication.getEnvironment();
        Environment environment = EnvironmentBuilder.buildEnvironment((EnvironmentType)environmentType, (Environment)this.defaultEnvironment);
        idBuilder.resolve(environment, earFile == null ? planFile.getName() : new File(earFile.getName()).getName(), "ear");
        idBuilder.setDefaultGroup(environment.getConfigId().getGroupId());
        idBuilder.setDefaultVersion(environment.getConfigId().getVersion());
        Artifact artifact = environment.getConfigId();
        AbstractName earName = this.naming.createRootName(artifact, artifact.toString(), "J2EEApplication");
        HashSet moduleLocations = new HashSet();
        LinkedHashSet modules = new LinkedHashSet();
        try {
            this.addModules(earFile, application, gerApplication, moduleLocations, modules, environment, earName, idBuilder);
        }
        catch (Throwable e) {
            Iterator iterator = modules.iterator();
            while (iterator.hasNext()) {
                Module module = (Module)iterator.next();
                module.close();
            }
            if (e instanceof DeploymentException) {
                throw (DeploymentException)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            throw new DeploymentException(e);
        }
        return new ApplicationInfo(ConfigurationModuleType.EAR, environment, earName, (XmlObject)application, gerApplication, modules, moduleLocations, application == null ? null : application.toString());
    }

    private GerApplicationType createDefaultPlan(ApplicationType application, JarFile module) {
        GerApplicationType gerApplication = GerApplicationType.Factory.newInstance();
        EnvironmentType environmentType = gerApplication.addNewEnvironment();
        ArtifactType artifactType = environmentType.addNewModuleId();
        artifactType.setGroupId("default");
        String id = application.getId();
        if (id == null) {
            File fileName = new File(module.getName());
            id = fileName.getName();
            if (id.endsWith(".ear")) {
                id = id.substring(0, id.length() - 4);
            }
            if (id.endsWith("/")) {
                id = id.substring(0, id.length() - 1);
            }
        }
        artifactType.setArtifactId(id);
        artifactType.setVersion("" + System.currentTimeMillis());
        artifactType.setType("car");
        return gerApplication;
    }

    public Artifact getConfigurationID(Object plan, JarFile module, ModuleIDBuilder idBuilder) throws IOException, DeploymentException {
        ApplicationInfo applicationInfo = (ApplicationInfo)plan;
        Artifact test = applicationInfo.getEnvironment().getConfigId();
        if (!test.isResolved()) {
            throw new IllegalStateException("Module ID should be fully resolved by now (not " + test + ")");
        }
        return test;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DeploymentContext buildConfiguration(boolean inPlaceDeployment, Artifact configId, Object plan, JarFile earFile, Collection configurationStores, ArtifactResolver artifactResolver, ConfigurationStore targetConfigurationStore) throws IOException, DeploymentException {
        File configurationDir;
        if (!$assertionsDisabled && plan == null) {
            throw new AssertionError();
        }
        ApplicationInfo applicationInfo = (ApplicationInfo)plan;
        EARContext earContext = null;
        ConfigurationModuleType applicationType = applicationInfo.getType();
        applicationInfo.getEnvironment().setConfigId(configId);
        try {
            configurationDir = targetConfigurationStore.createNewConfigurationDir(configId);
        }
        catch (ConfigurationAlreadyExistsException e) {
            throw new DeploymentException((Throwable)e);
        }
        ConfigurationManager configurationManager = this.configurationManager;
        if (configurationManager == null) {
            configurationManager = new SimpleConfigurationManager(configurationStores, artifactResolver, this.repositories);
        }
        try {
            EARContext eARContext;
            try {
                Module module;
                earContext = new EARContext(configurationDir, inPlaceDeployment ? DeploymentUtil.toFile((JarFile)earFile) : null, applicationInfo.getEnvironment(), applicationType, this.naming, configurationManager, this.repositories, this.serverName, applicationInfo.getBaseName(), this.transactionContextManagerObjectName, this.connectionTrackerObjectName, this.transactionalTimerObjectName, this.nonTransactionalTimerObjectName, this.corbaGBeanObjectName, new RefContext(this.getEjbReferenceBuilder(), this.getResourceReferenceBuilder(), this.getServiceReferenceBuilder()));
                Set moduleLocations = applicationInfo.getModuleLocations();
                if (ConfigurationModuleType.EAR == applicationType && earFile != null) {
                    Enumeration<JarEntry> e = earFile.entries();
                    while (e.hasMoreElements()) {
                        ZipEntry entry = e.nextElement();
                        String entryName = entry.getName();
                        boolean addEntry = true;
                        Iterator iter = moduleLocations.iterator();
                        while (iter.hasNext()) {
                            String location = (String)iter.next();
                            if (!entryName.startsWith(location)) continue;
                            addEntry = false;
                            break;
                        }
                        if (!addEntry) continue;
                        earContext.addFile(URI.create(entry.getName()), earFile, entry);
                    }
                }
                GerApplicationType geronimoApplication = (GerApplicationType)applicationInfo.getVendorDD();
                LinkedHashSet modules = applicationInfo.getModules();
                Iterator iterator = modules.iterator();
                while (iterator.hasNext()) {
                    Module module2 = (Module)iterator.next();
                    this.getBuilder(module2).installModule(earFile, earContext, module2, configurationStores, targetConfigurationStore, this.repositories);
                }
                earContext.flush();
                ClassLoader cl = earContext.getClassLoader();
                Iterator iterator2 = modules.iterator();
                while (iterator2.hasNext()) {
                    module = (Module)iterator2.next();
                    this.getBuilder(module).initContext(earContext, module, cl);
                }
                if (geronimoApplication != null) {
                    GbeanType[] gbeans = geronimoApplication.getGbeanArray();
                    ServiceConfigBuilder.addGBeans((GbeanType[])gbeans, (ClassLoader)cl, (AbstractName)earContext.getModuleName(), (DeploymentContext)earContext);
                }
                if (ConfigurationModuleType.EAR == applicationType) {
                    GBeanData gbeanData = new GBeanData(earContext.getModuleName(), J2EEApplicationImpl.GBEAN_INFO);
                    try {
                        String originalSpecDD = applicationInfo.getOriginalSpecDD();
                        if (originalSpecDD == null) {
                            originalSpecDD = "Synthetic EAR";
                        }
                        gbeanData.setAttribute("deploymentDescriptor", (Object)originalSpecDD);
                    }
                    catch (Exception e) {
                        throw new DeploymentException("Error initializing J2EEApplication managed object");
                    }
                    gbeanData.setReferencePatterns("Server", new ReferencePatterns(new AbstractNameQuery(J2EEServer.class.getName())));
                    Map<String, String> thisApp = Collections.singletonMap("J2EEApplication", earContext.getModuleName().getNameProperty("name"));
                    LinkedHashSet<AbstractNameQuery> resourcePatterns = new LinkedHashSet<AbstractNameQuery>();
                    resourcePatterns.add(new AbstractNameQuery(null, EARConfigBuilder.filter(thisApp, "j2eeType", "JavaMailResource"), J2EEResource.class.getName()));
                    resourcePatterns.add(new AbstractNameQuery(null, EARConfigBuilder.filter(thisApp, "j2eeType", "JCAConnectionFactory"), J2EEResource.class.getName()));
                    resourcePatterns.add(new AbstractNameQuery(null, EARConfigBuilder.filter(thisApp, "j2eeType", "JDBCResource"), J2EEResource.class.getName()));
                    resourcePatterns.add(new AbstractNameQuery(null, EARConfigBuilder.filter(thisApp, "j2eeType", "JDBCDriver"), J2EEResource.class.getName()));
                    resourcePatterns.add(new AbstractNameQuery(null, EARConfigBuilder.filter(thisApp, "j2eeType", "JMSResource"), J2EEResource.class.getName()));
                    resourcePatterns.add(new AbstractNameQuery(null, EARConfigBuilder.filter(thisApp, "j2eeType", "JNDIResource"), J2EEResource.class.getName()));
                    resourcePatterns.add(new AbstractNameQuery(null, EARConfigBuilder.filter(thisApp, "j2eeType", "JTAResource"), J2EEResource.class.getName()));
                    resourcePatterns.add(new AbstractNameQuery(null, EARConfigBuilder.filter(thisApp, "j2eeType", "RMI_IIOPResource"), J2EEResource.class.getName()));
                    resourcePatterns.add(new AbstractNameQuery(null, EARConfigBuilder.filter(thisApp, "j2eeType", "URLResource"), J2EEResource.class.getName()));
                    gbeanData.setReferencePatterns("Resources", resourcePatterns);
                    gbeanData.setReferencePatterns("AppClientModules", new ReferencePatterns(new AbstractNameQuery(null, thisApp, org.apache.geronimo.management.AppClientModule.class.getName())));
                    gbeanData.setReferencePatterns("EJBModules", new ReferencePatterns(new AbstractNameQuery(null, thisApp, org.apache.geronimo.management.EJBModule.class.getName())));
                    gbeanData.setReferencePatterns("ResourceAdapterModules", new ReferencePatterns(new AbstractNameQuery(null, thisApp, ResourceAdapterModule.class.getName())));
                    gbeanData.setReferencePatterns("WebModules", new ReferencePatterns(new AbstractNameQuery(null, thisApp, org.apache.geronimo.management.geronimo.WebModule.class.getName())));
                    earContext.addGBean(gbeanData);
                }
                if (geronimoApplication != null && geronimoApplication.isSetSecurity()) {
                    SecurityConfiguration securityConfiguration = SecurityBuilder.buildSecurityConfiguration((GerSecurityType)geronimoApplication.getSecurity(), (ClassLoader)cl);
                    earContext.setSecurityConfiguration(securityConfiguration);
                }
                if (earContext.getSecurityConfiguration() != null) {
                    GBeanData roleMapperData = SecurityBuilder.configureRoleMapper((Naming)this.naming, (AbstractName)earContext.getModuleName(), (SecurityConfiguration)earContext.getSecurityConfiguration());
                    earContext.addGBean(roleMapperData);
                    GBeanData jaccBeanData = SecurityBuilder.configureApplicationPolicyManager((Naming)this.naming, (AbstractName)earContext.getModuleName(), (Map)earContext.getContextIDToPermissionsMap(), (SecurityConfiguration)earContext.getSecurityConfiguration());
                    jaccBeanData.setReferencePattern("PrincipalRoleMapper", roleMapperData.getAbstractName());
                    earContext.addGBean(jaccBeanData);
                    earContext.setJaccManagerName(jaccBeanData.getAbstractName());
                }
                iterator2 = modules.iterator();
                while (iterator2.hasNext()) {
                    module = (Module)iterator2.next();
                    this.getBuilder(module).addGBeans(earContext, module, cl, this.repositories);
                }
                eARContext = earContext;
                Object var21_30 = null;
            }
            catch (GBeanAlreadyExistsException e) {
                this.cleanupContext(earContext, configurationDir);
                throw new DeploymentException((Throwable)e);
            }
            catch (IOException e) {
                this.cleanupContext(earContext, configurationDir);
                throw e;
            }
            catch (DeploymentException e) {
                this.cleanupContext(earContext, configurationDir);
                throw e;
            }
            catch (RuntimeException e) {
                this.cleanupContext(earContext, configurationDir);
                throw e;
            }
            catch (Error e) {
                this.cleanupContext(earContext, configurationDir);
                throw e;
            }
            LinkedHashSet modules = applicationInfo.getModules();
            Iterator iterator = modules.iterator();
            while (iterator.hasNext()) {
                Module module = (Module)iterator.next();
                module.close();
            }
            return eARContext;
        }
        catch (Throwable throwable) {
            Object var21_31 = null;
            LinkedHashSet modules = applicationInfo.getModules();
            Iterator iterator = modules.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    throw throwable;
                }
                Module module = (Module)iterator.next();
                module.close();
            }
        }
    }

    private void cleanupContext(EARContext earContext, File configurationDir) {
        ArrayList configurations = new ArrayList();
        if (earContext != null) {
            configurations.addAll(earContext.getAdditionalDeployment());
            try {
                earContext.close();
            }
            catch (IOException ioe) {
            }
            catch (DeploymentException de) {
                // empty catch block
            }
        }
        if (configurationDir != null) {
            this.cleanupConfigurationDir(configurationDir);
        }
        Iterator iterator = configurations.iterator();
        while (iterator.hasNext()) {
            ConfigurationData configurationData = (ConfigurationData)iterator.next();
            this.cleanupConfigurationDir(configurationData.getConfigurationDir());
        }
    }

    private boolean cleanupConfigurationDir(File configurationDir) {
        LinkedList cannotBeDeletedList = new LinkedList();
        if (!DeploymentUtil.recursiveDelete((File)configurationDir, cannotBeDeletedList)) {
            log.warn((Object)("Unable to delete " + cannotBeDeletedList.size() + " files while recursively deleting directory " + configurationDir + LINE_SEP + "The first file that could not be deleted was:" + LINE_SEP + "  " + (!cannotBeDeletedList.isEmpty() ? cannotBeDeletedList.getFirst() : "")));
            return false;
        }
        return true;
    }

    private static Map filter(Map original, String key, String value) {
        LinkedHashMap<String, String> filter = new LinkedHashMap<String, String>(original);
        filter.put(key, value);
        return filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void addModules(JarFile earFile, ApplicationType application, GerApplicationType gerApplication, Set moduleLocations, LinkedHashSet modules, Environment environment, AbstractName earName, ModuleIDBuilder idBuilder) throws DeploymentException {
        Iterator iterator3;
        HashMap<String, File> altVendorDDs = new HashMap<String, File>();
        try {
            Module module;
            if (earFile != null) {
                int i;
                ModuleType[] moduleTypes = application.getModuleArray();
                HashSet<String> paths = new HashSet<String>();
                for (int i2 = 0; i2 < moduleTypes.length; ++i2) {
                    ModuleType type = moduleTypes[i2];
                    if (type.isSetEjb()) {
                        paths.add(type.getEjb().getStringValue());
                        continue;
                    }
                    if (type.isSetWeb()) {
                        paths.add(type.getWeb().getWebUri().getStringValue());
                        continue;
                    }
                    if (type.isSetConnector()) {
                        paths.add(type.getConnector().getStringValue());
                        continue;
                    }
                    if (!type.isSetJava()) continue;
                    paths.add(type.getJava().getStringValue());
                }
                GerModuleType[] gerModuleTypes = gerApplication.getModuleArray();
                for (i = 0; i < gerModuleTypes.length; ++i) {
                    GerModuleType gerModule = gerModuleTypes[i];
                    String path = null;
                    if (gerModule.isSetEjb()) {
                        path = gerModule.getEjb().getStringValue();
                    } else if (gerModule.isSetWeb()) {
                        path = gerModule.getWeb().getStringValue();
                    } else if (gerModule.isSetConnector()) {
                        path = gerModule.getConnector().getStringValue();
                    } else if (gerModule.isSetJava()) {
                        path = gerModule.getJava().getStringValue();
                    }
                    if (!paths.contains(path)) {
                        throw new DeploymentException("Geronimo deployment plan refers to module '" + path + "' but that was not defined in the META-INF/application.xml");
                    }
                    if (gerModule.isSetAltDd()) {
                        try {
                            altVendorDDs.put(path, DeploymentUtil.toTempFile((JarFile)earFile, (String)gerModule.getAltDd().getStringValue()));
                            continue;
                        }
                        catch (IOException e) {
                            throw new DeploymentException("Invalid alt vendor dd url: " + gerModule.getAltDd().getStringValue(), (Throwable)e);
                        }
                    }
                    XmlObject[] anys = gerModule.selectChildren(GerModuleType.type.qnameSetForWildcardElements());
                    if (anys.length != 1) {
                        throw new DeploymentException("Unexpected count of xs:any elements in embedded vendor plan " + anys.length + " qnameset: " + GerModuleType.type.qnameSetForWildcardElements());
                    }
                    altVendorDDs.put(path, (File)anys[0]);
                }
                for (i = 0; i < moduleTypes.length; ++i) {
                    NestedJarFile moduleFile;
                    String moduleTypeName;
                    ModuleBuilder builder;
                    String modulePath;
                    ModuleType moduleXml = moduleTypes[i];
                    String moduleContextInfo = null;
                    if (moduleXml.isSetEjb()) {
                        modulePath = moduleXml.getEjb().getStringValue();
                        builder = this.getEjbConfigBuilder();
                        if (builder == null) {
                            throw new DeploymentException("Cannot deploy ejb application; No ejb deployer defined: " + modulePath);
                        }
                        moduleTypeName = "an EJB";
                    } else if (moduleXml.isSetWeb()) {
                        modulePath = moduleXml.getWeb().getWebUri().getStringValue();
                        if (this.getWebConfigBuilder() == null) {
                            throw new DeploymentException("Cannot deploy web application; No war deployer defined: " + modulePath);
                        }
                        builder = this.getWebConfigBuilder();
                        moduleTypeName = "a war";
                        moduleContextInfo = moduleXml.getWeb().getContextRoot().getStringValue().trim();
                    } else if (moduleXml.isSetConnector()) {
                        modulePath = moduleXml.getConnector().getStringValue();
                        if (this.getConnectorConfigBuilder() == null) {
                            throw new DeploymentException("Cannot deploy resource adapter; No rar deployer defined: " + modulePath);
                        }
                        builder = this.getConnectorConfigBuilder();
                        moduleTypeName = "a connector";
                    } else if (moduleXml.isSetJava()) {
                        modulePath = moduleXml.getJava().getStringValue();
                        if (this.getAppClientConfigBuilder() == null) {
                            throw new DeploymentException("Cannot deploy app client; No app client deployer defined: " + modulePath);
                        }
                        builder = this.getAppClientConfigBuilder();
                        moduleTypeName = "an application client";
                    } else {
                        throw new DeploymentException("Could not find a module builder for module: " + moduleXml);
                    }
                    moduleLocations.add(modulePath);
                    URL altSpecDD = null;
                    if (moduleXml.isSetAltDd()) {
                        try {
                            altSpecDD = DeploymentUtil.createJarURL((JarFile)earFile, (String)moduleXml.getAltDd().getStringValue());
                        }
                        catch (MalformedURLException e) {
                            throw new DeploymentException("Invalid alt sped dd url: " + moduleXml.getAltDd().getStringValue(), (Throwable)e);
                        }
                    }
                    try {
                        moduleFile = new NestedJarFile(earFile, modulePath);
                    }
                    catch (IOException e) {
                        throw new DeploymentException("Invalid moduleFile: " + modulePath, (Throwable)e);
                    }
                    module = builder.createModule(altVendorDDs.get(modulePath), (JarFile)moduleFile, modulePath, altSpecDD, environment, moduleContextInfo, earName, this.naming, idBuilder);
                    if (module == null) {
                        throw new DeploymentException("Module was not " + moduleTypeName + ": " + modulePath);
                    }
                    modules.add(module);
                }
            }
            GerExtModuleType[] gerExtModuleTypes = gerApplication.getExtModuleArray();
            for (int i = 0; i < gerExtModuleTypes.length; ++i) {
                void var13_17;
                void var14_18;
                void var16_20;
                Object moduleFile;
                String moduleTypeName;
                ModuleBuilder builder;
                String moduleName;
                GerExtModuleType gerExtModule = gerExtModuleTypes[i];
                Object moduleContextInfo = null;
                if (gerExtModule.isSetEjb()) {
                    moduleName = gerExtModule.getEjb().getStringValue();
                    builder = this.getEjbConfigBuilder();
                    if (builder == null) {
                        throw new DeploymentException("Cannot deploy ejb application; No ejb deployer defined: " + moduleName);
                    }
                    moduleTypeName = "an EJB";
                } else if (gerExtModule.isSetWeb()) {
                    moduleName = gerExtModule.getWeb().getStringValue();
                    if (this.getWebConfigBuilder() == null) {
                        throw new DeploymentException("Cannot deploy web application; No war deployer defined: " + moduleName);
                    }
                    builder = this.getWebConfigBuilder();
                    moduleTypeName = "a war";
                } else if (gerExtModule.isSetConnector()) {
                    moduleName = gerExtModule.getConnector().getStringValue();
                    if (this.getConnectorConfigBuilder() == null) {
                        throw new DeploymentException("Cannot deploy resource adapter; No rar deployer defined: " + moduleName);
                    }
                    builder = this.getConnectorConfigBuilder();
                    moduleTypeName = "a connector";
                } else if (gerExtModule.isSetJava()) {
                    moduleName = gerExtModule.getJava().getStringValue();
                    if (this.getAppClientConfigBuilder() == null) {
                        throw new DeploymentException("Cannot deploy app client; No app client deployer defined: " + moduleName);
                    }
                    builder = this.getAppClientConfigBuilder();
                    moduleTypeName = "an application client";
                } else {
                    throw new DeploymentException("Could not find a module builder for module: " + gerExtModule);
                }
                XmlObject[] anys = gerExtModule.selectChildren(GerExtModuleType.type.qnameSetForWildcardElements());
                if (anys.length != 1) {
                    throw new DeploymentException("Unexpected count of xs:any elements in embedded vendor plan " + anys.length + " qnameset: " + GerExtModuleType.type.qnameSetForWildcardElements());
                }
                XmlObject vendorDD = anys[0];
                if (gerExtModule.isSetInternalPath()) {
                    String modulePath = gerExtModule.getInternalPath().trim();
                    moduleLocations.add(modulePath);
                    try {
                        moduleFile = new NestedJarFile(earFile, modulePath);
                    }
                    catch (IOException e) {
                        throw new DeploymentException("Invalid moduleFile: " + modulePath, (Throwable)e);
                    }
                }
                String path = gerExtModule.getExternalPath().trim();
                Artifact artifact = Artifact.create((String)path);
                File location = null;
                Iterator iterator2 = this.repositories.iterator();
                while (iterator2.hasNext()) {
                    Repository repository = (Repository)iterator2.next();
                    if (!repository.contains(artifact)) continue;
                    location = repository.getLocation(artifact);
                    break;
                }
                if (location == null) {
                    throw new DeploymentException((String)var16_20 + " is missing in repositories: " + path);
                }
                try {
                    moduleFile = new JarFile(location);
                }
                catch (IOException e) {
                    throw new DeploymentException("Could not access contents of " + (String)var16_20, (Throwable)e);
                }
                URL altSpecDD = null;
                module = var14_18.createModule(vendorDD, (JarFile)moduleFile, (String)var13_17, altSpecDD, environment, moduleContextInfo, earName, this.naming, idBuilder);
                if (module == null) {
                    throw new DeploymentException("Module was not " + (String)var16_20 + ": " + (String)var13_17);
                }
                modules.add(module);
            }
            Object var26_34 = null;
            iterator3 = altVendorDDs.values().iterator();
        }
        catch (Throwable throwable) {
            Object var26_35 = null;
            Iterator iterator3 = altVendorDDs.values().iterator();
            while (iterator3.hasNext()) {
                Object altVendorDD = iterator3.next();
                if (!(altVendorDD instanceof File)) continue;
                ((File)altVendorDD).delete();
            }
            throw throwable;
        }
        while (iterator3.hasNext()) {
            Object altVendorDD = iterator3.next();
            if (!(altVendorDD instanceof File)) continue;
            ((File)altVendorDD).delete();
        }
    }

    private ModuleBuilder getBuilder(Module module) throws DeploymentException {
        if (module instanceof EJBModule) {
            if (this.getEjbConfigBuilder() == null) {
                throw new DeploymentException("Cannot deploy ejb application; No ejb deployer defined: " + module.getModuleURI());
            }
            return this.getEjbConfigBuilder();
        }
        if (module instanceof WebModule) {
            if (this.getWebConfigBuilder() == null) {
                throw new DeploymentException("Cannot deploy web application; No war deployer defined: " + module.getModuleURI());
            }
            return this.getWebConfigBuilder();
        }
        if (module instanceof ConnectorModule) {
            if (this.getConnectorConfigBuilder() == null) {
                throw new DeploymentException("Cannot deploy resource adapter; No rar deployer defined: " + module.getModuleURI());
            }
            return this.getConnectorConfigBuilder();
        }
        if (module instanceof AppClientModule) {
            if (this.getAppClientConfigBuilder() == null) {
                throw new DeploymentException("Cannot deploy app client; No app client deployer defined: " + module.getModuleURI());
            }
            return this.getAppClientConfigBuilder();
        }
        throw new IllegalArgumentException("Unknown module type: " + module.getClass().getName());
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        $assertionsDisabled = !EARConfigBuilder.class.desiredAssertionStatus();
        log = LogFactory.getLog((Class)EARConfigBuilder.class);
        LINE_SEP = System.getProperty("line.separator");
        APPLICATION_QNAME = GerApplicationDocument.type.getDocumentElementName();
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic((Class)EARConfigBuilder.class, (String)"ConfigBuilder");
        infoFactory.addAttribute("defaultEnvironment", Environment.class, true, true);
        infoFactory.addAttribute("transactionContextManagerAbstractName", AbstractNameQuery.class, true);
        infoFactory.addAttribute("connectionTrackerAbstractName", AbstractNameQuery.class, true);
        infoFactory.addAttribute("transactionalTimerAbstractName", AbstractNameQuery.class, true);
        infoFactory.addAttribute("nonTransactionalTimerAbstractName", AbstractNameQuery.class, true);
        infoFactory.addAttribute("corbaGBeanAbstractName", AbstractNameQuery.class, true);
        infoFactory.addAttribute("serverName", AbstractNameQuery.class, true);
        infoFactory.addReference("Repositories", Repository.class, "Repository");
        infoFactory.addReference("EJBConfigBuilder", ModuleBuilder.class, "ModuleBuilder");
        infoFactory.addReference("EJBReferenceBuilder", EJBReferenceBuilder.class, "ModuleBuilder");
        infoFactory.addReference("WebConfigBuilder", ModuleBuilder.class, "ModuleBuilder");
        infoFactory.addReference("ConnectorConfigBuilder", ModuleBuilder.class, "ModuleBuilder");
        infoFactory.addReference("ResourceReferenceBuilder", ResourceReferenceBuilder.class, "ModuleBuilder");
        infoFactory.addReference("AppClientConfigBuilder", ModuleBuilder.class, "ModuleBuilder");
        infoFactory.addReference("ServiceReferenceBuilder", ServiceReferenceBuilder.class, "ModuleBuilder");
        infoFactory.addAttribute("kernel", Kernel.class, false);
        infoFactory.addInterface(ConfigurationBuilder.class);
        infoFactory.setConstructor(new String[]{"defaultEnvironment", "transactionContextManagerAbstractName", "connectionTrackerAbstractName", "transactionalTimerAbstractName", "nonTransactionalTimerAbstractName", "corbaGBeanAbstractName", "serverName", "Repositories", "EJBConfigBuilder", "EJBReferenceBuilder", "WebConfigBuilder", "ConnectorConfigBuilder", "ResourceReferenceBuilder", "AppClientConfigBuilder", "ServiceReferenceBuilder", "kernel"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

