/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.j2ee.deployment;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.jar.JarFile;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.xmlbeans.XmlBeansUtil;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.ReferenceCollection;
import org.apache.geronimo.gbean.ReferenceCollectionEvent;
import org.apache.geronimo.gbean.ReferenceCollectionListener;
import org.apache.geronimo.j2ee.deployment.EARContext;
import org.apache.geronimo.j2ee.deployment.Module;
import org.apache.geronimo.j2ee.deployment.ModuleBuilder;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;

public class SwitchingModuleBuilder
implements ModuleBuilder {
    private final ReferenceCollection builders;
    private final Map namespaceToBuilderMap = new HashMap();
    private String defaultNamespace;
    public static final GBeanInfo GBEAN_INFO;

    public SwitchingModuleBuilder(Collection builders) {
        this.builders = (ReferenceCollection)builders;
        this.builders.addReferenceCollectionListener(new ReferenceCollectionListener(){

            public void memberAdded(ReferenceCollectionEvent event) {
                ModuleBuilder builder = (ModuleBuilder)event.getMember();
                String namespace = builder.getSchemaNamespace();
                SwitchingModuleBuilder.this.namespaceToBuilderMap.put(namespace, builder);
            }

            public void memberRemoved(ReferenceCollectionEvent event) {
                ModuleBuilder builder = (ModuleBuilder)event.getMember();
                String namespace = builder.getSchemaNamespace();
                SwitchingModuleBuilder.this.namespaceToBuilderMap.remove(namespace);
            }
        });
        Iterator iterator = builders.iterator();
        while (iterator.hasNext()) {
            ModuleBuilder builder = (ModuleBuilder)iterator.next();
            String namespace = builder.getSchemaNamespace();
            this.namespaceToBuilderMap.put(namespace, builder);
        }
    }

    public String getDefaultNamespace() {
        return this.defaultNamespace;
    }

    public void setDefaultNamespace(String defaultNamespace) {
        this.defaultNamespace = defaultNamespace;
    }

    public Module createModule(File plan, JarFile moduleFile) throws DeploymentException {
        String namespace = plan == null ? this.defaultNamespace : this.getNamespaceFromPlan(plan);
        ModuleBuilder builder = this.getBuilderFromNamespace(namespace);
        return builder.createModule(plan, moduleFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private String getNamespaceFromPlan(Object plan) throws DeploymentException {
        void var2_2;
        XmlObject xmlObject;
        if (plan instanceof File) {
            try {
                xmlObject = XmlBeansUtil.parse((URL)((File)plan).toURL());
            }
            catch (IOException e) {
                throw new DeploymentException("Could not read plan file", (Throwable)e);
            }
            catch (XmlException e) {
                throw new DeploymentException("Plan file does not contain well formed xml", (Throwable)e);
            }
        } else if (plan instanceof XmlObject) {
            xmlObject = (XmlObject)plan;
        } else {
            return this.defaultNamespace;
        }
        XmlCursor cursor = var2_2.newCursor();
        try {
            while (cursor.hasNextToken()) {
                if (cursor.isStart()) {
                    String namespace;
                    String string = namespace = cursor.getName().getNamespaceURI();
                    return string;
                }
                cursor.toNextToken();
            }
        }
        finally {
            cursor.dispose();
        }
        throw new DeploymentException("Cannot find namespace in xmlObject: " + var2_2.xmlText());
    }

    private ModuleBuilder getBuilderFromNamespace(String namespace) throws DeploymentException {
        ModuleBuilder builder = (ModuleBuilder)this.namespaceToBuilderMap.get(namespace);
        if (builder == null) {
            builder = (ModuleBuilder)this.namespaceToBuilderMap.get(this.defaultNamespace);
        }
        if (builder == null) {
            throw new DeploymentException("No builder found for namespace: " + namespace + " or default namespace: " + this.defaultNamespace);
        }
        return builder;
    }

    public Module createModule(Object plan, JarFile moduleFile, String targetPath, URL specDDUrl, URI earConfigId, Object moduleContextInfo) throws DeploymentException {
        String namespace = this.getNamespaceFromPlan(plan);
        ModuleBuilder builder = this.getBuilderFromNamespace(namespace);
        return builder.createModule(plan, moduleFile, targetPath, specDDUrl, earConfigId, moduleContextInfo);
    }

    public void installModule(JarFile earFile, EARContext earContext, Module module) throws DeploymentException {
        String namespace = module.getNamespace();
        ModuleBuilder builder = this.getBuilderFromNamespace(namespace);
        builder.installModule(earFile, earContext, module);
    }

    public void initContext(EARContext earContext, Module module, ClassLoader cl) throws DeploymentException {
        String namespace = module.getNamespace();
        ModuleBuilder builder = this.getBuilderFromNamespace(namespace);
        builder.initContext(earContext, module, cl);
    }

    public void addGBeans(EARContext earContext, Module module, ClassLoader cl) throws DeploymentException {
        String namespace = module.getNamespace();
        ModuleBuilder builder = this.getBuilderFromNamespace(namespace);
        builder.addGBeans(earContext, module, cl);
    }

    public String getSchemaNamespace() {
        return null;
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoBuilder = new GBeanInfoBuilder(SwitchingModuleBuilder.class, "ModuleBuilder");
        infoBuilder.addAttribute("defaultNamespace", String.class, true, true);
        infoBuilder.addReference("ModuleBuilders", ModuleBuilder.class, "ModuleBuilder");
        infoBuilder.addInterface(ModuleBuilder.class);
        infoBuilder.setConstructor(new String[]{"ModuleBuilders"});
        GBEAN_INFO = infoBuilder.getBeanInfo();
    }
}

