/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.j2ee.deployment;

import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.Reference;
import javax.xml.namespace.QName;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.common.UnresolvedReferenceException;
import org.apache.geronimo.deployment.DeploymentContext;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.j2ee.deployment.EJBReferenceBuilder;
import org.apache.geronimo.j2ee.deployment.Module;
import org.apache.geronimo.j2ee.deployment.NamingContext;
import org.apache.geronimo.j2ee.deployment.ResourceReferenceBuilder;
import org.apache.geronimo.j2ee.deployment.ServiceReferenceBuilder;
import org.apache.geronimo.j2ee.j2eeobjectnames.J2eeContext;
import org.apache.geronimo.j2ee.j2eeobjectnames.NameFactory;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.Kernel;

public class RefContext {
    private final EJBReferenceBuilder ejbReferenceBuilder;
    private final ResourceReferenceBuilder resourceReferenceBuilder;
    private final ServiceReferenceBuilder serviceReferenceBuilder;
    private final Kernel kernel;
    private final Map messageDestinations = new HashMap();
    static final /* synthetic */ boolean $assertionsDisabled;

    public RefContext(EJBReferenceBuilder ejbReferenceBuilder, ResourceReferenceBuilder resourceReferenceBuilder, ServiceReferenceBuilder serviceReferenceBuilder, Kernel kernel) {
        if (!$assertionsDisabled && ejbReferenceBuilder == null) {
            throw new AssertionError((Object)"ejbReferenceBuilder is null");
        }
        if (!$assertionsDisabled && resourceReferenceBuilder == null) {
            throw new AssertionError((Object)"resourceReferenceBuilder is null");
        }
        if (!$assertionsDisabled && serviceReferenceBuilder == null) {
            throw new AssertionError((Object)"serviceReferenceBuilder is null");
        }
        this.ejbReferenceBuilder = ejbReferenceBuilder;
        this.resourceReferenceBuilder = resourceReferenceBuilder;
        this.serviceReferenceBuilder = serviceReferenceBuilder;
        this.kernel = kernel;
    }

    public static RefContext derivedClientRefContext(RefContext refContext, EJBReferenceBuilder ejbReferenceBuilder, ResourceReferenceBuilder resourceReferenceBuilder, ServiceReferenceBuilder serviceReferenceBuilder) {
        return new RefContext(refContext, ejbReferenceBuilder, resourceReferenceBuilder, serviceReferenceBuilder);
    }

    private RefContext(RefContext refContext, EJBReferenceBuilder ejbReferenceBuilder, ResourceReferenceBuilder resourceReferenceBuilder, ServiceReferenceBuilder serviceReferenceBuilder) {
        if (!$assertionsDisabled && ejbReferenceBuilder == null) {
            throw new AssertionError((Object)"ejbReferenceBuilder is null");
        }
        if (!$assertionsDisabled && resourceReferenceBuilder == null) {
            throw new AssertionError((Object)"resourceReferenceBuilder is null");
        }
        if (!$assertionsDisabled && refContext == null) {
            throw new AssertionError((Object)"ejbRefContext is null");
        }
        this.ejbReferenceBuilder = ejbReferenceBuilder;
        this.resourceReferenceBuilder = resourceReferenceBuilder;
        this.serviceReferenceBuilder = serviceReferenceBuilder;
        this.kernel = refContext.kernel;
    }

    public void registerMessageDestionations(String moduleName, Map nameMap) throws DeploymentException {
        this.messageDestinations.put(moduleName, nameMap);
    }

    public Reference getEJBRemoteRef(String objectName, boolean isSession, String home, String remote) throws DeploymentException {
        return this.ejbReferenceBuilder.createEJBRemoteReference(objectName, null, isSession, home, remote);
    }

    public Reference getCORBARemoteRef(URI corbaURL, String objectName, ObjectName containerName, String home) throws DeploymentException {
        return this.ejbReferenceBuilder.createCORBAReference(corbaURL, objectName, containerName, home);
    }

    public Reference getEJBLocalRef(String objectName, boolean isSession, String localHome, String local) throws DeploymentException {
        return this.ejbReferenceBuilder.createEJBLocalReference(objectName, null, isSession, localHome, local);
    }

    public Object getHandleDelegateReference() throws DeploymentException {
        return this.ejbReferenceBuilder.createHandleDelegateReference();
    }

    public Reference getEJBRemoteRef(URI module, String ejbLink, boolean isSession, String home, String remote, NamingContext namingContext) throws DeploymentException {
        GBeanData containerData = this.locateEjbInApplication(namingContext, isSession, ejbLink, module);
        return this.ejbReferenceBuilder.createEJBRemoteReference(containerData.getName().getCanonicalName(), containerData, isSession, home, remote);
    }

    public Reference getEJBLocalRef(URI module, String ejbLink, boolean isSession, String localHome, String local, NamingContext namingContext) throws DeploymentException {
        GBeanData containerData = this.locateEjbInApplication(namingContext, isSession, ejbLink, module);
        return this.ejbReferenceBuilder.createEJBLocalReference(containerData.getName().getCanonicalName(), containerData, isSession, localHome, local);
    }

    public Reference getConnectionFactoryRef(String containerId, Class iface) throws DeploymentException {
        return this.resourceReferenceBuilder.createResourceRef(containerId, iface);
    }

    public Reference getAdminObjectRef(String containerId, Class iface) throws DeploymentException {
        return this.resourceReferenceBuilder.createAdminObjectRef(containerId, iface);
    }

    public Object getServiceReference(Class serviceInterface, URI wsdlURI, URI jaxrpcMappingURI, QName serviceQName, Map portComponentRefMap, List handlerInfos, Object serviceRefType, DeploymentContext deploymentContext, Module module, ClassLoader classLoader) throws DeploymentException {
        return this.serviceReferenceBuilder.createService(serviceInterface, wsdlURI, jaxrpcMappingURI, serviceQName, portComponentRefMap, handlerInfos, serviceRefType, deploymentContext, module, classLoader);
    }

    public String getResourceAdapterContainerId(URI moduleURI, String resourceLink, NamingContext context) throws UnresolvedReferenceException {
        J2eeContext j2eeContext = context.getJ2eeContext();
        ObjectName containerName = this.locateComponentName(resourceLink, moduleURI, "JCAResource", "JCAResourceAdapter", j2eeContext, context, "resource adapter");
        return containerName.getCanonicalName();
    }

    public String getConnectionFactoryContainerId(URI moduleURI, String resourceLink, String type, NamingContext context) throws UnresolvedReferenceException {
        J2eeContext j2eeContext = context.getJ2eeContext();
        ObjectName containerName = this.locateComponentName(resourceLink, moduleURI, "JCAResource", type, j2eeContext, context, "connection factory");
        return containerName.getCanonicalName();
    }

    public Object getMessageDestination(String messageDestinationLink) throws DeploymentException {
        Object destination = null;
        int pos = messageDestinationLink.indexOf(35);
        if (pos > -1) {
            String targetModule = messageDestinationLink.substring(0, pos);
            Map destinations = (Map)this.messageDestinations.get(targetModule);
            messageDestinationLink = messageDestinationLink.substring(pos + 1);
            destination = destinations.get(messageDestinationLink);
        } else {
            Iterator iterator = this.messageDestinations.values().iterator();
            while (iterator.hasNext()) {
                Map destinations = (Map)iterator.next();
                Object destinationTest = destinations.get(messageDestinationLink);
                if (destinationTest == null) continue;
                if (destination != null) {
                    throw new DeploymentException("Duplicate message destination " + messageDestinationLink + " accessed from a message-destination-link without a module");
                }
                destination = destinationTest;
            }
        }
        return destination;
    }

    public String getAdminObjectContainerId(URI moduleURI, String resourceLink, NamingContext context) throws DeploymentException {
        J2eeContext j2eeContext = context.getJ2eeContext();
        ObjectName containerName = this.locateComponentName(resourceLink, moduleURI, "JCAResource", "JCAAdminObject", j2eeContext, context, "admin object");
        return containerName.getCanonicalName();
    }

    public Reference getImplicitEJBRemoteRef(URI module, String refName, boolean isSession, String home, String remote, NamingContext namingContext) throws DeploymentException {
        return this.ejbReferenceBuilder.getImplicitEJBRemoteRef(module, refName, isSession, home, remote, namingContext);
    }

    public Reference getImplicitEJBLocalRef(URI module, String refName, boolean isSession, String localHome, String local, NamingContext namingContext) throws DeploymentException {
        return this.ejbReferenceBuilder.getImplicitEJBLocalRef(module, refName, isSession, localHome, local, namingContext);
    }

    public GBeanData getResourceAdapterGBeanData(ObjectName resourceAdapterModuleName, NamingContext context) throws DeploymentException {
        GBeanData resourceModuleData = this.locateComponentData(resourceAdapterModuleName, context);
        return this.resourceReferenceBuilder.locateResourceAdapterGBeanData(resourceModuleData);
    }

    public GBeanData getActivationSpecInfo(ObjectName resourceAdapterModuleName, String messageListenerInterfaceName, NamingContext context) throws DeploymentException {
        GBeanData resourceModuleData = this.locateComponentData(resourceAdapterModuleName, context);
        return this.resourceReferenceBuilder.locateActivationSpecInfo(resourceModuleData, messageListenerInterfaceName);
    }

    public GBeanData getAdminObjectInfo(ObjectName resourceAdapterModuleName, String adminObjectInterfaceName, NamingContext context) throws DeploymentException {
        GBeanData resourceModuleData = this.locateComponentData(resourceAdapterModuleName, context);
        return this.resourceReferenceBuilder.locateAdminObjectInfo(resourceModuleData, adminObjectInterfaceName);
    }

    public GBeanData getConnectionFactoryInfo(ObjectName resourceAdapterModuleName, String connectionFactoryInterfaceName, NamingContext context) throws DeploymentException {
        GBeanData resourceModuleData = this.locateComponentData(resourceAdapterModuleName, context);
        return this.resourceReferenceBuilder.locateConnectionFactoryInfo(resourceModuleData, connectionFactoryInterfaceName);
    }

    public String getMEJBName() throws DeploymentException {
        ObjectName query = null;
        try {
            query = ObjectName.getInstance("*:name=ejb/mgmt/MEJB,*");
        }
        catch (MalformedObjectNameException e) {
            throw new DeploymentException("We built this name...");
        }
        ObjectName mejbName = this.locateUniqueNameInKernel(query, "Management EJB");
        return mejbName.getCanonicalName();
    }

    public ObjectName locateComponentName(String resourceLink, URI moduleURI, String moduleType, String type, J2eeContext j2eeContext, NamingContext context, String queryType) throws UnresolvedReferenceException {
        GBeanData match = this.locateComponent(resourceLink, moduleURI, moduleType, type, j2eeContext, context, queryType);
        return match.getName();
    }

    public GBeanData locateComponent(String resourceLink, URI moduleURI, String moduleType, String type, J2eeContext j2eeContext, NamingContext context, String queryType) throws UnresolvedReferenceException {
        GBeanData match = this.locateComponentInApplication(resourceLink, moduleURI, moduleType, type, j2eeContext, queryType, context, true);
        if (match == null) {
            return this.locateGBeanInKernel(resourceLink, type, j2eeContext, queryType);
        }
        return match;
    }

    public GBeanData locateComponentData(ObjectName name, NamingContext context) throws UnresolvedReferenceException {
        try {
            return context.getGBeanInstance(name);
        }
        catch (GBeanNotFoundException e) {
            try {
                return this.kernel.getGBeanData(name);
            }
            catch (GBeanNotFoundException e2) {
                throw new UnresolvedReferenceException("GBean name: " + name + " not found in DeploymentContext: " + context.getConfigID() + " or in kernel", false, null);
            }
        }
    }

    private GBeanData locateEjbInApplication(NamingContext namingContext, boolean isSession, String ejbLink, URI module) throws UnresolvedReferenceException {
        GBeanData gbeanData;
        J2eeContext j2eeContext = namingContext.getJ2eeContext();
        if (isSession) {
            gbeanData = this.locateComponentInApplication(ejbLink, module, "EJBModule", "StatelessSessionBean", j2eeContext, "remote ejb", namingContext, false);
            if (gbeanData == null) {
                gbeanData = this.locateComponentInApplication(ejbLink, module, "EJBModule", "StatefulSessionBean", j2eeContext, "remote ejb", namingContext, true);
            }
        } else {
            gbeanData = this.locateComponentInApplication(ejbLink, module, "EJBModule", "EntityBean", j2eeContext, "remote ejb", namingContext, true);
        }
        return gbeanData;
    }

    private GBeanData locateComponentInApplication(String resourceLink, URI moduleURI, String moduleType, String type, J2eeContext j2eeContext, String queryType, NamingContext context, boolean requireMatchInExplicitModule) throws UnresolvedReferenceException {
        GBeanData match = this.locateComponentInModule(resourceLink, moduleURI, moduleType, type, j2eeContext, queryType, context, requireMatchInExplicitModule);
        if (match == null) {
            match = this.locateGBeanInContext(null, "*", resourceLink, type, j2eeContext, queryType, context, false);
        }
        return match;
    }

    private GBeanData locateComponentInModule(String resourceLink, URI moduleURI, String moduleType, String type, J2eeContext j2eeContext, String queryType, NamingContext context, boolean requireMatchInExplicitModule) throws UnresolvedReferenceException {
        GBeanData match;
        String module;
        String name = resourceLink.substring(resourceLink.lastIndexOf(35) + 1);
        String string = module = moduleURI == null ? "" : moduleURI.getPath();
        if (resourceLink.indexOf(35) > -1) {
            module = moduleURI.resolve(resourceLink).getPath();
            match = this.locateGBeanInContext(moduleType, module, name, type, j2eeContext, queryType, context, requireMatchInExplicitModule);
        } else {
            if (module.equals("")) {
                module = "*";
            }
            match = this.locateGBeanInContext(moduleType, module, name, type, j2eeContext, queryType, context, false);
        }
        return match;
    }

    private GBeanData locateGBeanInContext(String moduleType, String moduleName, String name, String type, J2eeContext j2eeContext, String queryType, NamingContext context, boolean requireMatch) throws UnresolvedReferenceException {
        ObjectName query = null;
        if (moduleType == null) {
            moduleName = "*";
        }
        try {
            query = NameFactory.getComponentNameQuery(null, null, null, (String)moduleType, (String)moduleName, (String)name, (String)type, (J2eeContext)j2eeContext);
        }
        catch (MalformedObjectNameException e1) {
            throw (UnresolvedReferenceException)new UnresolvedReferenceException("Could not construct " + queryType + " object name query", false, null).initCause((Throwable)e1);
        }
        ObjectName match = this.locateUniqueNameInContext(context, query);
        if (match == null) {
            if (!requireMatch) {
                return null;
            }
            throw new UnresolvedReferenceException("Could not resolve reference: module: " + moduleName + ", component name: " + name, false, query.toString());
        }
        try {
            GBeanData data = context.getGBeanInstance(match);
            return data;
        }
        catch (GBeanNotFoundException e) {
            throw new IllegalStateException("BUG! context listed a gbean but could not get its gbeanData: " + match + " gbeans in context:" + context.getGBeanNames());
        }
    }

    private ObjectName locateUniqueNameInContext(NamingContext context, ObjectName query) throws UnresolvedReferenceException {
        ObjectName match = null;
        Set matches = context.listGBeans(query);
        if (matches.size() > 1) {
            throw new UnresolvedReferenceException("More than one match for query " + matches, true, query.getCanonicalName());
        }
        if (matches.size() == 1) {
            match = (ObjectName)matches.iterator().next();
        }
        return match;
    }

    private GBeanData locateGBeanInKernel(String name, String type, J2eeContext j2eeContext, String queryType) throws UnresolvedReferenceException {
        ObjectName query;
        try {
            query = NameFactory.getComponentRestrictedQueryName(null, null, (String)name, (String)type, (J2eeContext)j2eeContext);
        }
        catch (MalformedObjectNameException e1) {
            throw (UnresolvedReferenceException)new UnresolvedReferenceException("Could not construct " + queryType + " object name query", false, null).initCause((Throwable)e1);
        }
        return this.locateUniqueGBeanData(query, queryType);
    }

    private ObjectName locateUniqueNameInKernel(ObjectName query, String type) throws UnresolvedReferenceException {
        Set names = this.kernel.listGBeans(query);
        if (names.size() != 1) {
            throw new UnresolvedReferenceException(type, names.size() > 1, query.getCanonicalName());
        }
        return (ObjectName)names.iterator().next();
    }

    private GBeanData locateUniqueGBeanData(ObjectName query, String type) throws UnresolvedReferenceException {
        ObjectName match = this.locateUniqueNameInKernel(query, type);
        try {
            return this.kernel.getGBeanData(match);
        }
        catch (GBeanNotFoundException e) {
            throw new IllegalStateException("BUG! kernel listed a gbean but could not get its gbeanData: " + match);
        }
    }

    public ObjectName locateUniqueName(NamingContext context, ObjectName query) throws UnresolvedReferenceException {
        ObjectName match = this.locateUniqueNameInContext(context, query);
        if (match == null) {
            match = this.locateUniqueNameInKernel(query, "type unknown");
        }
        return match;
    }

    static {
        $assertionsDisabled = !RefContext.class.desiredAssertionStatus();
    }
}

