/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.j2ee.deployment;

import [Ljava.net.URI;;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.ConfigurationBuilder;
import org.apache.geronimo.deployment.DeploymentContext;
import org.apache.geronimo.deployment.service.ServiceConfigBuilder;
import org.apache.geronimo.deployment.util.DeploymentUtil;
import org.apache.geronimo.deployment.util.NestedJarFile;
import org.apache.geronimo.deployment.xbeans.DependencyType;
import org.apache.geronimo.deployment.xbeans.GbeanType;
import org.apache.geronimo.deployment.xmlbeans.XmlBeansUtil;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.j2ee.ApplicationInfo;
import org.apache.geronimo.j2ee.deployment.AppClientModule;
import org.apache.geronimo.j2ee.deployment.ConnectorModule;
import org.apache.geronimo.j2ee.deployment.EARContext;
import org.apache.geronimo.j2ee.deployment.EJBModule;
import org.apache.geronimo.j2ee.deployment.EJBReferenceBuilder;
import org.apache.geronimo.j2ee.deployment.Module;
import org.apache.geronimo.j2ee.deployment.ModuleBuilder;
import org.apache.geronimo.j2ee.deployment.RefContext;
import org.apache.geronimo.j2ee.deployment.ResourceReferenceBuilder;
import org.apache.geronimo.j2ee.deployment.ServiceReferenceBuilder;
import org.apache.geronimo.j2ee.deployment.WebModule;
import org.apache.geronimo.j2ee.j2eeobjectnames.J2eeContext;
import org.apache.geronimo.j2ee.j2eeobjectnames.NameFactory;
import org.apache.geronimo.j2ee.management.impl.J2EEApplicationImpl;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.config.ConfigurationData;
import org.apache.geronimo.kernel.config.ConfigurationModuleType;
import org.apache.geronimo.kernel.repository.Repository;
import org.apache.geronimo.schema.SchemaConversionUtils;
import org.apache.geronimo.security.deployment.SecurityBuilder;
import org.apache.geronimo.security.deployment.SecurityConfiguration;
import org.apache.geronimo.xbeans.geronimo.j2ee.GerApplicationType;
import org.apache.geronimo.xbeans.geronimo.j2ee.GerExtModuleType;
import org.apache.geronimo.xbeans.geronimo.j2ee.GerModuleType;
import org.apache.geronimo.xbeans.geronimo.security.GerSecurityType;
import org.apache.geronimo.xbeans.j2ee.ApplicationType;
import org.apache.geronimo.xbeans.j2ee.ModuleType;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;

public class EARConfigBuilder
implements ConfigurationBuilder {
    private final Kernel kernel;
    private final Repository repository;
    private final ModuleBuilder ejbConfigBuilder;
    private final ModuleBuilder webConfigBuilder;
    private final ModuleBuilder connectorConfigBuilder;
    private final ModuleBuilder appClientConfigBuilder;
    private final EJBReferenceBuilder ejbReferenceBuilder;
    private final ResourceReferenceBuilder resourceReferenceBuilder;
    private final ServiceReferenceBuilder serviceReferenceBuilder;
    private final List defaultParentId;
    private final ObjectName transactionContextManagerObjectName;
    private final ObjectName connectionTrackerObjectName;
    private final ObjectName transactionalTimerObjectName;
    private final ObjectName nonTransactionalTimerObjectName;
    private final ObjectName corbaGBeanObjectName;
    public static final GBeanInfo GBEAN_INFO;
    static final /* synthetic */ boolean $assertionsDisabled;

    public EARConfigBuilder(URI[] defaultParentId, ObjectName transactionContextManagerObjectName, ObjectName connectionTrackerObjectName, ObjectName transactionalTimerObjectName, ObjectName nonTransactionalTimerObjectName, ObjectName corbaGBeanObjectName, Repository repository, ModuleBuilder ejbConfigBuilder, EJBReferenceBuilder ejbReferenceBuilder, ModuleBuilder webConfigBuilder, ModuleBuilder connectorConfigBuilder, ResourceReferenceBuilder resourceReferenceBuilder, ModuleBuilder appClientConfigBuilder, ServiceReferenceBuilder serviceReferenceBuilder, Kernel kernel) {
        this.kernel = kernel;
        this.repository = repository;
        this.defaultParentId = defaultParentId == null ? Collections.EMPTY_LIST : Arrays.asList(defaultParentId);
        this.ejbConfigBuilder = ejbConfigBuilder;
        this.ejbReferenceBuilder = ejbReferenceBuilder;
        this.resourceReferenceBuilder = resourceReferenceBuilder;
        this.webConfigBuilder = webConfigBuilder;
        this.connectorConfigBuilder = connectorConfigBuilder;
        this.appClientConfigBuilder = appClientConfigBuilder;
        this.serviceReferenceBuilder = serviceReferenceBuilder;
        this.transactionContextManagerObjectName = transactionContextManagerObjectName;
        this.connectionTrackerObjectName = connectionTrackerObjectName;
        this.transactionalTimerObjectName = transactionalTimerObjectName;
        this.nonTransactionalTimerObjectName = nonTransactionalTimerObjectName;
        this.corbaGBeanObjectName = corbaGBeanObjectName;
    }

    public Object getDeploymentPlan(File planFile, JarFile jarFile) throws DeploymentException {
        if (planFile == null && jarFile == null) {
            return null;
        }
        ApplicationInfo plan = this.getEarPlan(planFile, jarFile);
        if (plan != null) {
            return plan;
        }
        if (jarFile == null) {
            return null;
        }
        Module module = null;
        if (this.webConfigBuilder != null) {
            module = this.webConfigBuilder.createModule(planFile, jarFile);
        }
        if (module == null && this.ejbConfigBuilder != null) {
            module = this.ejbConfigBuilder.createModule(planFile, jarFile);
        }
        if (module == null && this.connectorConfigBuilder != null) {
            module = this.connectorConfigBuilder.createModule(planFile, jarFile);
        }
        if (module == null && this.appClientConfigBuilder != null) {
            module = this.appClientConfigBuilder.createModule(planFile, jarFile);
        }
        if (module == null) {
            return null;
        }
        return new ApplicationInfo(module.getType(), module.getConfigId(), module.getParentId(), "null", null, null, Collections.singleton(module), Collections.EMPTY_SET, null);
    }

    private ApplicationInfo getEarPlan(File planFile, JarFile earFile) throws DeploymentException {
        ApplicationType application = null;
        if (earFile != null) {
            String specDD;
            try {
                URL applicationXmlUrl = DeploymentUtil.createJarURL((JarFile)earFile, (String)"META-INF/application.xml");
                specDD = DeploymentUtil.readAll((URL)applicationXmlUrl);
            }
            catch (Exception e) {
                return null;
            }
            try {
                XmlObject xmlObject = XmlBeansUtil.parse((String)specDD);
                application = SchemaConversionUtils.convertToApplicationSchema((XmlObject)xmlObject).getApplication();
            }
            catch (XmlException e) {
                throw new DeploymentException("Could not parse application.xml", (Throwable)e);
            }
        }
        GerApplicationType gerApplication = null;
        try {
            Object gerApplicationDoc = null;
            XmlObject rawPlan = null;
            try {
                if (planFile != null) {
                    rawPlan = XmlBeansUtil.parse((URL)planFile.toURL());
                    gerApplication = (GerApplicationType)SchemaConversionUtils.fixGeronimoSchema((XmlObject)rawPlan, (String)"application", (SchemaType)GerApplicationType.type);
                    if (gerApplication == null) {
                        return null;
                    }
                } else {
                    URL path = DeploymentUtil.createJarURL((JarFile)earFile, (String)"META-INF/geronimo-application.xml");
                    rawPlan = XmlBeansUtil.parse((URL)path);
                    gerApplication = (GerApplicationType)SchemaConversionUtils.fixGeronimoSchema((XmlObject)rawPlan, (String)"application", (SchemaType)GerApplicationType.type);
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            if (gerApplication == null) {
                gerApplication = this.createDefaultPlan(application, earFile);
            }
        }
        catch (XmlException e) {
            throw new DeploymentException((Throwable)e);
        }
        URI configId = null;
        try {
            configId = new URI(gerApplication.getConfigId());
        }
        catch (URISyntaxException e) {
            throw new DeploymentException("Invalid configId " + gerApplication.getConfigId(), (Throwable)e);
        }
        List parentId = ServiceConfigBuilder.getParentID((String)gerApplication.getParentId(), (DependencyType[])gerApplication.getImportArray());
        parentId.addAll(this.defaultParentId);
        HashSet moduleLocations = new HashSet();
        LinkedHashSet modules = new LinkedHashSet();
        try {
            this.addModules(earFile, application, gerApplication, moduleLocations, modules);
        }
        catch (Throwable e) {
            Iterator iterator = modules.iterator();
            while (iterator.hasNext()) {
                Module module = (Module)iterator.next();
                module.close();
            }
            if (e instanceof DeploymentException) {
                throw (DeploymentException)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            throw new DeploymentException(e);
        }
        String applicationName = gerApplication.isSetApplicationName() ? gerApplication.getApplicationName() : configId.toString();
        return new ApplicationInfo(ConfigurationModuleType.EAR, configId, parentId, applicationName, (XmlObject)application, gerApplication, modules, moduleLocations, application == null ? null : application.toString());
    }

    private GerApplicationType createDefaultPlan(ApplicationType application, JarFile module) {
        GerApplicationType gerApplication = GerApplicationType.Factory.newInstance();
        String id = application.getId();
        if (id == null) {
            File fileName = new File(module.getName());
            id = fileName.getName();
            if (id.endsWith(".ear")) {
                id = id.substring(0, id.length() - 4);
            }
            if (id.endsWith("/")) {
                id = id.substring(0, id.length() - 1);
            }
        }
        gerApplication.setConfigId(id);
        return gerApplication;
    }

    public URI getConfigurationID(Object plan, JarFile module) throws IOException, DeploymentException {
        ApplicationInfo applicationInfo = (ApplicationInfo)plan;
        return applicationInfo.getConfigId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigurationData buildConfiguration(Object plan, JarFile earFile, File outfile) throws IOException, DeploymentException {
        Iterator iterator5;
        ConfigurationData configurationData;
        if (!$assertionsDisabled && plan == null) {
            throw new AssertionError();
        }
        ApplicationInfo applicationInfo = (ApplicationInfo)plan;
        try {
            String moduleName;
            GerApplicationType geronimoApplication;
            EARContext earContext = null;
            ConfigurationModuleType applicationType = applicationInfo.getType();
            try {
                earContext = new EARContext(outfile, applicationInfo.getConfigId(), applicationType, applicationInfo.getParentId(), this.kernel, applicationInfo.getApplicationName(), this.transactionContextManagerObjectName, this.connectionTrackerObjectName, this.transactionalTimerObjectName, this.nonTransactionalTimerObjectName, this.corbaGBeanObjectName, new RefContext(this.ejbReferenceBuilder, this.resourceReferenceBuilder, this.serviceReferenceBuilder, this.kernel));
            }
            catch (MalformedObjectNameException e) {
                throw new DeploymentException((Throwable)e);
            }
            Set moduleLocations = applicationInfo.getModuleLocations();
            if (ConfigurationModuleType.EAR == applicationType && earFile != null) {
                Enumeration<JarEntry> e = earFile.entries();
                while (e.hasMoreElements()) {
                    ZipEntry entry = e.nextElement();
                    if (moduleLocations.contains(entry.getName())) continue;
                    earContext.addFile(URI.create(entry.getName()), earFile, entry);
                }
            }
            if ((geronimoApplication = (GerApplicationType)applicationInfo.getVendorDD()) != null) {
                DependencyType[] dependencies = geronimoApplication.getDependencyArray();
                ServiceConfigBuilder.addDependencies((DeploymentContext)earContext, (DependencyType[])dependencies, (Repository)this.repository);
            }
            Set modules = applicationInfo.getModules();
            Iterator iterator2 = modules.iterator();
            while (iterator2.hasNext()) {
                Module module = (Module)iterator2.next();
                this.getBuilder(module).installModule(earFile, earContext, module);
            }
            ClassLoader cl = earContext.getClassLoader(this.repository);
            Iterator iterator3 = modules.iterator();
            while (iterator3.hasNext()) {
                Module module = (Module)iterator3.next();
                this.getBuilder(module).initContext(earContext, module, cl);
            }
            if (geronimoApplication != null) {
                GbeanType[] gbeans = geronimoApplication.getGbeanArray();
                ServiceConfigBuilder.addGBeans((GbeanType[])gbeans, (ClassLoader)cl, (J2eeContext)earContext.getJ2eeContext(), (DeploymentContext)earContext);
            }
            if (ConfigurationModuleType.EAR == applicationType) {
                GBeanData gbeanData = new GBeanData(earContext.getApplicationObjectName(), J2EEApplicationImpl.GBEAN_INFO);
                try {
                    gbeanData.setAttribute("deploymentDescriptor", (Object)applicationInfo.getOriginalSpecDD());
                }
                catch (Exception e) {
                    throw new DeploymentException("Error initializing J2EEApplication managed object");
                }
                try {
                    gbeanData.setReferencePattern("j2eeServer", NameFactory.getServerName((String)earContext.getDomain(), (String)earContext.getServer(), (J2eeContext)earContext.getJ2eeContext()));
                }
                catch (MalformedObjectNameException e) {
                    throw new DeploymentException("Error constructing J2EEServer name for application", (Throwable)e);
                }
                earContext.addGBean(gbeanData);
            }
            ObjectName jaccBeanName = null;
            if (ConfigurationModuleType.EAR == applicationType) {
                moduleName = "null";
            } else {
                Module module = (Module)modules.iterator().next();
                moduleName = module.getName();
            }
            try {
                jaccBeanName = NameFactory.getComponentName(null, null, null, (String)moduleName, (String)"JACCManager", (String)"JACCManager", (J2eeContext)earContext.getJ2eeContext());
            }
            catch (MalformedObjectNameException e) {
                throw new DeploymentException("Could not construct name for JACCBean", (Throwable)e);
            }
            earContext.setJaccManagerName(jaccBeanName);
            if (geronimoApplication != null && geronimoApplication.isSetSecurity()) {
                SecurityConfiguration securityConfiguration = SecurityBuilder.buildSecurityConfiguration((GerSecurityType)geronimoApplication.getSecurity());
                earContext.setSecurityConfiguration(securityConfiguration);
            }
            Iterator iterator4 = modules.iterator();
            while (iterator4.hasNext()) {
                Module module = (Module)iterator4.next();
                this.getBuilder(module).addGBeans(earContext, module, cl);
            }
            if (earContext.getSecurityConfiguration() != null) {
                GBeanData jaccBeanData = SecurityBuilder.configureApplicationPolicyManager((ObjectName)jaccBeanName, (Map)earContext.getContextIDToPermissionsMap(), (SecurityConfiguration)earContext.getSecurityConfiguration());
                earContext.addGBean(jaccBeanData);
            }
            earContext.close();
            configurationData = earContext.getConfigurationData();
            Object var16_19 = null;
            Set modules2 = applicationInfo.getModules();
            iterator5 = modules2.iterator();
        }
        catch (Throwable throwable) {
            Object var16_20 = null;
            Set modules2 = applicationInfo.getModules();
            Iterator iterator5 = modules2.iterator();
            while (iterator5.hasNext()) {
                Module module = (Module)iterator5.next();
                module.close();
            }
            throw throwable;
        }
        while (iterator5.hasNext()) {
            Module module = (Module)iterator5.next();
            module.close();
        }
        return configurationData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void addModules(JarFile earFile, ApplicationType application, GerApplicationType gerApplication, Set moduleLocations, Set modules) throws DeploymentException {
        Iterator iterator2;
        HashMap<String, File> altVendorDDs = new HashMap<String, File>();
        try {
            Module module;
            if (earFile != null) {
                int i;
                ModuleType[] moduleTypes = application.getModuleArray();
                HashSet<String> paths = new HashSet<String>();
                for (int i2 = 0; i2 < moduleTypes.length; ++i2) {
                    ModuleType type = moduleTypes[i2];
                    if (type.isSetEjb()) {
                        paths.add(type.getEjb().getStringValue());
                        continue;
                    }
                    if (type.isSetWeb()) {
                        paths.add(type.getWeb().getWebUri().getStringValue());
                        continue;
                    }
                    if (type.isSetConnector()) {
                        paths.add(type.getConnector().getStringValue());
                        continue;
                    }
                    if (!type.isSetJava()) continue;
                    paths.add(type.getJava().getStringValue());
                }
                GerModuleType[] gerModuleTypes = gerApplication.getModuleArray();
                for (i = 0; i < gerModuleTypes.length; ++i) {
                    GerModuleType gerModule = gerModuleTypes[i];
                    String path = null;
                    if (gerModule.isSetEjb()) {
                        path = gerModule.getEjb().getStringValue();
                    } else if (gerModule.isSetWeb()) {
                        path = gerModule.getWeb().getStringValue();
                    } else if (gerModule.isSetConnector()) {
                        path = gerModule.getConnector().getStringValue();
                    } else if (gerModule.isSetJava()) {
                        path = gerModule.getJava().getStringValue();
                    }
                    if (!paths.contains(path)) {
                        throw new DeploymentException("Geronimo deployment plan refers to module '" + path + "' but that was not defined in the META-INF/application.xml");
                    }
                    if (gerModule.isSetAltDd()) {
                        try {
                            altVendorDDs.put(path, DeploymentUtil.toTempFile((JarFile)earFile, (String)gerModule.getAltDd().getStringValue()));
                            continue;
                        }
                        catch (IOException e) {
                            throw new DeploymentException("Invalid alt vendor dd url: " + gerModule.getAltDd().getStringValue(), (Throwable)e);
                        }
                    }
                    XmlObject[] anys = gerModule.selectChildren(GerModuleType.type.qnameSetForWildcardElements());
                    if (anys.length != 1) {
                        throw new DeploymentException("Unexpected count of xs:any elements in embedded vendor plan " + anys.length + " qnameset: " + GerModuleType.type.qnameSetForWildcardElements());
                    }
                    altVendorDDs.put(path, (File)anys[0]);
                }
                for (i = 0; i < moduleTypes.length; ++i) {
                    String moduleTypeName;
                    ModuleBuilder builder;
                    String modulePath;
                    ModuleType moduleXml = moduleTypes[i];
                    String moduleContextInfo = null;
                    if (moduleXml.isSetEjb()) {
                        modulePath = moduleXml.getEjb().getStringValue();
                        if (this.ejbConfigBuilder == null) {
                            throw new DeploymentException("Cannot deploy ejb application; No ejb deployer defined: " + modulePath);
                        }
                        builder = this.ejbConfigBuilder;
                        moduleTypeName = "an EJB";
                    } else if (moduleXml.isSetWeb()) {
                        modulePath = moduleXml.getWeb().getWebUri().getStringValue();
                        if (this.webConfigBuilder == null) {
                            throw new DeploymentException("Cannot deploy web application; No war deployer defined: " + modulePath);
                        }
                        builder = this.webConfigBuilder;
                        moduleTypeName = "a war";
                        moduleContextInfo = moduleXml.getWeb().getContextRoot().getStringValue().trim();
                    } else if (moduleXml.isSetConnector()) {
                        modulePath = moduleXml.getConnector().getStringValue();
                        if (this.connectorConfigBuilder == null) {
                            throw new DeploymentException("Cannot deploy resource adapter; No rar deployer defined: " + modulePath);
                        }
                        builder = this.connectorConfigBuilder;
                        moduleTypeName = "a connector";
                    } else if (moduleXml.isSetJava()) {
                        modulePath = moduleXml.getJava().getStringValue();
                        if (this.appClientConfigBuilder == null) {
                            throw new DeploymentException("Cannot deploy app client; No app client deployer defined: " + modulePath);
                        }
                        builder = this.appClientConfigBuilder;
                        moduleTypeName = "an application client";
                    } else {
                        throw new DeploymentException("Could not find a module builder for module: " + moduleXml);
                    }
                    moduleLocations.add(modulePath);
                    URL altSpecDD = null;
                    if (moduleXml.isSetAltDd()) {
                        try {
                            altSpecDD = DeploymentUtil.createJarURL((JarFile)earFile, (String)moduleXml.getAltDd().getStringValue());
                        }
                        catch (MalformedURLException e) {
                            throw new DeploymentException("Invalid alt sped dd url: " + moduleXml.getAltDd().getStringValue(), (Throwable)e);
                        }
                    }
                    NestedJarFile moduleFile = null;
                    try {
                        moduleFile = new NestedJarFile(earFile, modulePath);
                    }
                    catch (IOException e) {
                        throw new DeploymentException("Invalid moduleFile: " + modulePath, (Throwable)e);
                    }
                    module = builder.createModule(altVendorDDs.get(modulePath), (JarFile)moduleFile, modulePath, altSpecDD, URI.create(gerApplication.getConfigId()), moduleContextInfo);
                    if (module == null) {
                        throw new DeploymentException("Module was not " + moduleTypeName + ": " + modulePath);
                    }
                    modules.add(module);
                }
            }
            GerExtModuleType[] gerExtModuleTypes = gerApplication.getExtModuleArray();
            for (int i = 0; i < gerExtModuleTypes.length; ++i) {
                void var11_15;
                void var13_17;
                String moduleTypeName;
                ModuleBuilder builder;
                GerExtModuleType gerExtModule = gerExtModuleTypes[i];
                String moduleName = null;
                Object moduleContextInfo = null;
                if (gerExtModule.isSetEjb()) {
                    moduleName = gerExtModule.getEjb().getStringValue();
                    if (this.ejbConfigBuilder == null) {
                        throw new DeploymentException("Cannot deploy ejb application; No ejb deployer defined: " + moduleName);
                    }
                    builder = this.ejbConfigBuilder;
                    moduleTypeName = "an EJB";
                } else if (gerExtModule.isSetWeb()) {
                    moduleName = gerExtModule.getWeb().getStringValue();
                    if (this.webConfigBuilder == null) {
                        throw new DeploymentException("Cannot deploy web application; No war deployer defined: " + moduleName);
                    }
                    builder = this.webConfigBuilder;
                    moduleTypeName = "a war";
                } else if (gerExtModule.isSetConnector()) {
                    moduleName = gerExtModule.getConnector().getStringValue();
                    if (this.connectorConfigBuilder == null) {
                        throw new DeploymentException("Cannot deploy resource adapter; No rar deployer defined: " + moduleName);
                    }
                    builder = this.connectorConfigBuilder;
                    moduleTypeName = "a connector";
                } else if (gerExtModule.isSetJava()) {
                    moduleName = gerExtModule.getJava().getStringValue();
                    if (this.appClientConfigBuilder == null) {
                        throw new DeploymentException("Cannot deploy app client; No app client deployer defined: " + moduleName);
                    }
                    builder = this.appClientConfigBuilder;
                    moduleTypeName = "an application client";
                } else {
                    throw new DeploymentException("Could not find a module builder for module: " + gerExtModule);
                }
                XmlObject[] anys = gerExtModule.selectChildren(GerExtModuleType.type.qnameSetForWildcardElements());
                if (anys.length != 1) {
                    throw new DeploymentException("Unexpected count of xs:any elements in embedded vendor plan " + anys.length + " qnameset: " + GerExtModuleType.type.qnameSetForWildcardElements());
                }
                XmlObject vendorDD = anys[0];
                Object moduleFile = null;
                if (gerExtModule.isSetInternalPath()) {
                    String modulePath = gerExtModule.getInternalPath().trim();
                    moduleLocations.add(modulePath);
                    try {
                        moduleFile = new NestedJarFile(earFile, modulePath);
                    }
                    catch (IOException e) {
                        throw new DeploymentException("Invalid moduleFile: " + modulePath, (Throwable)e);
                    }
                }
                String path = gerExtModule.getExternalPath().trim();
                URI pathURI = null;
                try {
                    pathURI = new URI(path);
                }
                catch (URISyntaxException e) {
                    throw new DeploymentException("Bad path to external module, " + (String)var13_17, (Throwable)e);
                }
                if (!this.repository.hasURI(pathURI)) {
                    throw new DeploymentException((String)var13_17 + " is missing in repository: " + path);
                }
                URL pathURL = null;
                try {
                    pathURL = this.repository.getURL(pathURI);
                }
                catch (MalformedURLException e) {
                    throw new DeploymentException("Could not locate " + (String)var13_17 + " in repository", (Throwable)e);
                }
                try {
                    moduleFile = new JarFile(pathURL.getFile());
                }
                catch (IOException e) {
                    throw new DeploymentException("Could not access contents of " + (String)var13_17, (Throwable)e);
                }
                URL altSpecDD = null;
                module = var11_15.createModule(vendorDD, (JarFile)moduleFile, moduleName, altSpecDD, URI.create(gerApplication.getConfigId()), moduleContextInfo);
                if (module == null) {
                    throw new DeploymentException("Module was not " + (String)var13_17 + ": " + moduleName);
                }
                modules.add(module);
            }
            Object var22_31 = null;
            iterator2 = altVendorDDs.values().iterator();
        }
        catch (Throwable throwable) {
            Object var22_32 = null;
            Iterator iterator2 = altVendorDDs.values().iterator();
            while (iterator2.hasNext()) {
                Object altVendorDD = iterator2.next();
                if (!(altVendorDD instanceof File)) continue;
                ((File)altVendorDD).delete();
            }
            throw throwable;
        }
        while (iterator2.hasNext()) {
            Object altVendorDD = iterator2.next();
            if (!(altVendorDD instanceof File)) continue;
            ((File)altVendorDD).delete();
        }
    }

    private ModuleBuilder getBuilder(Module module) throws DeploymentException {
        if (module instanceof EJBModule) {
            if (this.ejbConfigBuilder == null) {
                throw new DeploymentException("Cannot deploy ejb application; No ejb deployer defined: " + module.getModuleURI());
            }
            return this.ejbConfigBuilder;
        }
        if (module instanceof WebModule) {
            if (this.webConfigBuilder == null) {
                throw new DeploymentException("Cannot deploy web application; No war deployer defined: " + module.getModuleURI());
            }
            return this.webConfigBuilder;
        }
        if (module instanceof ConnectorModule) {
            if (this.connectorConfigBuilder == null) {
                throw new DeploymentException("Cannot deploy resource adapter; No rar deployer defined: " + module.getModuleURI());
            }
            return this.connectorConfigBuilder;
        }
        if (module instanceof AppClientModule) {
            if (this.appClientConfigBuilder == null) {
                throw new DeploymentException("Cannot deploy app client; No app client deployer defined: " + module.getModuleURI());
            }
            return this.appClientConfigBuilder;
        }
        throw new IllegalArgumentException("Unknown module type: " + module.getClass().getName());
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        $assertionsDisabled = !EARConfigBuilder.class.desiredAssertionStatus();
        GBeanInfoBuilder infoFactory = new GBeanInfoBuilder(EARConfigBuilder.class, "ConfigBuilder");
        infoFactory.addAttribute("defaultParentId", URI;.class, true, true);
        infoFactory.addAttribute("transactionContextManagerObjectName", ObjectName.class, true);
        infoFactory.addAttribute("connectionTrackerObjectName", ObjectName.class, true);
        infoFactory.addAttribute("transactionalTimerObjectName", ObjectName.class, true);
        infoFactory.addAttribute("nonTransactionalTimerObjectName", ObjectName.class, true);
        infoFactory.addAttribute("corbaGBeanObjectName", ObjectName.class, true);
        infoFactory.addReference("Repository", Repository.class, "GBean");
        infoFactory.addReference("EJBConfigBuilder", ModuleBuilder.class, "ModuleBuilder");
        infoFactory.addReference("EJBReferenceBuilder", EJBReferenceBuilder.class, "ModuleBuilder");
        infoFactory.addReference("WebConfigBuilder", ModuleBuilder.class, "ModuleBuilder");
        infoFactory.addReference("ConnectorConfigBuilder", ModuleBuilder.class, "ModuleBuilder");
        infoFactory.addReference("ResourceReferenceBuilder", ResourceReferenceBuilder.class, "ModuleBuilder");
        infoFactory.addReference("AppClientConfigBuilder", ModuleBuilder.class, "ModuleBuilder");
        infoFactory.addReference("ServiceReferenceBuilder", ServiceReferenceBuilder.class, "ModuleBuilder");
        infoFactory.addAttribute("kernel", Kernel.class, false);
        infoFactory.addInterface(ConfigurationBuilder.class);
        infoFactory.setConstructor(new String[]{"defaultParentId", "transactionContextManagerObjectName", "connectionTrackerObjectName", "transactionalTimerObjectName", "nonTransactionalTimerObjectName", "corbaGBeanObjectName", "Repository", "EJBConfigBuilder", "EJBReferenceBuilder", "WebConfigBuilder", "ConnectorConfigBuilder", "ResourceReferenceBuilder", "AppClientConfigBuilder", "ServiceReferenceBuilder", "kernel"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

