/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.j2ee.deployment;

import org.apache.geronimo.deployment.DeploymentException;
import org.apache.geronimo.j2ee.deployment.EJBRefInfo;

public class UnresolvedEJBRefException
extends DeploymentException {
    private final String refName;
    private final EJBRefInfo ejbRefInfo;

    public UnresolvedEJBRefException(String refName, EJBRefInfo ejbRefInfo, boolean foundMultiple) {
        super(UnresolvedEJBRefException.createMessage(refName, ejbRefInfo, foundMultiple));
        this.refName = refName;
        this.ejbRefInfo = ejbRefInfo;
    }

    public String getRefName() {
        return this.refName;
    }

    public EJBRefInfo getEjbRefInfo() {
        return this.ejbRefInfo;
    }

    private static String createMessage(String refName, EJBRefInfo ejbRefInfo, boolean foundMultiple) {
        StringBuffer msg = new StringBuffer();
        if (foundMultiple) {
            msg.append("Two or more EJBs were found");
        } else {
            msg.append("Could not find an EJB");
        }
        msg.append(" for reference ").append(refName).append(" to a ");
        msg.append(ejbRefInfo.isLocal() ? "local " : "remote ");
        msg.append(ejbRefInfo.isSession() ? "session " : "entity ");
        msg.append(" bean that has the home interface ").append(ejbRefInfo.getHomeIntf());
        msg.append(" and the ").append(ejbRefInfo.isLocal() ? "local" : "remote");
        msg.append(" interface ").append(ejbRefInfo.getBeanIntf());
        return msg.toString();
    }
}

