/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.j2ee.deployment;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.Reference;
import org.apache.geronimo.deployment.DeploymentException;
import org.apache.geronimo.j2ee.deployment.AmbiguousEJBRefException;
import org.apache.geronimo.j2ee.deployment.EJBRefInfo;
import org.apache.geronimo.j2ee.deployment.EJBReferenceBuilder;
import org.apache.geronimo.j2ee.deployment.ResourceReferenceBuilder;
import org.apache.geronimo.j2ee.deployment.UnknownEJBRefException;
import org.apache.geronimo.j2ee.deployment.UnresolvedEJBRefException;
import org.apache.geronimo.j2ee.j2eeobjectnames.J2eeContext;
import org.apache.geronimo.j2ee.j2eeobjectnames.NameFactory;

public class RefContext {
    private final EJBReferenceBuilder ejbReferenceBuilder;
    private final ResourceReferenceBuilder resourceReferenceBuilder;
    private final Map ejbRemoteIndex;
    private final Map ejbLocalIndex;
    private final Map ejbInterfaceIndex;
    private final Map resourceAdapterIndex;
    private final Map connectionFactoryIndex;
    private final Map adminObjectIndex;
    private final Map activationSpecInfos;
    static final /* synthetic */ boolean $assertionsDisabled;

    public RefContext(EJBReferenceBuilder ejbReferenceBuilder, ResourceReferenceBuilder resourceReferenceBuilder) {
        if (!$assertionsDisabled && ejbReferenceBuilder == null) {
            throw new AssertionError((Object)"ejbReferenceBuilder is null");
        }
        if (!$assertionsDisabled && resourceReferenceBuilder == null) {
            throw new AssertionError((Object)"resourceReferenceBuilder is null");
        }
        this.ejbRemoteIndex = new HashMap();
        this.ejbLocalIndex = new HashMap();
        this.ejbInterfaceIndex = new HashMap();
        this.resourceAdapterIndex = new HashMap();
        this.connectionFactoryIndex = new HashMap();
        this.adminObjectIndex = new HashMap();
        this.activationSpecInfos = new HashMap();
        this.ejbReferenceBuilder = ejbReferenceBuilder;
        this.resourceReferenceBuilder = resourceReferenceBuilder;
    }

    public static RefContext derivedClientRefContext(RefContext refContext, EJBReferenceBuilder ejbReferenceBuilder, ResourceReferenceBuilder resourceReferenceBuilder) {
        return new RefContext(refContext, ejbReferenceBuilder, resourceReferenceBuilder);
    }

    private RefContext(RefContext refContext, EJBReferenceBuilder ejbReferenceBuilder, ResourceReferenceBuilder resourceReferenceBuilder) {
        if (!$assertionsDisabled && ejbReferenceBuilder == null) {
            throw new AssertionError((Object)"ejbReferenceBuilder is null");
        }
        if (!$assertionsDisabled && resourceReferenceBuilder == null) {
            throw new AssertionError((Object)"resourceReferenceBuilder is null");
        }
        if (!$assertionsDisabled && refContext == null) {
            throw new AssertionError((Object)"ejbRefContext is null");
        }
        this.ejbReferenceBuilder = ejbReferenceBuilder;
        this.resourceReferenceBuilder = resourceReferenceBuilder;
        this.ejbRemoteIndex = refContext.ejbRemoteIndex;
        this.ejbLocalIndex = new HashMap();
        this.ejbInterfaceIndex = refContext.ejbInterfaceIndex;
        this.resourceAdapterIndex = new HashMap();
        this.connectionFactoryIndex = new HashMap();
        this.adminObjectIndex = new HashMap();
        this.activationSpecInfos = new HashMap();
    }

    public EJBReferenceBuilder getEjbReferenceBuilder() {
        return this.ejbReferenceBuilder;
    }

    public Map getEJBRemoteIndex() {
        return this.ejbRemoteIndex;
    }

    public Map getEJBLocalIndex() {
        return this.ejbLocalIndex;
    }

    public Map getConnectionFactoryIndex() {
        return this.connectionFactoryIndex;
    }

    public Map getAdminObjectIndex() {
        return this.adminObjectIndex;
    }

    public void addEJBRemoteId(URI modulePath, String name, String containerId, boolean isSession, String home, String remote) throws DeploymentException {
        EJBRefInfo ejbRefInfo;
        HashMap interfacesReferences;
        HashMap references = (HashMap)this.ejbRemoteIndex.get(name);
        if (references == null || references.isEmpty()) {
            references = new HashMap();
            this.ejbRemoteIndex.put(name, references);
        }
        if ((interfacesReferences = (HashMap)this.ejbInterfaceIndex.get(ejbRefInfo = new EJBRefInfo(false, isSession, home, remote))) == null || interfacesReferences.isEmpty()) {
            interfacesReferences = new HashMap();
            this.ejbInterfaceIndex.put(ejbRefInfo, interfacesReferences);
        }
        this.addEJBId(modulePath, name, containerId, references, interfacesReferences);
    }

    public void addEJBLocalId(URI modulePath, String name, String containerId, boolean isSession, String localHome, String local) throws DeploymentException {
        EJBRefInfo ejbRefInfo;
        HashMap interfacesReferences;
        HashMap references = (HashMap)this.ejbLocalIndex.get(name);
        if (references == null || references.isEmpty()) {
            references = new HashMap();
            this.ejbLocalIndex.put(name, references);
        }
        if ((interfacesReferences = (HashMap)this.ejbInterfaceIndex.get(ejbRefInfo = new EJBRefInfo(true, isSession, localHome, local))) == null || interfacesReferences.isEmpty()) {
            interfacesReferences = new HashMap();
            this.ejbInterfaceIndex.put(ejbRefInfo, interfacesReferences);
        }
        this.addEJBId(modulePath, name, containerId, references, interfacesReferences);
    }

    private void addEJBId(URI modulePath, String name, String containerId, Map references, Map interfacesReferences) throws DeploymentException {
        try {
            URI ejbURI = new URI(null, null, modulePath.getPath(), name);
            references.put(ejbURI, containerId);
            URI moduleURI = new URI(null, null, modulePath.getPath(), null);
            interfacesReferences.put(moduleURI, containerId);
        }
        catch (URISyntaxException e) {
            throw new DeploymentException((Throwable)e);
        }
    }

    public void addResourceAdapterId(URI modulePath, String name, String containerId) throws DeploymentException {
        HashMap<URI, String> references = (HashMap<URI, String>)this.connectionFactoryIndex.get(name);
        if (references == null || references.isEmpty()) {
            references = new HashMap<URI, String>();
            this.resourceAdapterIndex.put(name, references);
        }
        try {
            URI cfURI = new URI(null, null, modulePath.getPath(), name);
            references.put(cfURI, containerId);
        }
        catch (URISyntaxException e) {
            throw new DeploymentException((Throwable)e);
        }
    }

    public void addConnectionFactoryId(URI modulePath, String name, String containerId) throws DeploymentException {
        HashMap<URI, String> references = (HashMap<URI, String>)this.connectionFactoryIndex.get(name);
        if (references == null || references.isEmpty()) {
            references = new HashMap<URI, String>();
            this.connectionFactoryIndex.put(name, references);
        }
        try {
            URI cfURI = new URI(null, null, modulePath.getPath(), name);
            references.put(cfURI, containerId);
        }
        catch (URISyntaxException e) {
            throw new DeploymentException((Throwable)e);
        }
    }

    public void addAdminObjectId(URI modulePath, String name, String containerId) throws DeploymentException {
        HashMap<URI, String> references = (HashMap<URI, String>)this.adminObjectIndex.get(name);
        if (references == null || references.isEmpty()) {
            references = new HashMap<URI, String>();
            this.adminObjectIndex.put(name, references);
        }
        try {
            URI cfURI = new URI(null, null, modulePath.getPath(), name);
            references.put(cfURI, containerId);
        }
        catch (URISyntaxException e) {
            throw new DeploymentException((Throwable)e);
        }
    }

    public Reference getEJBRemoteRef(String objectName, boolean isSession, String home, String remote) throws DeploymentException {
        return this.ejbReferenceBuilder.createEJBRemoteReference(objectName, isSession, home, remote);
    }

    public Reference getEJBLocalRef(String objectName, boolean isSession, String localHome, String local) throws DeploymentException {
        return this.ejbReferenceBuilder.createEJBLocalReference(objectName, isSession, localHome, local);
    }

    public Reference getEJBRemoteRef(URI module, String ejbLink, boolean isSession, String home, String remote) throws DeploymentException {
        String name = ejbLink.substring(ejbLink.lastIndexOf(35) + 1);
        String containerId = this.getContainerId(module, ejbLink, (Map)this.ejbRemoteIndex.get(name));
        return this.getEJBRemoteRef(containerId, isSession, home, remote);
    }

    public Reference getEJBLocalRef(URI module, String ejbLink, boolean isSession, String localHome, String local) throws DeploymentException {
        String name = ejbLink.substring(ejbLink.lastIndexOf(35) + 1);
        String containerId = this.getContainerId(module, ejbLink, (Map)this.ejbLocalIndex.get(name));
        return this.getEJBLocalRef(containerId, isSession, localHome, local);
    }

    public Reference getConnectionFactoryRef(String containerId, Class iface) throws DeploymentException {
        return this.resourceReferenceBuilder.createResourceRef(containerId, iface);
    }

    public String getResourceAdapterContainerId(URI module, String resourceLink, J2eeContext j2eeContext) throws DeploymentException, UnknownEJBRefException {
        String name = resourceLink.substring(resourceLink.lastIndexOf(35) + 1);
        try {
            return this.getContainerId(module, resourceLink, (Map)this.connectionFactoryIndex.get(name));
        }
        catch (UnknownEJBRefException e) {
            ObjectName query = null;
            try {
                query = NameFactory.getComponentRestrictedQueryName(null, null, (String)name, (String)"JCAResourceAdapter", (J2eeContext)j2eeContext);
            }
            catch (MalformedObjectNameException e1) {
                throw new DeploymentException("Could not construct resource adapter object name query", (Throwable)((Object)e));
            }
            ObjectName containerName = this.resourceReferenceBuilder.locateResourceName(query);
            return containerName.getCanonicalName();
        }
    }

    public String getConnectionFactoryContainerId(URI module, String resourceLink, J2eeContext j2eeContext) throws DeploymentException, UnknownEJBRefException {
        String name = resourceLink.substring(resourceLink.lastIndexOf(35) + 1);
        try {
            return this.getContainerId(module, resourceLink, (Map)this.connectionFactoryIndex.get(name));
        }
        catch (UnknownEJBRefException e) {
            ObjectName query = null;
            try {
                query = NameFactory.getComponentRestrictedQueryName(null, null, (String)name, (String)NameFactory.JCA_MANAGED_CONNECTION_FACTORY, (J2eeContext)j2eeContext);
            }
            catch (MalformedObjectNameException e1) {
                throw new DeploymentException("Could not construct connection factory object name query", (Throwable)((Object)e));
            }
            ObjectName containerName = this.resourceReferenceBuilder.locateResourceName(query);
            return containerName.getCanonicalName();
        }
    }

    public Reference getAdminObjectRef(String containerId, Class iface) throws DeploymentException {
        return this.resourceReferenceBuilder.createAdminObjectRef(containerId, iface);
    }

    public String getAdminObjectContainerId(URI module, String resourceLink, J2eeContext j2eeContext) throws DeploymentException, UnknownEJBRefException {
        String name = resourceLink.substring(resourceLink.lastIndexOf(35) + 1);
        try {
            return this.getContainerId(module, resourceLink, (Map)this.adminObjectIndex.get(name));
        }
        catch (UnknownEJBRefException e) {
            ObjectName query = null;
            try {
                query = NameFactory.getComponentRestrictedQueryName(null, null, (String)name, (String)"JCAAdminObject", (J2eeContext)j2eeContext);
            }
            catch (MalformedObjectNameException e1) {
                throw new DeploymentException("Could not construct admin object object name query", (Throwable)((Object)e));
            }
            ObjectName containerName = this.resourceReferenceBuilder.locateResourceName(query);
            return containerName.getCanonicalName();
        }
    }

    private String getContainerId(URI module, String ejbLink, Map references) throws AmbiguousEJBRefException, UnknownEJBRefException {
        if (references == null || references.isEmpty()) {
            throw new UnknownEJBRefException(ejbLink);
        }
        if (ejbLink.indexOf(35) >= 0) {
            URI ejbURI = module.resolve(ejbLink).normalize();
            String ejbRef = (String)references.get(ejbURI);
            if (ejbRef == null) {
                throw new UnknownEJBRefException(ejbLink);
            }
            return ejbRef;
        }
        if (references.size() == 1) {
            String ejbRef = (String)references.values().iterator().next();
            if (ejbRef == null) {
                throw new UnknownEJBRefException(ejbLink);
            }
            return ejbRef;
        }
        String ejbRef = (String)references.get(module.resolve("#" + ejbLink));
        if (ejbRef != null) {
            return ejbRef;
        }
        throw new AmbiguousEJBRefException(ejbLink);
    }

    public Reference getImplicitEJBRemoteRef(URI module, String refName, boolean isSession, String home, String remote) throws DeploymentException {
        EJBRefInfo ejbRefInfo = new EJBRefInfo(false, isSession, home, remote);
        String containerId = this.getImplicitContainerId(module, refName, ejbRefInfo);
        return this.getEJBRemoteRef(containerId, isSession, home, remote);
    }

    public Reference getImplicitEJBLocalRef(URI module, String refName, boolean isSession, String localHome, String local) throws DeploymentException {
        EJBRefInfo ejbRefInfo = new EJBRefInfo(true, isSession, localHome, local);
        String containerId = this.getImplicitContainerId(module, refName, ejbRefInfo);
        return this.getEJBLocalRef(containerId, isSession, localHome, local);
    }

    private String getImplicitContainerId(URI module, String refName, EJBRefInfo ejbRefInfo) throws DeploymentException {
        Map references = (Map)this.ejbInterfaceIndex.get(ejbRefInfo);
        if (references == null || references.isEmpty()) {
            throw new UnresolvedEJBRefException(refName, ejbRefInfo, false);
        }
        if (references.size() == 1) {
            return (String)references.values().iterator().next();
        }
        String ejbRef = (String)references.get(module);
        if (ejbRef != null) {
            return ejbRef;
        }
        throw new UnresolvedEJBRefException(refName, ejbRefInfo, true);
    }

    public void addActivationSpecInfos(ObjectName resourceAdapterName, Map activationSpecInfoMap) throws DeploymentException {
        Map old = this.activationSpecInfos.put(resourceAdapterName, activationSpecInfoMap);
        if (old != null) {
            throw new DeploymentException("Duplicate resource adapter name: " + resourceAdapterName);
        }
    }

    public Object getActivationSpecInfo(ObjectName resourceAdapterName, String messageListenerInterfaceName) throws DeploymentException {
        Map activationSpecInfoMap = (Map)this.activationSpecInfos.get(resourceAdapterName);
        if (activationSpecInfoMap != null) {
            return activationSpecInfoMap.get(messageListenerInterfaceName);
        }
        return this.resourceReferenceBuilder.locateActivationSpecInfo(resourceAdapterName, messageListenerInterfaceName);
    }

    static {
        $assertionsDisabled = !RefContext.class.desiredAssertionStatus();
    }
}

