/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.j2ee.deployment;

import java.net.URI;
import java.util.jar.JarFile;
import org.apache.geronimo.deployment.util.DeploymentUtil;
import org.apache.geronimo.kernel.config.ConfigurationModuleType;
import org.apache.xmlbeans.XmlObject;

public abstract class Module {
    private final boolean standAlone;
    private final String name;
    private final URI configId;
    private final URI parentId;
    private final URI moduleURI;
    private final JarFile moduleFile;
    private final String targetPath;
    private final XmlObject specDD;
    private final XmlObject vendorDD;
    private final String originalSpecDD;

    protected Module(boolean standAlone, URI configId, URI parentId, JarFile moduleFile, String targetPath, XmlObject specDD, XmlObject vendorDD, String originalSpecDD) {
        this.standAlone = standAlone;
        this.configId = configId;
        this.parentId = parentId;
        this.moduleFile = moduleFile;
        this.targetPath = targetPath;
        this.specDD = specDD;
        this.vendorDD = vendorDD;
        this.originalSpecDD = originalSpecDD;
        if (standAlone) {
            this.name = configId.toString();
            this.moduleURI = URI.create("");
        } else {
            this.name = targetPath;
            this.moduleURI = URI.create(targetPath);
        }
    }

    public abstract ConfigurationModuleType getType();

    public String getName() {
        return this.name;
    }

    public boolean isStandAlone() {
        return this.standAlone;
    }

    public URI getConfigId() {
        return this.configId;
    }

    public URI getParentId() {
        return this.parentId;
    }

    public URI getModuleURI() {
        return this.moduleURI;
    }

    public JarFile getModuleFile() {
        return this.moduleFile;
    }

    public String getTargetPath() {
        return this.targetPath;
    }

    public XmlObject getSpecDD() {
        return this.specDD;
    }

    public XmlObject getVendorDD() {
        return this.vendorDD;
    }

    public String getOriginalSpecDD() {
        return this.originalSpecDD;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Module) {
            Module module = (Module)obj;
            return this.name.equals(module.name);
        }
        return false;
    }

    public void close() {
        DeploymentUtil.close((JarFile)this.moduleFile);
    }
}

