/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.j2ee.deployment;

import java.io.File;
import java.net.URI;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.geronimo.deployment.DeploymentContext;
import org.apache.geronimo.deployment.DeploymentException;
import org.apache.geronimo.j2ee.deployment.RefContext;
import org.apache.geronimo.j2ee.j2eeobjectnames.J2eeContext;
import org.apache.geronimo.j2ee.j2eeobjectnames.J2eeContextImpl;
import org.apache.geronimo.j2ee.j2eeobjectnames.NameFactory;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.config.ConfigurationModuleType;

public class EARContext
extends DeploymentContext {
    private final ObjectName domainObjectName;
    private final ObjectName serverObjectName;
    private final ObjectName applicationObjectName;
    private final ObjectName transactionContextManagerObjectName;
    private final ObjectName connectionTrackerObjectName;
    private final ObjectName transactedTimerName;
    private final ObjectName nonTransactedTimerName;
    private final RefContext refContext;
    private final J2eeContext j2eeContext;

    public EARContext(File baseDir, URI id, ConfigurationModuleType moduleType, URI parentID, Kernel kernel, String j2eeDomainName, String j2eeServerName, String j2eeApplicationName, ObjectName transactionContextManagerObjectName, ObjectName connectionTrackerObjectName, ObjectName transactedTimerName, ObjectName nonTransactedTimerName, RefContext refContext) throws MalformedObjectNameException, DeploymentException {
        super(baseDir, id, moduleType, parentID, kernel);
        this.j2eeContext = new J2eeContextImpl(j2eeDomainName, j2eeServerName, j2eeApplicationName == null ? NameFactory.NULL : j2eeApplicationName, null, null, null);
        this.domainObjectName = NameFactory.getDomainName(null, (J2eeContext)this.j2eeContext);
        this.serverObjectName = NameFactory.getServerName(null, null, (J2eeContext)this.j2eeContext);
        this.applicationObjectName = j2eeApplicationName != null ? NameFactory.getApplicationName(null, null, null, (J2eeContext)this.j2eeContext) : null;
        this.transactionContextManagerObjectName = transactionContextManagerObjectName;
        this.connectionTrackerObjectName = connectionTrackerObjectName;
        this.transactedTimerName = transactedTimerName;
        this.nonTransactedTimerName = nonTransactedTimerName;
        this.refContext = refContext;
    }

    public String getJ2EEDomainName() {
        return this.j2eeContext.getJ2eeDomainName();
    }

    public String getJ2EEServerName() {
        return this.j2eeContext.getJ2eeServerName();
    }

    public String getJ2EEApplicationName() {
        return this.j2eeContext.getJ2eeApplicationName();
    }

    public ObjectName getDomainObjectName() {
        return this.domainObjectName;
    }

    public ObjectName getServerObjectName() {
        return this.serverObjectName;
    }

    public ObjectName getApplicationObjectName() {
        return this.applicationObjectName;
    }

    public ObjectName getTransactionContextManagerObjectName() {
        return this.transactionContextManagerObjectName;
    }

    public ObjectName getConnectionTrackerObjectName() {
        return this.connectionTrackerObjectName;
    }

    public ObjectName getTransactedTimerName() {
        return this.transactedTimerName;
    }

    public ObjectName getNonTransactedTimerName() {
        return this.nonTransactedTimerName;
    }

    public RefContext getRefContext() {
        return this.refContext;
    }

    public J2eeContext getJ2eeContext() {
        return this.j2eeContext;
    }
}

