/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.j2ee.deployment;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.geronimo.deployment.ConfigurationBuilder;
import org.apache.geronimo.deployment.DeploymentContext;
import org.apache.geronimo.deployment.DeploymentException;
import org.apache.geronimo.deployment.service.GBeanAdapter;
import org.apache.geronimo.deployment.service.GBeanHelper;
import org.apache.geronimo.deployment.util.DeploymentUtil;
import org.apache.geronimo.deployment.util.NestedJarFile;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.jmx.GBeanMBean;
import org.apache.geronimo.j2ee.ApplicationInfo;
import org.apache.geronimo.j2ee.deployment.AppClientModule;
import org.apache.geronimo.j2ee.deployment.ConnectorModule;
import org.apache.geronimo.j2ee.deployment.EARContext;
import org.apache.geronimo.j2ee.deployment.EJBModule;
import org.apache.geronimo.j2ee.deployment.EJBReferenceBuilder;
import org.apache.geronimo.j2ee.deployment.GerGBeanAdapter;
import org.apache.geronimo.j2ee.deployment.Module;
import org.apache.geronimo.j2ee.deployment.ModuleBuilder;
import org.apache.geronimo.j2ee.deployment.RefContext;
import org.apache.geronimo.j2ee.deployment.ResourceReferenceBuilder;
import org.apache.geronimo.j2ee.deployment.WebModule;
import org.apache.geronimo.j2ee.j2eeobjectnames.NameFactory;
import org.apache.geronimo.j2ee.management.impl.J2EEApplicationImpl;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.config.ConfigurationModuleType;
import org.apache.geronimo.kernel.repository.Repository;
import org.apache.geronimo.schema.SchemaConversionUtils;
import org.apache.geronimo.xbeans.geronimo.j2ee.GerApplicationDocument;
import org.apache.geronimo.xbeans.geronimo.j2ee.GerApplicationType;
import org.apache.geronimo.xbeans.geronimo.j2ee.GerDependencyType;
import org.apache.geronimo.xbeans.geronimo.j2ee.GerGbeanType;
import org.apache.geronimo.xbeans.geronimo.j2ee.GerModuleType;
import org.apache.geronimo.xbeans.j2ee.ApplicationType;
import org.apache.geronimo.xbeans.j2ee.ModuleType;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;

public class EARConfigBuilder
implements ConfigurationBuilder {
    private final Kernel kernel;
    private final Repository repository;
    private final ModuleBuilder ejbConfigBuilder;
    private final ModuleBuilder webConfigBuilder;
    private final ModuleBuilder connectorConfigBuilder;
    private final ModuleBuilder appClientConfigBuilder;
    private final EJBReferenceBuilder ejbReferenceBuilder;
    private final ResourceReferenceBuilder resourceReferenceBuilder;
    private final URI defaultParentId;
    private final String j2eeServerName;
    private final String j2eeDomainName;
    private final ObjectName j2eeServer;
    private final ObjectName transactionContextManagerObjectName;
    private final ObjectName connectionTrackerObjectName;
    private final ObjectName transactionalTimerObjectName;
    private final ObjectName nonTransactionalTimerObjectName;
    public static final GBeanInfo GBEAN_INFO;

    public EARConfigBuilder(URI defaultParentId, ObjectName j2eeServer, ObjectName transactionContextManagerObjectName, ObjectName connectionTrackerObjectName, ObjectName transactionalTimerObjectName, ObjectName nonTransactionalTimerObjectName, Repository repository, ModuleBuilder ejbConfigBuilder, EJBReferenceBuilder ejbReferenceBuilder, ModuleBuilder webConfigBuilder, ModuleBuilder connectorConfigBuilder, ResourceReferenceBuilder resourceReferenceBuilder, ModuleBuilder appClientConfigBuilder, Kernel kernel) {
        this.kernel = kernel;
        this.repository = repository;
        this.defaultParentId = defaultParentId;
        this.j2eeServer = j2eeServer;
        this.j2eeServerName = j2eeServer.getKeyProperty("name");
        this.j2eeDomainName = j2eeServer.getDomain();
        this.ejbConfigBuilder = ejbConfigBuilder;
        this.ejbReferenceBuilder = ejbReferenceBuilder;
        this.resourceReferenceBuilder = resourceReferenceBuilder;
        this.webConfigBuilder = webConfigBuilder;
        this.connectorConfigBuilder = connectorConfigBuilder;
        this.appClientConfigBuilder = appClientConfigBuilder;
        this.transactionContextManagerObjectName = transactionContextManagerObjectName;
        this.connectionTrackerObjectName = connectionTrackerObjectName;
        this.transactionalTimerObjectName = transactionalTimerObjectName;
        this.nonTransactionalTimerObjectName = nonTransactionalTimerObjectName;
    }

    public Object getDeploymentPlan(File planFile, JarFile jarFile) throws DeploymentException {
        if (jarFile == null) {
            return null;
        }
        Object plan = this.getEarPlan(planFile, jarFile);
        if (plan != null) {
            return plan;
        }
        Module module = null;
        if (this.webConfigBuilder != null) {
            module = this.webConfigBuilder.createModule(planFile, jarFile);
        }
        if (module == null && this.ejbConfigBuilder != null) {
            module = this.ejbConfigBuilder.createModule(planFile, jarFile);
        }
        if (module == null && this.connectorConfigBuilder != null) {
            module = this.connectorConfigBuilder.createModule(planFile, jarFile);
        }
        if (module == null && this.appClientConfigBuilder != null) {
            module = this.appClientConfigBuilder.createModule(planFile, jarFile);
        }
        if (module == null) {
            return null;
        }
        return new ApplicationInfo(module.getType(), module.getConfigId(), module.getParentId(), NameFactory.NULL, null, null, Collections.singleton(module), Collections.EMPTY_SET, null);
    }

    private Object getEarPlan(File planFile, JarFile earFile) throws DeploymentException {
        ApplicationType application;
        try {
            URL applicationXmlUrl = DeploymentUtil.createJarURL((JarFile)earFile, (String)"META-INF/application.xml");
            XmlObject xmlObject = SchemaConversionUtils.parse((URL)applicationXmlUrl);
            application = SchemaConversionUtils.convertToApplicationSchema((XmlObject)xmlObject).getApplication();
        }
        catch (Exception e) {
            return null;
        }
        if (application == null) {
            return null;
        }
        GerApplicationType gerApplication = null;
        try {
            GerApplicationDocument gerApplicationDoc = null;
            try {
                if (planFile != null) {
                    gerApplicationDoc = GerApplicationDocument.Factory.parse(planFile);
                } else {
                    URL path = DeploymentUtil.createJarURL((JarFile)earFile, (String)"META-INF/geronimo-application.xml");
                    gerApplicationDoc = GerApplicationDocument.Factory.parse(path);
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            if (gerApplicationDoc != null) {
                SchemaConversionUtils.validateDD((XmlObject)gerApplicationDoc);
                gerApplication = gerApplicationDoc.getApplication();
            } else {
                gerApplication = this.createDefaultPlan(application, earFile);
            }
        }
        catch (XmlException e) {
            throw new DeploymentException((Throwable)e);
        }
        URI configId = null;
        try {
            configId = new URI(gerApplication.getConfigId());
        }
        catch (URISyntaxException e) {
            throw new DeploymentException("Invalid configId " + gerApplication.getConfigId(), (Throwable)e);
        }
        URI parentId = null;
        if (gerApplication.isSetParentId()) {
            try {
                parentId = new URI(gerApplication.getParentId());
            }
            catch (URISyntaxException e) {
                throw new DeploymentException("Invalid parentId " + gerApplication.getParentId(), (Throwable)e);
            }
        } else {
            parentId = this.defaultParentId;
        }
        HashSet moduleLocations = new HashSet();
        LinkedHashSet modules = new LinkedHashSet();
        try {
            this.addModules(earFile, application, gerApplication, moduleLocations, modules);
        }
        catch (Throwable e) {
            Iterator iterator = modules.iterator();
            while (iterator.hasNext()) {
                Module module = (Module)iterator.next();
                module.close();
            }
            if (e instanceof DeploymentException) {
                throw (DeploymentException)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            throw new DeploymentException(e);
        }
        String applicationName = gerApplication.isSetApplicationName() ? gerApplication.getApplicationName() : configId.toString();
        return new ApplicationInfo(ConfigurationModuleType.EAR, configId, parentId, applicationName, (XmlObject)application, gerApplication, modules, moduleLocations, application.toString());
    }

    private GerApplicationType createDefaultPlan(ApplicationType application, JarFile module) {
        GerApplicationType gerApplication = GerApplicationType.Factory.newInstance();
        gerApplication.setParentId(this.defaultParentId.toString());
        String id = application.getId();
        if (id == null) {
            File fileName = new File(module.getName());
            id = fileName.getName();
            if (id.endsWith(".ear")) {
                id = id.substring(0, id.length() - 4);
            }
            if (id.endsWith("/")) {
                id = id.substring(0, id.length() - 1);
            }
        }
        gerApplication.setConfigId(id);
        return gerApplication;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List buildConfiguration(Object plan, JarFile earFile, File outfile) throws IOException, DeploymentException {
        Iterator iterator4;
        LinkedList<String> linkedList;
        ApplicationInfo applicationInfo = (ApplicationInfo)plan;
        try {
            GerApplicationType geronimoApplication;
            LinkedList<String> moduleIDs = new LinkedList<String>();
            EARContext earContext = null;
            ConfigurationModuleType applicationType = applicationInfo.getType();
            try {
                earContext = new EARContext(outfile, applicationInfo.getConfigId(), applicationType, applicationInfo.getParentId(), this.kernel, this.j2eeDomainName, this.j2eeServerName, applicationInfo.getApplicationName(), this.transactionContextManagerObjectName, this.connectionTrackerObjectName, this.transactionalTimerObjectName, this.nonTransactionalTimerObjectName, new RefContext(this.ejbReferenceBuilder, this.resourceReferenceBuilder));
            }
            catch (MalformedObjectNameException e) {
                throw new DeploymentException((Throwable)e);
            }
            Set moduleLocations = applicationInfo.getModuleLocations();
            if (ConfigurationModuleType.EAR == applicationType) {
                Enumeration<JarEntry> e = earFile.entries();
                while (e.hasMoreElements()) {
                    ZipEntry entry = e.nextElement();
                    if (moduleLocations.contains(entry.getName())) continue;
                    earContext.addFile(URI.create(entry.getName()), earFile, entry);
                }
            }
            if ((geronimoApplication = (GerApplicationType)applicationInfo.getVendorDD()) != null) {
                GerDependencyType[] dependencies = geronimoApplication.getDependencyArray();
                for (int i = 0; i < dependencies.length; ++i) {
                    earContext.addDependency(this.getDependencyURI(dependencies[i]));
                }
            }
            Set modules = applicationInfo.getModules();
            Iterator iterator2 = modules.iterator();
            while (iterator2.hasNext()) {
                Module module = (Module)iterator2.next();
                this.getBuilder(module).installModule(earFile, earContext, module);
            }
            ClassLoader cl = earContext.getClassLoader(this.repository);
            Iterator iterator3 = modules.iterator();
            while (iterator3.hasNext()) {
                Module module = (Module)iterator3.next();
                this.getBuilder(module).initContext(earContext, module, cl);
            }
            if (geronimoApplication != null) {
                GerGbeanType[] gbeans = geronimoApplication.getGbeanArray();
                for (int i = 0; i < gbeans.length; ++i) {
                    GBeanHelper.addGbean((GBeanAdapter)new GerGBeanAdapter(gbeans[i]), (ClassLoader)cl, (DeploymentContext)earContext);
                }
            }
            if (ConfigurationModuleType.EAR == applicationType) {
                GBeanMBean gbean = new GBeanMBean(J2EEApplicationImpl.GBEAN_INFO, cl);
                try {
                    gbean.setAttribute("deploymentDescriptor", (Object)applicationInfo.getOriginalSpecDD());
                }
                catch (Exception e) {
                    throw new DeploymentException("Error initializing J2EEApplication managed object");
                }
                gbean.setReferencePatterns("j2eeServer", Collections.singleton(this.j2eeServer));
                ObjectName applicationName = earContext.getApplicationObjectName();
                earContext.addGBean(applicationName, gbean);
            }
            iterator3 = modules.iterator();
            while (iterator3.hasNext()) {
                Module module = (Module)iterator3.next();
                String moduleID = this.getBuilder(module).addGBeans(earContext, module, cl);
                if (moduleID == null) continue;
                moduleIDs.add(moduleID);
            }
            earContext.close();
            linkedList = moduleIDs;
            Object var16_21 = null;
            Set modules2 = applicationInfo.getModules();
            iterator4 = modules2.iterator();
        }
        catch (Throwable throwable) {
            Object var16_22 = null;
            Set modules2 = applicationInfo.getModules();
            Iterator iterator4 = modules2.iterator();
            while (iterator4.hasNext()) {
                Module module = (Module)iterator4.next();
                module.close();
            }
            throw throwable;
        }
        while (iterator4.hasNext()) {
            Module module = (Module)iterator4.next();
            module.close();
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void addModules(JarFile earFile, ApplicationType application, GerApplicationType gerApplication, Set moduleLocations, Set modules) throws DeploymentException {
        Iterator iterator2;
        HashMap<String, File> altVendorDDs = new HashMap<String, File>();
        try {
            GerModuleType[] gerModuleTypes = gerApplication.getModuleArray();
            for (int i = 0; i < gerModuleTypes.length; ++i) {
                GerModuleType gerModule = gerModuleTypes[i];
                String path = null;
                if (gerModule.isSetEjb()) {
                    path = gerModule.getEjb().getStringValue();
                } else if (gerModule.isSetWeb()) {
                    path = gerModule.getWeb().getStringValue();
                } else if (gerModule.isSetConnector()) {
                    path = gerModule.getConnector().getStringValue();
                } else if (gerModule.isSetJava()) {
                    path = gerModule.getJava().getStringValue();
                }
                if (gerModule.isSetAltDd()) {
                    try {
                        altVendorDDs.put(path, DeploymentUtil.toTempFile((JarFile)earFile, (String)gerModule.getAltDd().getStringValue()));
                        continue;
                    }
                    catch (IOException e) {
                        throw new DeploymentException("Invalid alt vendor dd url: " + gerModule.getAltDd().getStringValue(), (Throwable)e);
                    }
                }
                XmlCursor cursor = gerModule.newCursor();
                try {
                    cursor.toFirstChild();
                    cursor.toNextSibling();
                    XmlObject any = cursor.getObject();
                    altVendorDDs.put(path, (File)any);
                    continue;
                }
                finally {
                    cursor.dispose();
                }
            }
            ModuleType[] moduleTypes = application.getModuleArray();
            for (int i = 0; i < moduleTypes.length; ++i) {
                void var12_15;
                void var11_13;
                String moduleTypeName;
                ModuleBuilder builder;
                String modulePath;
                ModuleType moduleXml = moduleTypes[i];
                if (moduleXml.isSetEjb()) {
                    modulePath = moduleXml.getEjb().getStringValue();
                    if (this.ejbConfigBuilder == null) {
                        throw new DeploymentException("Can not deploy ejb application; No ejb deployer defined: " + modulePath);
                    }
                    builder = this.ejbConfigBuilder;
                    moduleTypeName = "an EJB";
                } else if (moduleXml.isSetWeb()) {
                    modulePath = moduleXml.getWeb().getWebUri().getStringValue();
                    if (this.webConfigBuilder == null) {
                        throw new DeploymentException("Can not deploy web application; No war deployer defined: " + modulePath);
                    }
                    builder = this.webConfigBuilder;
                    moduleTypeName = "a war";
                } else if (moduleXml.isSetConnector()) {
                    modulePath = moduleXml.getConnector().getStringValue();
                    if (this.connectorConfigBuilder == null) {
                        throw new DeploymentException("Can not deploy resource adapter; No rar deployer defined: " + modulePath);
                    }
                    builder = this.connectorConfigBuilder;
                    moduleTypeName = "a connector";
                } else if (moduleXml.isSetJava()) {
                    modulePath = moduleXml.getJava().getStringValue();
                    if (this.appClientConfigBuilder == null) {
                        throw new DeploymentException("Can not deploy app client; No app client deployer defined: " + modulePath);
                    }
                    builder = this.appClientConfigBuilder;
                    moduleTypeName = "an application client";
                } else {
                    throw new DeploymentException("Could not find a module builder for module: " + moduleXml);
                }
                moduleLocations.add(var11_13);
                URL altSpecDD = null;
                if (moduleXml.isSetAltDd()) {
                    try {
                        altSpecDD = DeploymentUtil.createJarURL((JarFile)earFile, (String)moduleXml.getAltDd().getStringValue());
                    }
                    catch (MalformedURLException e) {
                        throw new DeploymentException("Invalid alt sped dd url: " + moduleXml.getAltDd().getStringValue(), (Throwable)e);
                    }
                }
                NestedJarFile moduleFile = null;
                try {
                    moduleFile = new NestedJarFile(earFile, (String)var11_13);
                }
                catch (IOException e) {
                    throw new DeploymentException("Invalid moduleFile: " + (String)var11_13, (Throwable)e);
                }
                Module module = var12_15.createModule(altVendorDDs.get(var11_13), (JarFile)moduleFile, (String)var11_13, altSpecDD, URI.create(gerApplication.getConfigId()));
                if (module == null) {
                    void var13_17;
                    throw new DeploymentException("Module was not " + (String)var13_17 + ": " + (String)var11_13);
                }
                if (module instanceof WebModule) {
                    ((WebModule)module).setContextRoot(moduleXml.getWeb().getContextRoot().getStringValue());
                }
                modules.add(module);
            }
            Object var18_23 = null;
            iterator2 = altVendorDDs.values().iterator();
        }
        catch (Throwable throwable) {
            Object var18_24 = null;
            Iterator iterator2 = altVendorDDs.values().iterator();
            while (iterator2.hasNext()) {
                Object altVendorDD = iterator2.next();
                if (!(altVendorDD instanceof File)) continue;
                ((File)altVendorDD).delete();
            }
            throw throwable;
        }
        while (iterator2.hasNext()) {
            Object altVendorDD = iterator2.next();
            if (!(altVendorDD instanceof File)) continue;
            ((File)altVendorDD).delete();
        }
    }

    private ModuleBuilder getBuilder(Module module) throws DeploymentException {
        if (module instanceof EJBModule) {
            if (this.ejbConfigBuilder == null) {
                throw new DeploymentException("Can not deploy ejb application; No ejb deployer defined: " + module.getModuleURI());
            }
            return this.ejbConfigBuilder;
        }
        if (module instanceof WebModule) {
            if (this.webConfigBuilder == null) {
                throw new DeploymentException("Can not deploy web application; No war deployer defined: " + module.getModuleURI());
            }
            return this.webConfigBuilder;
        }
        if (module instanceof ConnectorModule) {
            if (this.connectorConfigBuilder == null) {
                throw new DeploymentException("Can not deploy resource adapter; No rar deployer defined: " + module.getModuleURI());
            }
            return this.connectorConfigBuilder;
        }
        if (module instanceof AppClientModule) {
            if (this.appClientConfigBuilder == null) {
                throw new DeploymentException("Can not deploy app client; No app client deployer defined: " + module.getModuleURI());
            }
            return this.appClientConfigBuilder;
        }
        throw new IllegalArgumentException("Unknown module type: " + module.getClass().getName());
    }

    private URI getDependencyURI(GerDependencyType dep) throws DeploymentException {
        URI uri;
        if (dep.isSetUri()) {
            try {
                uri = new URI(dep.getUri());
            }
            catch (URISyntaxException e) {
                throw new DeploymentException("Invalid dependency URI " + dep.getUri(), (Throwable)e);
            }
        }
        String id = dep.getGroupId() + "/jars/" + dep.getArtifactId() + '-' + dep.getVersion() + ".jar";
        try {
            uri = new URI(id);
        }
        catch (URISyntaxException e) {
            throw new DeploymentException("Unable to construct URI for groupId=" + dep.getGroupId() + ", artifactId=" + dep.getArtifactId() + ", version=" + dep.getVersion(), (Throwable)e);
        }
        return uri;
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = new GBeanInfoBuilder(EARConfigBuilder.class);
        infoFactory.addAttribute("defaultParentId", URI.class, true);
        infoFactory.addAttribute("j2eeServer", ObjectName.class, true);
        infoFactory.addAttribute("transactionContextManagerObjectName", ObjectName.class, true);
        infoFactory.addAttribute("connectionTrackerObjectName", ObjectName.class, true);
        infoFactory.addAttribute("transactionalTimerObjectName", ObjectName.class, true);
        infoFactory.addAttribute("nonTransactionalTimerObjectName", ObjectName.class, true);
        infoFactory.addReference("Repository", Repository.class);
        infoFactory.addReference("EJBConfigBuilder", ModuleBuilder.class);
        infoFactory.addReference("EJBReferenceBuilder", EJBReferenceBuilder.class);
        infoFactory.addReference("WebConfigBuilder", ModuleBuilder.class);
        infoFactory.addReference("ConnectorConfigBuilder", ModuleBuilder.class);
        infoFactory.addReference("ResourceReferenceBuilder", ResourceReferenceBuilder.class);
        infoFactory.addReference("AppClientConfigBuilder", ModuleBuilder.class);
        infoFactory.addAttribute("kernel", Kernel.class, false);
        infoFactory.addInterface(ConfigurationBuilder.class);
        infoFactory.setConstructor(new String[]{"defaultParentId", "j2eeServer", "transactionContextManagerObjectName", "connectionTrackerObjectName", "transactionalTimerObjectName", "nonTransactionalTimerObjectName", "Repository", "EJBConfigBuilder", "EJBReferenceBuilder", "WebConfigBuilder", "ConnectorConfigBuilder", "ResourceReferenceBuilder", "AppClientConfigBuilder", "kernel"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

