/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.util.Debug;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JCheckBox;
import net.n3.nanoxml.XMLElement;

class VCheckBox
extends JCheckBox
implements ItemListener {
    String myVarName = null;
    Vector dependsOnVars = new Vector();
    Vector exclusiveOfVars = new Vector();
    Vector dependents = new Vector();
    HashMap varMap = null;
    InstallData idata = null;

    private VCheckBox() {
    }

    protected VCheckBox(String label, HashMap varMap, InstallData idata, XMLElement spec) {
        super(label);
        Vector vSpec;
        this.idata = idata;
        this.myVarName = spec.getAttribute("variable");
        this.varMap = varMap;
        if (this.myVarName != null) {
            varMap.put(this.myVarName, this);
        }
        if ((vSpec = spec.getChildrenNamed("spec")).size() > 0) {
            String myInitialValue = ((XMLElement)vSpec.elementAt(0)).getAttribute("set");
            if (myInitialValue == null) {
                myInitialValue = "false";
            }
            this.setDesiredState(myInitialValue.equalsIgnoreCase("true"));
        }
        Vector depends = spec.getChildrenNamed("depends");
        for (int i = 0; i < depends.size(); ++i) {
            String varName = ((XMLElement)depends.elementAt(i)).getAttribute("variable");
            Debug.trace((Object)("VCheckBox: " + this.myVarName + " depends on: " + varName));
            this.dependsOnVars.add(varName);
        }
        Vector exclusiveOf = spec.getChildrenNamed("exclusiveOf");
        for (int i = 0; i < exclusiveOf.size(); ++i) {
            String varName = ((XMLElement)exclusiveOf.elementAt(i)).getAttribute("variable");
            Debug.trace((Object)("VCheckBox: " + this.myVarName + " exclusive of: " + varName));
            this.exclusiveOfVars.add(varName);
        }
        this.addItemListener(this);
    }

    protected String getVarName() {
        return this.myVarName;
    }

    public void setDesiredState(boolean b) {
        this.setSelected(b);
        this.idata.setVariable(this.myVarName, String.valueOf(b));
    }

    protected void setupDependents() {
        for (int i = 0; i < this.dependsOnVars.size(); ++i) {
            String depVar = (String)this.dependsOnVars.elementAt(i);
            VCheckBox dependOn = (VCheckBox)this.varMap.get(depVar);
            if (dependOn == null) {
                System.out.println("Packaging error. Depends on variable: " + depVar + " is not defined");
                continue;
            }
            dependOn.addDependent(this.myVarName);
            Debug.trace((Object)(dependOn.myVarName + ".addDependent(" + this.myVarName + ")"));
        }
    }

    protected void addDependent(String depVarName) {
        this.dependents.add(depVarName);
    }

    public void itemStateChanged(ItemEvent event) {
        if (this.isSelected()) {
            this.idata.setVariable(this.myVarName, "true");
        } else {
            this.idata.setVariable(this.myVarName, "false");
        }
        this.setValidStates(true);
    }

    public void setValidStates() {
        this.setValidStates(false);
    }

    public boolean reverseDepsSelected() {
        boolean allEnabled = true;
        for (int i = 0; i < this.dependsOnVars.size(); ++i) {
            String depOn = (String)this.dependsOnVars.elementAt(i);
            if (depOn == null) continue;
            VCheckBox vDepOn = (VCheckBox)this.varMap.get(depOn);
            if (vDepOn == null) {
                NullPointerException e = new NullPointerException("Invalid state");
                e.printStackTrace();
                throw new RuntimeException(e);
            }
            if (vDepOn.isSelected()) continue;
            allEnabled = false;
            break;
        }
        return allEnabled;
    }

    public void setValidStates(boolean fDirectlyFromEvent) {
        int i;
        this.setToVariableValue(this.idata);
        boolean isSelected = this.isSelected();
        if (!this.reverseDepsSelected()) {
            this.setDesiredState(false);
            this.setEnabled(false);
        }
        for (i = 0; i < this.dependents.size(); ++i) {
            String depVar = (String)this.dependents.elementAt(i);
            VCheckBox dep = (VCheckBox)this.varMap.get(depVar);
            if (dep == null) continue;
            if (isSelected) {
                dep.setActive(true);
                dep.setEnabled(true);
                continue;
            }
            dep.setDesiredState(false);
            dep.setActive(false);
            dep.setEnabled(false);
        }
        if (fDirectlyFromEvent) {
            for (i = 0; i < this.exclusiveOfVars.size(); ++i) {
                String xofVar = (String)this.exclusiveOfVars.elementAt(i);
                VCheckBox xof = (VCheckBox)this.varMap.get(xofVar);
                if (xof == null) continue;
                if (this.isSelected()) {
                    xof.setDesiredState(false);
                    xof.setActive(false);
                    xof.setEnabled(false);
                    continue;
                }
                xof.setActive(true);
                xof.setEnabled(true);
            }
        }
    }

    protected void setToVariableValue(InstallData idata) {
        Debug.trace((Object)(">VCheckBox.setToVariableValue( " + this.myVarName + ")"));
        String value = idata.getVariable(this.myVarName);
        boolean selected = false;
        if (value != null && value.equalsIgnoreCase("true")) {
            selected = true;
        }
        this.setSelected(selected);
        Debug.trace((Object)("-VCheckBox.setToVariableValue() new value is: " + selected));
        Debug.trace((Object)("<VCheckBox.setToVariableValue( " + this.myVarName + ")"));
    }

    public void setActive(boolean fActive) {
        Debug.trace((Object)(">VCheckBox.setActive( " + fActive + ") : " + this.myVarName));
        for (int i = 0; i < this.dependents.size(); ++i) {
            String depVar = (String)this.dependents.elementAt(i);
            VCheckBox dep = (VCheckBox)this.varMap.get(depVar);
            if (dep == null) continue;
            if (fActive) {
                dep.setActive(true);
                dep.setEnabled(true);
                continue;
            }
            dep.setActive(false);
            dep.setDesiredState(false);
            dep.setEnabled(false);
        }
        Debug.trace((Object)("<VCheckBox.setActive( " + fActive + ")"));
    }
}

