/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.Pack;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.panels.VarInfo;
import com.izforge.izpack.util.Debug;
import java.util.Vector;

public class GeronimoConfigProcessor {
    static int CONFIG_PROBLEM = 0;
    static int BASE_CONFIG = 1;
    static int JETTY_CONFIG = 2;
    static int TOMCAT_CONFIG = 3;
    static int EJB_CONFIG = 4;
    static int CORBA_CONFIG = 5;
    static int DERBY_CONFIG = 6;
    static int ACTIVEMQ_CONFIG = 7;
    static int LDAP_CONFIG = 8;
    static int SMTP_CONFIG = 9;
    static int CONFIG_CKPT = 10;
    static String[] panelNames = new String[]{"Configuration Problem", "Base Configuration", "Jetty Web Configuration", "Tomcat Web Configuration", "EJB Configuration", "CORBA Configuration", "Derby Configuration", "ActiveMQ Configuration", "Directory (LDAP) Configuration", "SMTP Transport Configuration", "Configuration Checkpoint"};
    static int SERVER_PACK = 0;
    static int J2EE_PACK = 1;
    static int CORBA_PACK = 2;
    static int JMS_PACK = 3;
    static int JETTY_PACK = 4;
    static int JETTY_WELCOME_PACK = 5;
    static int JETTY_MGT_PACK = 6;
    static int JETTY_UDDI_PACK = 7;
    static int JETTY_SAMPLE_PACK = 8;
    static int JETTY_DAYTRADER = 9;
    static int TOMCAT_PACK = 10;
    static int TOMCAT_WELCOME_PACK = 11;
    static int TOMCAT_MGT_PACK = 12;
    static int TOMCAT_UDDI_PACK = 13;
    static int TOMCAT_SAMPLE_PACK = 14;
    static int TOMCAT_DAYTRADER = 15;
    static int LDAP_PACK = 16;
    static int SMTP_PACK = 17;
    static int SAMPLE_DB_POOL_PACK = 18;
    static int JMX_WEB_DEBUG_PACK = 19;
    static String[] packNames = new String[]{"Server", "J2EE Features", "CORBA Features", "JMS Features", "Jetty Web Container", "Jetty Welcome Application", "Jetty Web Management Console", "Jetty UDDI Server", "Jetty Sample Applications", "Daytrader for Jetty", "Tomcat Web Container", "Tomcat Welcome Application", "Tomcat Web Management Console", "Tomcat UDDI Server", "Tomcat Sample Applications", "Daytrader for Tomcat", "LDAP Server", "SMTP Transport", "Sample Database Pool", "JMX Debug Web Application"};
    protected static VarInfo[] vars = new VarInfo[]{new VarInfo("SecurityDefaultUser", 's', BASE_CONFIG, SERVER_PACK, "", "system"), new VarInfo("SecurityDefaultPassword", 's', BASE_CONFIG, SERVER_PACK, "", "manager"), new VarInfo("PlanRemoteLoginPort", 'p', BASE_CONFIG, J2EE_PACK, "Remote Login Port", "4242"), new VarInfo("PlanServerHostName", 'h', JETTY_CONFIG, JETTY_PACK, "", "0.0.0.0"), new VarInfo("PlanHTTPPort", 'p', JETTY_CONFIG, JETTY_PACK, "Jetty HTTP Port", "8080"), new VarInfo("PlanHTTPSPort", 'p', JETTY_CONFIG, JETTY_PACK, "Jetty HTTPS Port", "8443"), new VarInfo("PlanAJPPort", 'p', JETTY_CONFIG, JETTY_PACK, "Jetty AJP Port", "8009"), new VarInfo("PlanServerHostName", 'h', TOMCAT_CONFIG, TOMCAT_PACK, "", "0.0.0.0"), new VarInfo("PlanHTTPPort2", 'p', TOMCAT_CONFIG, TOMCAT_PACK, "Tomcat HTTP Port", "8080"), new VarInfo("PlanHTTPSPort2", 'p', TOMCAT_CONFIG, TOMCAT_PACK, "Tomcat HTTPS Port", "8443"), new VarInfo("PlanAJPPort2", 'p', TOMCAT_CONFIG, TOMCAT_PACK, "Tomcat AJP Port", "8009"), new VarInfo("PlanNamingPort", 'p', EJB_CONFIG, SERVER_PACK, "Naming Port", "1009"), new VarInfo("PlanOpenEJBPort", 'p', EJB_CONFIG, J2EE_PACK, "EJB Port", "4201"), new VarInfo("PlanClientAddresses", 's', EJB_CONFIG, SERVER_PACK, "", "0.0.0.0"), new VarInfo("PlanIIOPPort", 'p', CORBA_CONFIG, CORBA_PACK, "IIOP Port", "9000"), new VarInfo("PlanORBSSLHost", 'h', CORBA_CONFIG, CORBA_PACK, "", "localhost"), new VarInfo("PlanORBSSLPort", 'p', CORBA_CONFIG, CORBA_PACK, "ORB SSL Port", "2001"), new VarInfo("PlanCOSNamingHost", 'h', CORBA_CONFIG, CORBA_PACK, "", "localhost"), new VarInfo("PlanCOSNamingPort", 'p', CORBA_CONFIG, CORBA_PACK, "CosNaming Port", "1050"), new VarInfo("PlanDerbyPort", 'p', DERBY_CONFIG, SAMPLE_DB_POOL_PACK, "Derby Port", "1527"), new VarInfo("PlanActiveMQPort", 'p', ACTIVEMQ_CONFIG, JMS_PACK, "JMS Port", "61616"), new VarInfo("PlanLdapPort", 'p', LDAP_CONFIG, LDAP_PACK, "LDAP Port", "1389"), new VarInfo("PlanSMTPHost", 'h', SMTP_CONFIG, SMTP_PACK, "SMTP Host", "localhost"), new VarInfo("PlanSMTPPort", 'p', SMTP_CONFIG, SMTP_PACK, "SMTP Port", "25")};
    protected static boolean fInitialConfigDone = false;

    protected String getPanelName(int panelId) {
        return panelNames[panelId];
    }

    protected String getPackName(int packId) {
        return packNames[packId];
    }

    protected void debug(String debugString) {
        Debug.trace((Object)debugString);
    }

    protected boolean isAdvancedMode(AutomatedInstallData idata) {
        boolean fRet = false;
        String val = idata.getVariable("advanced.mode");
        if (val.equalsIgnoreCase("true")) {
            fRet = true;
        }
        return fRet;
    }

    protected boolean isTomcatSelected(AutomatedInstallData idata) {
        return this.isPackSelected(idata, packNames[TOMCAT_PACK]);
    }

    protected boolean isPackSelected(AutomatedInstallData idata, String packName) {
        boolean fRet = false;
        int iSize = idata.selectedPacks.size();
        if (iSize > 0) {
            for (int i = 0; i < iSize; ++i) {
                Pack p = (Pack)idata.selectedPacks.get(i);
                if (!p.name.equals(packName)) continue;
                fRet = true;
            }
        }
        return fRet;
    }

    protected boolean isJettySelected(AutomatedInstallData idata) {
        return this.isPackSelected(idata, packNames[JETTY_PACK]);
    }

    protected void panelNavDebug(AutomatedInstallData idata) {
        this.debug("--> num panels: " + idata.panels.size() + "  cur panel: " + idata.curPanelNumber);
    }

    protected boolean isPackSelectionProblem(AutomatedInstallData idata) {
        boolean fRet = false;
        if (this.isAdvancedMode(idata)) {
            fRet = false;
        } else if (this.isJettySelected(idata) && this.isTomcatSelected(idata)) {
            fRet = true;
        }
        return fRet;
    }

    protected boolean shouldSkipPanel(AutomatedInstallData idata, String panelName) {
        boolean fRet = false;
        if (panelName.equalsIgnoreCase(this.getPanelName(CONFIG_PROBLEM))) {
            fRet = !this.isPackSelectionProblem(idata);
        }
        this.debug("shouldSkipPanel( " + panelName + " ) is: " + fRet);
        return fRet;
    }

    protected void initEnableVarsToPackSelections(AutomatedInstallData idata) {
        boolean fSel = false;
        for (int i = 0; i < idata.allPacks.size(); ++i) {
            Pack pack = (Pack)idata.allPacks.get(i);
            fSel = false;
            if (this.isPackSelected(idata, pack.name)) {
                fSel = true;
            }
            this.setEnableVar(idata, pack.name, fSel);
        }
    }

    protected void setInitialConfig(AutomatedInstallData idata) {
        if (fInitialConfigDone) {
            return;
        }
        fInitialConfigDone = true;
        this.debug(">setInitialConfig()  ");
        this.initEnableVarsToPackSelections(idata);
        if (this.isAdvancedMode(idata)) {
            if (this.isTomcatSelected(idata)) {
                int i;
                int[] packs = new int[]{TOMCAT_PACK, TOMCAT_WELCOME_PACK, TOMCAT_MGT_PACK, TOMCAT_UDDI_PACK, TOMCAT_SAMPLE_PACK, TOMCAT_DAYTRADER};
                this.debug("-setInitialConfig() : tomcat is selected for install. ");
                boolean fSel = false;
                String packName = null;
                if (!this.isJettySelected(idata)) {
                    this.debug("-setInitialConfig() : jetty is not selected for install. ");
                    for (i = 0; i < packs.length; ++i) {
                        packName = this.getPackName(packs[i]);
                        fSel = this.isPackSelected(idata, packName);
                        this.setEnableVar(idata, packName, fSel);
                    }
                } else {
                    this.debug("-setInitialConfig() : jetty is selected for install. ");
                    for (i = 0; i < packs.length; ++i) {
                        packName = this.getPackName(packs[i]);
                        this.setEnableVar(idata, packName, false);
                    }
                }
            } else {
                this.debug("-setInitialConfig() : tomcat is not selected for install. ");
            }
        }
        for (int i = 0; i < vars.length; ++i) {
            vars[i].setDefault(idata);
        }
        this.debug("<setInitialConfig()  ");
    }

    protected void setEnableVar(AutomatedInstallData idata, String packName, boolean fSetting) {
        this.debug(">setEnableVar()");
        String varName = new String(packName);
        varName = varName.replace(' ', '.');
        varName = varName + ".enable";
        String sel = "false";
        if (fSetting) {
            sel = "true";
        }
        Debug.trace((Object)(varName + " is " + sel));
        idata.setVariable(varName, sel);
        this.debug("<setEnableVar()");
    }

    protected void resetConfigNonSelected(AutomatedInstallData idata) {
        this.debug(">resetConfigNonSelected()  ");
        String packName = null;
        for (int i = 0; i < idata.allPacks.size(); ++i) {
            Pack pack = (Pack)idata.allPacks.get(i);
            packName = pack.name;
            if (this.isPackSelected(idata, packName)) continue;
            String sel = "false";
            String varName = new String(packName);
            varName = varName.replace(' ', '.');
            varName = varName + ".enable";
            Debug.trace((Object)(varName + " is " + sel));
            idata.setVariable(varName, sel);
        }
        this.debug("<resetConfigNonSelected()  ");
    }

    protected boolean panelEntryTasks(AutomatedInstallData idata, String panelName) {
        boolean fRet = true;
        if (panelName.equals(this.getPanelName(BASE_CONFIG))) {
            this.setInitialConfig(idata);
            if (!this.isAdvancedMode(idata)) {
                this.initEnableVarsToPackSelections(idata);
            } else {
                this.resetConfigNonSelected(idata);
            }
        }
        return fRet;
    }

    protected boolean checkInput(String panelName, AutomatedInstallData idata) {
        boolean fRet = true;
        if (panelName.equals(this.getPanelName(BASE_CONFIG))) {
            fRet = true;
        } else if (panelName.equals(this.getPanelName(JETTY_CONFIG))) {
            fRet = true;
        } else if (panelName.equals(this.getPanelName(TOMCAT_CONFIG))) {
            fRet = true;
        } else if (panelName.equals(this.getPanelName(EJB_CONFIG))) {
            fRet = true;
        } else if (panelName.equals(this.getPanelName(CORBA_CONFIG))) {
            fRet = true;
        } else if (panelName.equals(this.getPanelName(DERBY_CONFIG))) {
            fRet = true;
        } else if (panelName.equals(this.getPanelName(ACTIVEMQ_CONFIG))) {
            fRet = true;
        } else if (panelName.equals(this.getPanelName(LDAP_CONFIG))) {
            fRet = true;
        } else if (panelName.equals(this.getPanelName(SMTP_CONFIG))) {
            fRet = true;
        } else if (panelName.equals(this.getPanelName(CONFIG_CKPT))) {
            fRet = true;
            this.setAutoInstallConfig(idata);
            this.processConfig(idata);
        }
        return fRet;
    }

    protected boolean processConfig(AutomatedInstallData idata) {
        boolean fRet = true;
        String samples = "false";
        String varName = "Geronimo.Sample.Applications";
        if (this.isPackSelected(idata, packNames[JETTY_SAMPLE_PACK])) {
            samples = "true";
        }
        if (this.isPackSelected(idata, packNames[TOMCAT_SAMPLE_PACK])) {
            samples = "true";
        }
        idata.setVariable(varName, samples);
        String serverName = null;
        String webBuilderNamespace = null;
        varName = null;
        if (this.isTomcatSelected(idata)) {
            serverName = idata.getVariable("TOMCAT_WEB_SERVER_NAME");
            varName = "PlanWebServerName";
            idata.setVariable(varName, serverName);
            webBuilderNamespace = idata.getVariable("TOMCAT_WEBBUILDER_NAMESPACE");
            varName = "PlanWebBuilderDefaultNamespace";
            idata.setVariable(varName, webBuilderNamespace);
        } else if (this.isJettySelected(idata)) {
            serverName = idata.getVariable("JETTY_WEB_SERVER_NAME");
            varName = "PlanWebServerName";
            idata.setVariable(varName, serverName);
            webBuilderNamespace = idata.getVariable("JETTY_WEBBUILDER_NAMESPACE");
            varName = "PlanWebBuilderDefaultNamespace";
            idata.setVariable(varName, webBuilderNamespace);
        } else {
            serverName = idata.getVariable("NO_WEB_SERVER_NAME");
            varName = "PlanWebServerName";
            idata.setVariable(varName, serverName);
            webBuilderNamespace = idata.getVariable("NO_WEBBUILDER_NAMESPACE");
            varName = "PlanWebBuilderDefaultNamespace";
            idata.setVariable(varName, webBuilderNamespace);
        }
        return fRet;
    }

    protected void setAutoInstallConfig(AutomatedInstallData idata) {
        this.debug(">setAutoInstallConfig()  ");
        String cpes = System.getProperty("path.separator");
        idata.setVariable("CPES", cpes);
        String trace = System.getProperty("TRACE");
        if (trace == null) {
            trace = "false";
        }
        idata.setVariable("TRACE", trace);
        String serverPack = this.getPackName(SERVER_PACK);
        serverPack = serverPack.replace(' ', '.');
        String serverEnableVar = serverPack + ".enable";
        idata.setVariable(serverEnableVar, "true");
        String packName = null;
        for (int i = 0; i < idata.allPacks.size(); ++i) {
            String packEnable;
            String eSel;
            Pack pack = (Pack)idata.allPacks.get(i);
            String sel = "false";
            packName = pack.name;
            String packVar = new String(packName);
            sel = idata.getVariable(packVar = packVar.replace(' ', '.'));
            if (sel == null) {
                sel = "false";
                idata.setVariable(packVar, sel);
            }
            if (this.isPackSelected(idata, packName)) {
                sel = "true";
                idata.setVariable(packVar, sel);
            }
            if ((eSel = idata.getVariable(packEnable = packVar + ".enable")) == null) {
                eSel = "false";
                idata.setVariable(packEnable, eSel);
            }
            this.debug("-- " + packVar + " is: " + sel + "   " + packEnable + " is: " + eSel);
        }
        this.debug("<setAutoInstallConfig()  ");
    }

    protected void processAutomatedInput(AutomatedInstallData idata, String panelName) {
        if (this.isCheckpointPanel(panelName)) {
            this.setAutoInstallConfig(idata);
            this.processConfig(idata);
        }
    }

    protected boolean isCheckpointPanel(String panelName) {
        boolean fRet = panelName.equals(this.getPanelName(CONFIG_CKPT));
        this.debug("isCheckpointPanel( " + panelName + " ) is: " + fRet);
        return fRet;
    }

    protected boolean haveConfigErrors(AutomatedInstallData idata, String[] msgs) {
        int numVars2Ck = 0;
        for (int i = 0; i < vars.length; ++i) {
            if (GeronimoConfigProcessor.vars[i].verTyp != 'p' || !this.isPackSelected(idata, packNames[GeronimoConfigProcessor.vars[i].packId])) continue;
            ++numVars2Ck;
        }
        int[] vars2Ck = new int[numVars2Ck];
        int idx = 0;
        for (int i = 0; i < vars.length; ++i) {
            if (GeronimoConfigProcessor.vars[i].verTyp != 'p' || !this.isPackSelected(idata, packNames[GeronimoConfigProcessor.vars[i].packId])) continue;
            vars2Ck[idx] = i;
            ++idx;
        }
        Vector<Object[]> conflicts = new Vector<Object[]>();
        int[] vars2Ck2 = new int[numVars2Ck];
        System.arraycopy(vars2Ck, 0, vars2Ck2, 0, numVars2Ck);
        for (int i = 0; i < vars2Ck.length; ++i) {
            for (int j = 0; j < vars2Ck2.length; ++j) {
                int p1Idx = vars2Ck[i];
                int p2Idx = vars2Ck2[j];
                if (p1Idx == p2Idx) continue;
                String p1 = idata.getVariable(GeronimoConfigProcessor.vars[p1Idx].varName);
                String p2 = idata.getVariable(GeronimoConfigProcessor.vars[p2Idx].varName);
                if (p1 == null || p2 == null || !p1.equals(p2)) continue;
                conflicts.add(new Object[]{new Integer(p1Idx), new Integer(p2Idx)});
            }
        }
        boolean fRet = false;
        int numConflicts = conflicts.size();
        Object[] conflictDups = new Object[numConflicts];
        if (numConflicts > 0) {
            int i;
            fRet = true;
            int msgIdx = 0;
            msgs[msgIdx] = "Warning. Geronimo configuration problems.";
            msgs[++msgIdx] = "       The list of port conflicts below should be resolved before continuing the installation.";
            msgs[++msgIdx] = "__________________________________";
            int dupsIdx = 0;
            boolean fDup = false;
            for (i = 0; i < numConflicts && i < 7; ++i) {
                Object[] ports = (Object[])conflicts.elementAt(i);
                int p1Idx = (Integer)ports[0];
                int p2Idx = (Integer)ports[1];
                fDup = false;
                for (int dupCk = 0; dupCk < conflictDups.length; ++dupCk) {
                    Object[] ports2 = (Object[])conflictDups[dupCk];
                    if (ports2 == null) continue;
                    int v1 = (Integer)ports2[0];
                    int v2 = (Integer)ports2[1];
                    if ((v1 != p1Idx || v2 != p2Idx) && (v1 != p2Idx || v2 != p1Idx)) continue;
                    fDup = true;
                }
                conflictDups[dupsIdx] = ports;
                ++dupsIdx;
                if (fDup) continue;
                msgs[++msgIdx] = "    The \"" + GeronimoConfigProcessor.vars[p1Idx].varDesc + "\" conflicts with the \"" + GeronimoConfigProcessor.vars[p2Idx].varDesc + "\"";
            }
            for (i = ++msgIdx; i < 10; ++i) {
                msgs[i] = " ";
            }
        }
        return fRet;
    }

    protected void panelDebug(AutomatedInstallData idata, String panelName) {
        Debug.trace((Object)("------ Begin panel entry debug info for: " + panelName + "-----"));
        if (panelName.equals(this.getPanelName(BASE_CONFIG))) {
            for (int i = 0; i < idata.selectedPacks.size(); ++i) {
                Pack pack = (Pack)idata.selectedPacks.get(i);
                Debug.trace((Object)(pack.name + " is selected."));
            }
            Debug.trace((Object)"-----------");
            String packName = null;
            for (int i = 0; i < idata.allPacks.size(); ++i) {
                Pack pack = (Pack)idata.allPacks.get(i);
                String sel = "not selected";
                packName = pack.name;
                if (this.isPackSelected(idata, packName)) {
                    sel = "selected";
                }
                Debug.trace((Object)(packName + " is " + sel));
            }
        }
        Debug.trace((Object)("------ End panel entry debug info for: " + panelName + "-----"));
    }
}

