/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.installer.processing;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

public class FixTextLines {
    protected static String[] fileTypes = new String[]{".dtd", ".ent", ".htm", ".html", ".java", ".js", ".jsp", ".properties", ".sql", ".txt", ".wsdl", ".xml", ".xsd", ".xsl", "STATUS"};
    protected static String installPath = null;
    protected static String tempSubDir = "var/temp";
    protected static String tempPath = null;

    public static void main(String[] argv) {
        String outStr = null;
        if (argv.length < 1) {
            outStr = "FixTextLines requires the path of the Geronimo installation.";
            System.out.println(outStr);
            throw new RuntimeException(outStr);
        }
        installPath = argv[0];
        tempPath = installPath + "/" + tempSubDir;
        File tempPathFile = new File(tempPath);
        if (!tempPathFile.exists()) {
            outStr = "FixTextLines: temporary directory does not exist.  Check installPath.";
            System.out.println(outStr);
            throw new RuntimeException(outStr);
        }
        if (!tempPathFile.isDirectory()) {
            outStr = "FixTextLines: temporary directory exists, but is not a directory.  Check installPath.";
            System.out.println(outStr);
            throw new RuntimeException(outStr);
        }
        FixTextLines ftl = new FixTextLines();
        ftl.fixFiles(new File(installPath));
        System.out.println("FixTextLines processing complete.");
    }

    public void fixFiles(File dir) {
        File[] files = null;
        try {
            files = dir.listFiles();
        }
        catch (Exception e) {
            System.err.println("FixTextLines: error obtaining list of files to process -" + dir.getPath());
        }
        for (int i = 0; i < files.length; ++i) {
            String path = null;
            try {
                path = files[i].getCanonicalPath();
            }
            catch (Exception e1) {
                System.err.println("FixTextLines: error getting file path name.");
            }
            if (files[i].isDirectory()) {
                if (path.equalsIgnoreCase(tempPath)) continue;
                this.fixFiles(files[i]);
                continue;
            }
            if (!this.isToBeFixed(files[i])) continue;
            this.fixCrLf(files[i]);
        }
    }

    public boolean isToBeFixed(File file) {
        boolean fRet = false;
        for (int i = 0; i < fileTypes.length; ++i) {
            String name = file.getName();
            if (fileTypes[i].startsWith(".")) {
                int idx = name.lastIndexOf(".");
                if (idx <= -1 || !fileTypes[i].equals(name.substring(idx))) continue;
                fRet = true;
                break;
            }
            if (!name.equals(fileTypes[i])) continue;
            fRet = true;
            break;
        }
        return fRet;
    }

    public void fixCrLf(File file) {
        boolean fErr = false;
        BufferedReader br = null;
        BufferedWriter bw = null;
        try {
            br = new BufferedReader(new FileReader(file));
        }
        catch (IOException ioe) {
            System.err.println("FixTextLines: " + file.getPath() + " cannot be opened.");
            fErr = true;
        }
        String tmpname = tempPath + "/" + file.getName();
        File tmpFile = new File(tmpname);
        if (!fErr) {
            try {
                bw = new BufferedWriter(new FileWriter(tmpFile));
            }
            catch (IOException ioe) {
                System.err.println("FixTextLines: " + tmpname + " cannot be created.");
                fErr = true;
            }
        }
        if (!fErr) {
            try {
                String inStr = br.readLine();
                while (inStr != null) {
                    bw.write(inStr);
                    bw.newLine();
                    inStr = br.readLine();
                }
                bw.newLine();
                bw.close();
                br.close();
            }
            catch (IOException ioe) {
                fErr = true;
                System.err.println("FixTextLines: Error adjusting CRLF format for: " + file.getPath() + " during copy.");
            }
        }
        if (!fErr) {
            try {
                boolean fSuccess = false;
                String originalName = file.getCanonicalPath();
                fSuccess = file.renameTo(new File(file.getCanonicalPath() + ".original"));
                if (fSuccess) {
                    fSuccess = tmpFile.renameTo(new File(originalName));
                    if (fSuccess) {
                        File orig = new File(originalName + ".original");
                        orig.delete();
                    } else {
                        System.err.println("FixTextLines: " + originalName + " final rename failed.");
                        fErr = true;
                    }
                } else {
                    System.err.println("FixTextLines: " + originalName + " initial rename failed.");
                    fErr = true;
                }
            }
            catch (Exception e) {
                System.err.println("FixTextLines: Error moving files. " + file.getPath());
                fErr = true;
            }
        }
    }
}

