/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.installer.processing;

import java.io.File;
import java.lang.reflect.Method;
import org.apache.geronimo.installer.processing.ConfigInstaller;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

class ConfigWorker {
    protected Class installerCls = null;
    protected Object installerObj = null;
    protected Method execute = null;
    protected Method setTargetRoot = null;
    protected Method setTargetConfigStore = null;
    protected Method setTargetRepository = null;
    protected Method setSourceRepository = null;
    protected Method setArtifact = null;
    protected DOMParser parser = null;
    protected boolean fTrace = false;
    protected int numElements = 0;
    protected boolean fSelected = false;
    protected String artifact = null;
    protected String executable = null;

    protected void trace(String output) {
        if (this.fTrace) {
            System.out.println(output);
        }
    }

    protected void doit(ClassLoader cl, Boolean fTrace) {
        this.fTrace = fTrace;
        this.trace(">ConfigWorker.doit()");
        if (this.init(cl) && this.parse()) {
            this.processXML();
        }
        this.trace("<ConfigWorker.doit()");
    }

    protected ConfigWorker() {
    }

    protected void initLocalConfigInstaller(ClassLoader cl) {
        this.trace(">ConfigWorker.initLocalConfigInstaller()");
        try {
            this.installerCls = cl.loadClass("org.apache.geronimo.plugin.assembly.LocalConfigInstaller");
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to load LocalConfigInstaller class");
        }
        try {
            this.execute = this.installerCls.getDeclaredMethod("execute", null);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to get method object \"execute\" from LocalConfigInstaller class");
        }
        try {
            this.setTargetRoot = this.installerCls.getSuperclass().getDeclaredMethod("setTargetRoot", File.class);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to get method object \"setTargetRoot\" from LocalConfigInstaller class");
        }
        try {
            this.setTargetConfigStore = this.installerCls.getSuperclass().getDeclaredMethod("setTargetConfigStore", String.class);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to get method object \"setTargetConfigStore\" from LocalConfigInstaller class");
        }
        try {
            this.setTargetRepository = this.installerCls.getSuperclass().getDeclaredMethod("setTargetRepository", String.class);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to get method object \"setTargetRepository\" from LocalConfigInstaller class");
        }
        try {
            this.setSourceRepository = this.installerCls.getSuperclass().getDeclaredMethod("setSourceRepository", File.class);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to get method object \"setSourceRepository\" from LocalConfigInstaller class");
        }
        try {
            this.setArtifact = this.installerCls.getSuperclass().getDeclaredMethod("setArtifact", String.class);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to get method object \"setArtifact\" from LocalConfigInstaller class");
        }
        try {
            this.installerObj = this.installerCls.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create instanceof LocalConfigInstaller");
        }
        this.trace("<ConfigWorker.initLocalConfigInstaller()");
    }

    protected boolean init(ClassLoader cl) {
        boolean fRet = true;
        this.trace(">ConfigWorker.init()");
        this.initLocalConfigInstaller(cl);
        try {
            this.parser = new DOMParser();
        }
        catch (Exception e) {
            System.err.println("error: Unable to instantiate XML parser");
            fRet = false;
        }
        this.trace("<ConfigWorker.init()");
        return fRet;
    }

    protected boolean parse() {
        boolean fRet = true;
        this.trace(">ConfigWorker.parse()");
        try {
            this.parser.parse(ConfigInstaller.installRoot + '/' + ConfigInstaller.xmlName);
        }
        catch (Exception e) {
            System.err.println("Exception while parsing: " + ConfigInstaller.installRoot + "/" + ConfigInstaller.xmlName);
            fRet = false;
        }
        this.trace("<ConfigWorker.parse()");
        return fRet;
    }

    protected void processXML() {
        this.trace(">ConfigWorker.processXML()");
        Document doc = this.parser.getDocument();
        Element node = doc.getDocumentElement();
        this.processConfigurations(node);
        this.trace("<ConfigWorker.processXML()");
    }

    public void processConfigurations(Node node) {
        this.trace(">ConfigWorker.processConfigurations()");
        if (node == null) {
            return;
        }
        String nodeName = node.getNodeName();
        if (!nodeName.equalsIgnoreCase("configurations")) {
            throw new RuntimeException("ConfigInstaller: Malformed XML.  \"configurations\" element expected.");
        }
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            short nodeType = child.getNodeType();
            if (nodeType != 5 && nodeType != 6 && nodeType != 1) continue;
            this.processConfiguration(child);
        }
        this.trace("<ConfigWorker.processConfigurations()");
    }

    public void processConfiguration(Node node) {
        this.trace(">ConfigWorker.processConfiguration()");
        if (node == null) {
            return;
        }
        this.artifact = null;
        this.executable = null;
        this.fSelected = false;
        String nodeName = node.getNodeName();
        if (!nodeName.equalsIgnoreCase("configuration")) {
            throw new RuntimeException("ConfigInstaller: Malformed XML.  \"configuration\" element expected. (" + nodeName + ")");
        }
        Node child = node.getFirstChild();
        while (child != null) {
            Text text;
            short nodeType = child.getNodeType();
            if (nodeType != 5 && nodeType != 6 && nodeType != 1) {
                child = child.getNextSibling();
                continue;
            }
            nodeName = child.getNodeName();
            if (nodeName.equalsIgnoreCase("selected")) {
                text = (Text)child.getFirstChild();
                this.fSelected = false;
                if (text.getNodeValue().trim().equalsIgnoreCase("true")) {
                    this.fSelected = true;
                }
            } else if (nodeName.equalsIgnoreCase("executable")) {
                text = (Text)child.getFirstChild();
                this.executable = text.getNodeValue();
                this.executable = this.executable.trim();
            } else if (nodeName.equalsIgnoreCase("artifact")) {
                text = (Text)child.getFirstChild();
                this.artifact = text.getNodeValue();
                this.artifact = this.artifact.trim();
            } else {
                throw new RuntimeException("ConfigInstaller: Malformed XML. Element of type \"selected\" or \"executable\" or \"artifact\" expected. (" + nodeName + ")");
            }
            child = child.getNextSibling();
        }
        if (this.fSelected) {
            this.doInstall();
        }
        this.trace("<ConfigWorker.processConfiguration()");
    }

    protected void doInstall() {
        this.trace(">ConfigWorker.doInstall()");
        this.doMethod(this.setTargetConfigStore, new Object[]{"config-store"});
        this.doMethod(this.setTargetRepository, new Object[]{"repository"});
        this.doMethod(this.setArtifact, new Object[]{this.artifact});
        this.doMethod(this.setTargetRoot, new Object[]{new File(ConfigInstaller.installRoot)});
        this.doMethod(this.setSourceRepository, new Object[]{new File(ConfigInstaller.installRoot + "/repository")});
        this.doMethod(this.execute, new Object[0]);
        this.trace("<ConfigWorker.doInstall()");
    }

    protected void doMethod(Method m, Object[] parms) {
        this.trace(">ConfigWorker.doMethod()");
        try {
            m.invoke(this.installerObj, parms);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            throw new RuntimeException("Exception while executing: LocalConfigInstaller." + m.getName());
        }
        this.trace("<ConfigWorker.doMethod()");
    }
}

