/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.installer.processing;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Vector;
import org.apache.geronimo.installer.processing.ConfigThread;

public class ConfigInstaller {
    protected static String installRoot = null;
    protected static String xmlName = null;
    protected static boolean fTrace = false;
    protected static URLClassLoader cl = null;

    protected static void initClassLoader() {
        Vector vjars = new Vector();
        try {
            ConfigInstaller.getJars(new File(installRoot), vjars);
        }
        catch (Exception e) {
            throw new RuntimeException("unable to build list of jars for classloader");
        }
        Object[] ojars = vjars.toArray();
        URL[] jars = new URL[ojars.length];
        System.arraycopy(ojars, 0, jars, 0, ojars.length);
        cl = new URLClassLoader(jars, Thread.currentThread().getContextClassLoader());
    }

    protected static void getJars(File baseDir, Vector jars) throws Exception {
        File[] files = baseDir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                ConfigInstaller.getJars(files[i], jars);
                continue;
            }
            String name = files[i].getCanonicalPath();
            String nameUp = name.toUpperCase();
            if (!nameUp.endsWith(".JAR")) continue;
            jars.add(files[i].toURL());
        }
    }

    public static void main(String[] args) {
        if (args.length >= 1) {
            installRoot = args[0];
        }
        if (args.length >= 2) {
            xmlName = args[1];
        }
        if (args.length >= 3) {
            String[] parts = args[2].split("=");
            String varName = parts[0];
            String value = parts[1];
            System.out.println("Found var: " + varName + " value = " + value);
            if (varName.equalsIgnoreCase("trace")) {
                fTrace = false;
                if (value.equalsIgnoreCase("true")) {
                    fTrace = true;
                }
            }
        }
        if (installRoot == null || xmlName == null) {
            throw new RuntimeException("ConfigInstaller: installRoot and xmlname required");
        }
        ConfigInstaller.initClassLoader();
        ConfigThread ct = new ConfigThread();
        ct.setContextClassLoader(cl);
        ct.start();
        ConfigInstaller.trace("Joining ConfigThread...");
        try {
            ct.join();
        }
        catch (Exception exception) {
            // empty catch block
        }
        ConfigInstaller.trace("ConfigThread done.");
        System.out.println("Configuration complete.");
    }

    protected static void trace(String output) {
        if (fTrace) {
            System.out.println(output);
        }
    }
}

