/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.ConfigurationBuilder;
import org.apache.geronimo.deployment.util.DeploymentUtil;
import org.apache.geronimo.gbean.AbstractName;
import org.apache.geronimo.gbean.AbstractNameQuery;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.config.Configuration;
import org.apache.geronimo.kernel.config.ConfigurationData;
import org.apache.geronimo.kernel.config.ConfigurationManager;
import org.apache.geronimo.kernel.config.ConfigurationStore;
import org.apache.geronimo.kernel.config.ConfigurationUtil;
import org.apache.geronimo.kernel.config.DeploymentWatcher;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.kernel.repository.ArtifactResolver;

public class Deployer {
    private static final Log log = LogFactory.getLog((Class)Deployer.class);
    private final int REAPER_INTERVAL = 60000;
    private final Properties pendingDeletionIndex = new Properties();
    private DeployerReaper reaper;
    private final Collection builders;
    private final Collection stores;
    private final Collection watchers;
    private final ArtifactResolver artifactResolver;
    private final Kernel kernel;
    public static final GBeanInfo GBEAN_INFO;
    private static final String DEPLOYER = "Deployer";

    public Deployer(Collection builders, Collection stores, Collection watchers, Kernel kernel) {
        this(builders, stores, watchers, Deployer.getArtifactResolver(kernel), kernel);
    }

    private static ArtifactResolver getArtifactResolver(Kernel kernel) {
        ConfigurationManager configurationManager = ConfigurationUtil.getConfigurationManager((Kernel)kernel);
        return configurationManager.getArtifactResolver();
    }

    public Deployer(Collection builders, Collection stores, Collection watchers, ArtifactResolver artifactResolver, Kernel kernel) {
        this.builders = builders;
        this.stores = stores;
        this.watchers = watchers;
        this.artifactResolver = artifactResolver;
        this.kernel = kernel;
        this.reaper = new DeployerReaper(60000);
        Thread t = new Thread((Runnable)this.reaper, "Geronimo Config Store Reaper");
        t.setDaemon(true);
        t.start();
    }

    public List deploy(boolean inPlace, File moduleFile, File planFile) throws DeploymentException {
        return this.deploy(inPlace, moduleFile, planFile, null);
    }

    public List deploy(boolean inPlace, File moduleFile, File planFile, String targetConfigStore) throws DeploymentException {
        File originalModuleFile = moduleFile;
        File tmpDir = null;
        if (moduleFile != null && !moduleFile.isDirectory()) {
            try {
                tmpDir = File.createTempFile("geronimo-deployer", ".tmpdir");
                tmpDir.delete();
                tmpDir.mkdir();
                File tmpFile = new File(tmpDir, moduleFile.getName());
                DeploymentUtil.copyFile(moduleFile, tmpFile);
                moduleFile = tmpFile;
            }
            catch (IOException e) {
                throw new DeploymentException((Throwable)e);
            }
        }
        try {
            List e = this.deploy(inPlace, planFile, moduleFile, null, true, null, null, null, null, null, null, null, targetConfigStore);
            Object var9_10 = null;
        }
        catch (DeploymentException e) {
            try {
                log.debug((Object)("Deployment failed: plan=" + planFile + ", module=" + originalModuleFile), (Throwable)e);
                throw e.cleanse();
            }
            catch (Throwable throwable) {
                block8: {
                    Object var9_11 = null;
                    if (tmpDir == null || DeploymentUtil.recursiveDelete(tmpDir)) break block8;
                    this.pendingDeletionIndex.setProperty(tmpDir.getName(), "delete");
                }
                throw throwable;
            }
        }
        if (tmpDir != null && !DeploymentUtil.recursiveDelete(tmpDir)) {
            this.pendingDeletionIndex.setProperty(tmpDir.getName(), "delete");
        }
        return e;
    }

    public String getRemoteDeployUploadURL() {
        Set set = this.kernel.listGBeans(new AbstractNameQuery("org.apache.geronimo.deployment.remote.RemoteDeployToken"));
        if (set.size() == 0) {
            return null;
        }
        AbstractName token = (AbstractName)set.iterator().next();
        set = this.kernel.getDependencyManager().getParents(token);
        ObjectName config = null;
        Iterator it = set.iterator();
        while (it.hasNext()) {
            AbstractName name = (AbstractName)it.next();
            if (!Configuration.isConfigurationObjectName((ObjectName)name.getObjectName())) continue;
            config = name.getObjectName();
            break;
        }
        if (config == null) {
            log.warn((Object)"Unable to find remote deployment configuration; is the remote deploy web application running?");
            return null;
        }
        Hashtable<String, String> hash = new Hashtable<String, String>();
        hash.put("J2EEApplication", token.getObjectName().getKeyProperty("J2EEApplication"));
        hash.put("j2eeType", "WebModule");
        try {
            hash.put("name", Configuration.getConfigurationID((ObjectName)config).toString());
            Set names = this.kernel.listGBeans(new AbstractNameQuery(null, hash));
            if (names.size() != 1) {
                log.error((Object)"Unable to look up remote deploy upload URL");
                return null;
            }
            AbstractName module = (AbstractName)names.iterator().next();
            return this.kernel.getAttribute(module, "URLFor") + "/upload";
        }
        catch (Exception e) {
            log.error((Object)"Unable to look up remote deploy upload URL", (Throwable)e);
            return null;
        }
    }

    /*
     * Exception decompiling
     */
    public List deploy(boolean inPlace, File planFile, File moduleFile, File targetFile, boolean install, String mainClass, String mainGBean, String mainMethod, String manifestConfigurations, String classPath, String endorsedDirs, String extensionDirs, String targetConfigurationStore) throws DeploymentException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void notifyWatchers(List list) {
        Artifact[] arts = new Artifact[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            String s = (String)list.get(i);
            arts[i] = Artifact.create((String)s);
        }
        Iterator it = this.watchers.iterator();
        while (it.hasNext()) {
            DeploymentWatcher watcher = (DeploymentWatcher)it.next();
            for (int i = 0; i < arts.length; ++i) {
                Artifact art = arts[i];
                watcher.deployed(art);
            }
        }
    }

    private void cleanupConfigurations(List configurations) {
        Iterator iterator = configurations.iterator();
        while (iterator.hasNext()) {
            ConfigurationData configurationData = (ConfigurationData)iterator.next();
            File configurationDir = configurationData.getConfigurationDir();
            if (DeploymentUtil.recursiveDelete(configurationDir)) continue;
            this.pendingDeletionIndex.setProperty(configurationDir.getName(), "delete");
            log.debug((Object)("Queued deployment directory to be reaped " + configurationDir));
        }
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic((Class)Deployer.class, (String)DEPLOYER);
        infoFactory.addAttribute("kernel", Kernel.class, false);
        infoFactory.addAttribute("remoteDeployUploadURL", String.class, false);
        infoFactory.addOperation("deploy", new Class[]{Boolean.TYPE, File.class, File.class});
        infoFactory.addOperation("deploy", new Class[]{Boolean.TYPE, File.class, File.class, String.class});
        infoFactory.addOperation("deploy", new Class[]{Boolean.TYPE, File.class, File.class, File.class, Boolean.TYPE, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class});
        infoFactory.addReference("Builders", ConfigurationBuilder.class, "ConfigBuilder");
        infoFactory.addReference("Store", ConfigurationStore.class, "ConfigurationStore");
        infoFactory.addReference("Watchers", DeploymentWatcher.class);
        infoFactory.setConstructor(new String[]{"Builders", "Store", "Watchers", "kernel"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }

    class DeployerReaper
    implements Runnable {
        private final int reaperInterval;
        private volatile boolean done = false;

        public DeployerReaper(int reaperInterval) {
            this.reaperInterval = reaperInterval;
        }

        public void close() {
            this.done = true;
        }

        public void run() {
            log.debug((Object)"ConfigStoreReaper started");
            while (!this.done) {
                try {
                    Thread.sleep(this.reaperInterval);
                }
                catch (InterruptedException e) {
                    continue;
                }
                this.reap();
            }
        }

        public void reap() {
            if (Deployer.this.pendingDeletionIndex.size() == 0) {
                return;
            }
            Enumeration<?> list = Deployer.this.pendingDeletionIndex.propertyNames();
            while (list.hasMoreElements()) {
                String dirName = (String)list.nextElement();
                File deleteDir = new File(dirName);
                if (DeploymentUtil.recursiveDelete(deleteDir)) continue;
                Deployer.this.pendingDeletionIndex.remove(deleteDir);
                log.debug((Object)("Reaped deployment directory " + deleteDir));
            }
        }
    }
}

