/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.ResourceContext;
import org.apache.geronimo.deployment.util.DeploymentUtil;
import org.apache.geronimo.kernel.config.Configuration;

class CopyResourceContext
implements ResourceContext {
    private final Configuration configuration;
    private final URI baseUri;
    private final byte[] buffer = new byte[4096];

    public CopyResourceContext(Configuration configuration, File baseDir) throws DeploymentException {
        this.configuration = configuration;
        this.baseUri = baseDir.toURI();
        if (baseDir.isFile()) {
            try {
                configuration.addToClassPath("");
            }
            catch (IOException e) {
                throw new DeploymentException((Throwable)e);
            }
        }
    }

    public void addIncludeAsPackedJar(URI targetPath, JarFile jarFile) throws IOException {
        if (targetPath.getPath().endsWith("/")) {
            throw new IllegalStateException("target path must not end with a '/' character: " + targetPath);
        }
        File targetFile = this.getTargetFile(targetPath);
        DeploymentUtil.copyToPackedJar(jarFile, targetFile);
        if (!targetFile.isFile()) {
            throw new IllegalStateException("target file should be a file: " + targetFile);
        }
        this.configuration.addToClassPath(targetPath.toString());
    }

    public void addInclude(URI targetPath, ZipFile zipFile, ZipEntry zipEntry) throws IOException {
        File targetFile = this.getTargetFile(targetPath);
        this.addFile(targetFile, zipFile, zipEntry);
        this.configuration.addToClassPath(targetPath.toString());
    }

    public void addInclude(URI targetPath, URL source) throws IOException {
        if (targetPath.getPath().endsWith("/")) {
            throw new IllegalStateException("target path must not end with a '/' character: " + targetPath);
        }
        File targetFile = this.getTargetFile(targetPath);
        this.addFile(targetFile, source);
        if (!targetFile.isFile()) {
            throw new IllegalStateException("target file should be a file: " + targetFile);
        }
        this.configuration.addToClassPath(targetPath.toString());
    }

    public void addInclude(URI targetPath, File source) throws IOException {
        if (targetPath.getPath().endsWith("/")) {
            throw new IllegalStateException("target path must not end with a '/' character: " + targetPath);
        }
        File targetFile = this.getTargetFile(targetPath);
        this.addFile(targetFile, source);
        if (!targetFile.isFile()) {
            throw new IllegalStateException("target file should be a file: " + targetFile);
        }
        this.configuration.addToClassPath(targetPath.toString());
    }

    public void addFile(URI targetPath, ZipFile zipFile, ZipEntry zipEntry) throws IOException {
        this.addFile(this.getTargetFile(targetPath), zipFile, zipEntry);
    }

    public void addFile(URI targetPath, URL source) throws IOException {
        this.addFile(this.getTargetFile(targetPath), source);
    }

    public void addFile(URI targetPath, File source) throws IOException {
        this.addFile(this.getTargetFile(targetPath), source);
    }

    public void addFile(URI targetPath, String source) throws IOException {
        this.addFile(this.getTargetFile(targetPath), new ByteArrayInputStream(source.getBytes()));
    }

    public File getTargetFile(URI targetPath) {
        if (targetPath == null) {
            throw new NullPointerException("targetPath is null");
        }
        if (targetPath.isAbsolute()) {
            throw new IllegalArgumentException("targetPath is absolute");
        }
        if (targetPath.isOpaque()) {
            throw new IllegalArgumentException("targetPath is opaque");
        }
        return new File(this.baseUri.resolve(targetPath));
    }

    public void flush() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFile(File targetFile, ZipFile zipFile, ZipEntry zipEntry) throws IOException {
        if (zipEntry.isDirectory()) {
            targetFile.mkdirs();
        } else {
            InputStream is = zipFile.getInputStream(zipEntry);
            try {
                this.addFile(targetFile, is);
            }
            finally {
                DeploymentUtil.close(is);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFile(File targetFile, URL source) throws IOException {
        InputStream in = null;
        try {
            in = source.openStream();
            this.addFile(targetFile, in);
        }
        finally {
            DeploymentUtil.close(in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFile(File targetFile, File source) throws IOException {
        FileInputStream in = null;
        try {
            in = new FileInputStream(source);
            this.addFile(targetFile, in);
        }
        catch (Throwable throwable) {
            DeploymentUtil.close(in);
            throw throwable;
        }
        DeploymentUtil.close(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFile(File targetFile, InputStream source) throws IOException {
        targetFile.getParentFile().mkdirs();
        FileOutputStream out = null;
        try {
            int count;
            out = new FileOutputStream(targetFile);
            while ((count = source.read(this.buffer)) > 0) {
                ((OutputStream)out).write(this.buffer, 0, count);
            }
        }
        catch (Throwable throwable) {
            DeploymentUtil.close(out);
            throw throwable;
        }
        DeploymentUtil.close(out);
    }
}

