/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.util;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.util.URLInfo;
import org.apache.geronimo.deployment.util.URLType;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class DeploymentHelper {
    protected final URL url;
    protected final URLType urlType;
    protected URL j2eeURL;
    protected URL geronimoURL;

    public DeploymentHelper(URLInfo urlInfo, String j2eeDDName, String geronimoDDName) throws DeploymentException {
        this(urlInfo, j2eeDDName, geronimoDDName, "META-INF");
    }

    public DeploymentHelper(URLInfo urlInfo, String j2eeDDName, String geronimoDDName, String infDir) throws DeploymentException {
        block5: {
            this.url = urlInfo.getUrl();
            this.urlType = urlInfo.getType();
            try {
                if (URLType.RESOURCE == this.urlType) {
                    this.j2eeURL = null;
                    this.geronimoURL = this.url;
                    break block5;
                }
                if (URLType.PACKED_ARCHIVE == this.urlType) {
                    this.j2eeURL = new URL("jar:" + this.url.toExternalForm() + "!/" + infDir + "/" + j2eeDDName);
                    this.geronimoURL = new URL("jar:" + this.url.toExternalForm() + "!/" + infDir + "/" + geronimoDDName);
                    break block5;
                }
                if (URLType.UNPACKED_ARCHIVE == this.urlType) {
                    this.j2eeURL = new URL(this.url, infDir + "/" + j2eeDDName);
                    this.geronimoURL = new URL(this.url, infDir + "/" + geronimoDDName);
                    break block5;
                }
                this.j2eeURL = null;
                this.geronimoURL = null;
                return;
            }
            catch (MalformedURLException e1) {
                throw new DeploymentException("Should never occur", (Throwable)e1);
            }
        }
    }

    public URL locateJ2EEDD() {
        return this.j2eeURL;
    }

    public Document getJ2EEDoc(DocumentBuilder parser) {
        return this.getDoc(parser, this.j2eeURL);
    }

    public Document getGeronimoDoc(DocumentBuilder parser) {
        return this.getDoc(parser, this.geronimoURL);
    }

    private Document getDoc(DocumentBuilder parser, URL url) {
        if (url == null) {
            return null;
        }
        try {
            return parser.parse(url.openStream());
        }
        catch (SAXException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    public URL locateGeronimoDD() {
        return this.geronimoURL;
    }
}

