/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.management.ObjectName;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.kernel.GBeanNotFoundException;

public class GBeanDataRegistry {
    private final Map registry = new HashMap();

    public void preregister(ObjectName name) {
        this.registry.put(name, null);
    }

    public void register(GBeanData gbean) {
        this.registry.put(gbean.getName(), gbean);
    }

    public synchronized GBeanData getGBeanInstance(ObjectName name) throws GBeanNotFoundException {
        GBeanData gbeanData = (GBeanData)this.registry.get(name);
        if (gbeanData == null) {
            throw new GBeanNotFoundException(name);
        }
        return gbeanData;
    }

    public Set getGBeanNames() {
        return Collections.unmodifiableSet(this.registry.keySet());
    }

    public GBeanData[] getGBeans() {
        return this.registry.values().toArray(new GBeanData[this.registry.size()]);
    }

    public Set listGBeans(ObjectName pattern) {
        HashSet<ObjectName> result = new HashSet<ObjectName>();
        Iterator i = this.registry.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            ObjectName name = (ObjectName)entry.getKey();
            if (!pattern.apply(name)) continue;
            result.add(name);
        }
        return result;
    }
}

