/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.GBeanDataRegistry;
import org.apache.geronimo.deployment.util.DeploymentUtil;
import org.apache.geronimo.gbean.GBeanData;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.config.Configuration;
import org.apache.geronimo.kernel.config.ConfigurationData;
import org.apache.geronimo.kernel.config.ConfigurationManager;
import org.apache.geronimo.kernel.config.ConfigurationModuleType;
import org.apache.geronimo.kernel.config.ConfigurationUtil;
import org.apache.geronimo.kernel.config.InvalidConfigException;
import org.apache.geronimo.kernel.repository.Repository;

public class DeploymentContext {
    private final Kernel kernel;
    private final ConfigurationData configurationData;
    private final GBeanDataRegistry gbeans = new GBeanDataRegistry();
    private final File baseDir;
    private final URI baseUri;
    private final byte[] buffer = new byte[4096];
    private final List loadedAncestors;
    private final LinkedList startedAncestors;
    private final ClassLoader parentCL;
    static final /* synthetic */ boolean $assertionsDisabled;

    public DeploymentContext(File baseDir, URI configId, ConfigurationModuleType type, URI parentID, Kernel kernel) throws MalformedObjectNameException, DeploymentException {
        this(baseDir, configId, type, parentID, null, null, kernel);
    }

    public DeploymentContext(File baseDir, URI configId, ConfigurationModuleType type, URI parentId, String domain, String server, Kernel kernel) throws MalformedObjectNameException, DeploymentException {
        if (!$assertionsDisabled && baseDir == null) {
            throw new AssertionError((Object)"baseDir is null");
        }
        if (!$assertionsDisabled && configId == null) {
            throw new AssertionError((Object)"configID is null");
        }
        if (!$assertionsDisabled && type == null) {
            throw new AssertionError((Object)"type is null");
        }
        this.kernel = kernel;
        if (!baseDir.exists()) {
            baseDir.mkdirs();
        }
        if (!baseDir.isDirectory()) {
            throw new DeploymentException("Base directory is not a directory: " + baseDir.getAbsolutePath());
        }
        this.baseDir = baseDir;
        this.baseUri = baseDir.toURI();
        this.configurationData = new ConfigurationData();
        this.configurationData.setId(configId);
        this.configurationData.setModuleType(type);
        this.configurationData.setParentId(parentId);
        if (kernel != null && parentId != null) {
            ConfigurationManager configurationManager = ConfigurationUtil.getConfigurationManager((Kernel)kernel);
            ObjectName parentName = Configuration.getConfigurationObjectName((URI)parentId);
            try {
                this.loadedAncestors = configurationManager.loadRecursive(parentId);
            }
            catch (Exception e) {
                throw new DeploymentException("Unable to load parents", (Throwable)e);
            }
            try {
                domain = (String)kernel.getAttribute(parentName, "domain");
                server = (String)kernel.getAttribute(parentName, "server");
            }
            catch (Exception e) {
                throw new DeploymentException("Unable to copy domain and server from parent configuration", (Throwable)e);
            }
            try {
                this.startedAncestors = new LinkedList();
                ObjectName ancestorName = parentName;
                while (ancestorName != null && !DeploymentContext.isRunning(kernel, ancestorName)) {
                    this.startedAncestors.addFirst(ancestorName);
                    URI pattern = (URI)kernel.getGBeanData(ancestorName).getAttribute("parentId");
                    if (pattern == null) break;
                    ancestorName = Configuration.getConfigurationObjectName((URI)pattern);
                }
                Iterator iterator = this.startedAncestors.iterator();
                while (iterator.hasNext()) {
                    ObjectName objectName = (ObjectName)iterator.next();
                    kernel.startGBean(objectName);
                    if (DeploymentContext.isRunning(kernel, objectName)) continue;
                    throw new DeploymentException("Failed to start parent configuration: " + objectName);
                }
            }
            catch (DeploymentException e) {
                throw e;
            }
            catch (Exception e) {
                throw new DeploymentException((Throwable)e);
            }
            try {
                this.parentCL = (ClassLoader)kernel.getAttribute(parentName, "configurationClassLoader");
            }
            catch (Exception e) {
                throw new DeploymentException((Throwable)e);
            }
        }
        this.loadedAncestors = null;
        this.startedAncestors = null;
        this.parentCL = this.getClass().getClassLoader();
        if (domain == null || server == null) {
            throw new IllegalStateException("Domain or server could not be determined from explicit args or parent configuration. ParentID: " + parentId + ", domain: " + domain + ", server: " + server);
        }
        this.configurationData.setDomain(domain);
        this.configurationData.setServer(server);
    }

    private static boolean isRunning(Kernel kernel, ObjectName name) throws Exception {
        return 1 == kernel.getGBeanState(name);
    }

    public URI getConfigID() {
        return this.configurationData.getId();
    }

    public ConfigurationModuleType getType() {
        return this.configurationData.getModuleType();
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public String getDomain() {
        return this.configurationData.getDomain();
    }

    public String getServer() {
        return this.configurationData.getServer();
    }

    public void addGBean(GBeanData gbean) {
        if (!$assertionsDisabled && gbean.getName() == null) {
            throw new AssertionError((Object)"GBean name is null");
        }
        this.gbeans.register(gbean);
    }

    public Set getGBeanNames() {
        return this.gbeans.getGBeanNames();
    }

    public Set listGBeans(ObjectName pattern) {
        return this.gbeans.listGBeans(pattern);
    }

    public void addDependency(URI uri) {
        this.configurationData.addDependency(uri);
    }

    public void addIncludeAsPackedJar(URI targetPath, JarFile jarFile) throws IOException {
        File targetFile = this.getTargetFile(targetPath);
        DeploymentUtil.copyToPackedJar(jarFile, targetFile);
        this.configurationData.addClassPathLocation(targetPath);
    }

    public void addInclude(URI targetPath, ZipFile zipFile, ZipEntry zipEntry) throws IOException {
        File targetFile = this.getTargetFile(targetPath);
        this.addFile(targetFile, zipFile, zipEntry);
        this.configurationData.addClassPathLocation(targetPath);
    }

    public void addInclude(URI targetPath, URL source) throws IOException {
        File targetFile = this.getTargetFile(targetPath);
        this.addFile(targetFile, source);
        this.configurationData.addClassPathLocation(targetPath);
    }

    public void addInclude(URI targetPath, File source) throws IOException {
        File targetFile = this.getTargetFile(targetPath);
        this.addFile(targetFile, source);
        this.configurationData.addClassPathLocation(targetPath);
    }

    public void addManifestClassPath(JarFile moduleFile, URI moduleBaseUri) throws DeploymentException {
        Manifest manifest = null;
        try {
            manifest = moduleFile.getManifest();
        }
        catch (IOException e) {
            throw new DeploymentException("Could not read manifest: " + moduleBaseUri);
        }
        if (manifest == null) {
            return;
        }
        String manifestClassPath = manifest.getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
        if (manifestClassPath == null) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(manifestClassPath, " ");
        while (tokenizer.hasMoreTokens()) {
            URI pathUri;
            String path = tokenizer.nextToken();
            try {
                pathUri = new URI(path);
            }
            catch (URISyntaxException e) {
                throw new DeploymentException("Invalid manifest classpath entry: module=" + moduleBaseUri + ", path=" + path);
            }
            if (!pathUri.getPath().endsWith(".jar")) {
                throw new DeploymentException("Manifest class path entries must end with the .jar extension (J2EE 1.4 Section 8.2): module=" + moduleBaseUri);
            }
            if (pathUri.isAbsolute()) {
                throw new DeploymentException("Manifest class path entries must be relative (J2EE 1.4 Section 8.2): moduel=" + moduleBaseUri);
            }
            URI targetUri = moduleBaseUri.resolve(pathUri);
            this.configurationData.addClassPathLocation(targetUri);
        }
    }

    public void addFile(URI targetPath, ZipFile zipFile, ZipEntry zipEntry) throws IOException {
        this.addFile(this.getTargetFile(targetPath), zipFile, zipEntry);
    }

    public void addFile(URI targetPath, URL source) throws IOException {
        this.addFile(this.getTargetFile(targetPath), source);
    }

    public void addFile(URI targetPath, File source) throws IOException {
        this.addFile(this.getTargetFile(targetPath), source);
    }

    public void addFile(URI targetPath, String source) throws IOException {
        this.addFile(this.getTargetFile(targetPath), new ByteArrayInputStream(source.getBytes()));
    }

    public void addClass(URI location, String fqcn, byte[] bytes, boolean addToClasspath) throws IOException, URISyntaxException {
        if (!$assertionsDisabled && !location.toString().endsWith("/")) {
            throw new AssertionError();
        }
        if (addToClasspath) {
            this.configurationData.addClassPathLocation(location);
        }
        String classFileName = fqcn.replace('.', '/') + ".class";
        this.addFile(this.getTargetFile(new URI(location.toString() + classFileName)), new ByteArrayInputStream(bytes));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFile(File targetFile, ZipFile zipFile, ZipEntry zipEntry) throws IOException {
        if (zipEntry.isDirectory()) {
            targetFile.mkdirs();
        } else {
            InputStream is = zipFile.getInputStream(zipEntry);
            try {
                this.addFile(targetFile, is);
            }
            finally {
                DeploymentUtil.close(is);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFile(File targetFile, URL source) throws IOException {
        InputStream in = null;
        try {
            in = source.openStream();
            this.addFile(targetFile, in);
        }
        finally {
            DeploymentUtil.close(in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFile(File targetFile, File source) throws IOException {
        FileInputStream in = null;
        try {
            in = new FileInputStream(source);
            this.addFile(targetFile, in);
        }
        catch (Throwable throwable) {
            DeploymentUtil.close(in);
            throw throwable;
        }
        DeploymentUtil.close(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFile(File targetFile, InputStream source) throws IOException {
        targetFile.getParentFile().mkdirs();
        FileOutputStream out = null;
        try {
            int count;
            out = new FileOutputStream(targetFile);
            while ((count = source.read(this.buffer)) > 0) {
                ((OutputStream)out).write(this.buffer, 0, count);
            }
        }
        catch (Throwable throwable) {
            DeploymentUtil.close(out);
            throw throwable;
        }
        DeploymentUtil.close(out);
    }

    public File getTargetFile(URI targetPath) {
        if (!$assertionsDisabled && targetPath.isAbsolute()) {
            throw new AssertionError((Object)"targetPath is absolute");
        }
        if (!$assertionsDisabled && targetPath.isOpaque()) {
            throw new AssertionError((Object)"targetPath is opaque");
        }
        return new File(this.baseUri.resolve(targetPath));
    }

    public ClassLoader getClassLoader(Repository repository) throws DeploymentException {
        List dependencies = this.configurationData.getDependencies();
        List classPath = this.configurationData.getClassPath();
        URL[] urls = new URL[dependencies.size() + classPath.size()];
        try {
            int index = 0;
            Iterator iterator = dependencies.iterator();
            while (iterator.hasNext()) {
                URI uri = (URI)iterator.next();
                urls[index++] = repository.getURL(uri);
            }
            Iterator i = classPath.iterator();
            while (i.hasNext()) {
                URI path = (URI)i.next();
                urls[index++] = this.getTargetFile(path).toURL();
            }
        }
        catch (MalformedURLException e) {
            throw new DeploymentException((Throwable)e);
        }
        return new URLClassLoader(urls, this.parentCL);
    }

    public void close() throws IOException, DeploymentException {
        if (this.kernel != null) {
            ObjectName objectName;
            Iterator iterator;
            if (this.startedAncestors != null) {
                Collections.reverse(this.startedAncestors);
                iterator = this.startedAncestors.iterator();
                while (iterator.hasNext()) {
                    objectName = (ObjectName)iterator.next();
                    try {
                        this.kernel.stopGBean(objectName);
                    }
                    catch (GBeanNotFoundException e) {
                        throw new DeploymentException("Could not find a configuration we previously started! " + objectName, (Throwable)e);
                    }
                }
                this.startedAncestors.clear();
            }
            if (this.loadedAncestors != null) {
                Collections.reverse(this.loadedAncestors);
                iterator = this.loadedAncestors.iterator();
                while (iterator.hasNext()) {
                    objectName = (ObjectName)iterator.next();
                    try {
                        this.kernel.unloadGBean(objectName);
                    }
                    catch (GBeanNotFoundException e) {
                        throw new DeploymentException("Could not find a configuration we previously loaded! " + objectName, (Throwable)e);
                    }
                }
                this.loadedAncestors.clear();
            }
        }
    }

    public void addChildConfiguration(ConfigurationData configurationData) {
        this.configurationData.addChildConfiguration(configurationData);
    }

    public ConfigurationData getConfigurationData() {
        ConfigurationData configurationData = new ConfigurationData(this.configurationData);
        configurationData.setGBeans(Arrays.asList(this.gbeans.getGBeans()));
        return configurationData;
    }

    public GBeanData getConfigurationGBeanData() throws MalformedObjectNameException, InvalidConfigException {
        URI id = this.configurationData.getId();
        GBeanData config = new GBeanData(Configuration.getConfigurationObjectName((URI)id), Configuration.GBEAN_INFO);
        config.setAttribute("id", (Object)id);
        config.setAttribute("type", (Object)this.configurationData.getModuleType());
        config.setAttribute("domain", (Object)this.configurationData.getDomain());
        config.setAttribute("server", (Object)this.configurationData.getServer());
        URI parentId = this.configurationData.getParentId();
        if (parentId != null) {
            config.setAttribute("parentId", (Object)parentId);
            ObjectName parentName = Configuration.getConfigurationObjectName((URI)parentId);
            config.setReferencePattern("Parent", parentName);
        }
        config.setAttribute("gBeanState", (Object)Configuration.storeGBeans((GBeanData[])this.gbeans.getGBeans()));
        config.setReferencePatterns("Repositories", Collections.singleton(new ObjectName("*:name=Repository,*")));
        config.setAttribute("dependencies", (Object)this.configurationData.getDependencies());
        config.setAttribute("classPath", (Object)this.configurationData.getClassPath());
        return config;
    }

    public GBeanData[] getGBeans() {
        return this.gbeans.getGBeans();
    }

    static {
        $assertionsDisabled = !DeploymentContext.class.desiredAssertionStatus();
    }
}

