/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.ConfigurationBuilder;
import org.apache.geronimo.deployment.util.DeploymentUtil;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.kernel.config.ConfigurationData;
import org.apache.geronimo.kernel.config.ConfigurationStore;
import org.apache.geronimo.kernel.config.InvalidConfigException;
import org.apache.geronimo.system.configuration.ExecutableConfigurationUtil;
import org.apache.geronimo.system.main.CommandLineManifest;

public class Deployer {
    private static final Log log = LogFactory.getLog((Class)Deployer.class);
    private final Collection builders;
    private final ConfigurationStore store;
    public static final GBeanInfo GBEAN_INFO;
    private static final String DEPLOYER = "Deployer";

    public Deployer(Collection builders, ConfigurationStore store) {
        this.builders = builders;
        this.store = store;
    }

    public List deploy(File moduleFile, File planFile) throws DeploymentException {
        List e2;
        block8: {
            File originalModuleFile = moduleFile;
            File tmpDir = null;
            if (moduleFile != null && !moduleFile.isDirectory()) {
                try {
                    tmpDir = File.createTempFile("deployer", ".tmpdir");
                    tmpDir.delete();
                    tmpDir.mkdir();
                    File tmpFile = new File(tmpDir, moduleFile.getName());
                    DeploymentUtil.copyFile(moduleFile, tmpFile);
                    moduleFile = tmpFile;
                }
                catch (IOException e2) {
                    throw new DeploymentException((Throwable)e2);
                }
            }
            try {
                e2 = this.deploy(planFile, moduleFile, null, true, null, null, null);
                if (tmpDir == null) break block8;
            }
            catch (DeploymentException e3) {
                try {
                    log.debug((Object)("Deployment failed: plan=" + planFile + ", module=" + originalModuleFile), (Throwable)e3);
                    throw this.cleanseDeploymentException(e3);
                }
                catch (Throwable throwable) {
                    if (tmpDir != null) {
                        DeploymentUtil.recursiveDelete(tmpDir);
                    }
                    throw throwable;
                }
            }
            DeploymentUtil.recursiveDelete(tmpDir);
        }
        return e2;
    }

    private DeploymentException cleanseDeploymentException(DeploymentException source) {
        if (source.getCause() != null) {
            Throwable e = source.getCause();
            DeploymentException newx = new DeploymentException(source.getMessage() + " caused by " + e.getMessage(), null);
            return newx;
        }
        return source;
    }

    public List deploy(File planFile, File moduleFile, File targetFile, boolean install, String mainClass, String classPath, String endorsedDirs) throws DeploymentException {
        if (planFile == null && moduleFile == null) {
            throw new DeploymentException("No plan or module specified");
        }
        if (planFile != null) {
            if (!planFile.exists()) {
                throw new DeploymentException("Plan file does not exist: " + planFile.getAbsolutePath());
            }
            if (!planFile.isFile()) {
                throw new DeploymentException("Plan file is not a regular file: " + planFile.getAbsolutePath());
            }
        }
        JarFile module = null;
        if (moduleFile != null) {
            if (!moduleFile.exists()) {
                throw new DeploymentException("Module file does not exist: " + moduleFile.getAbsolutePath());
            }
            try {
                module = DeploymentUtil.createJarFile(moduleFile);
            }
            catch (IOException e) {
                throw new DeploymentException("Cound not open module file: " + moduleFile.getAbsolutePath(), (Throwable)e);
            }
        }
        File configurationDir = null;
        try {
            block28: {
                Object plan = null;
                ConfigurationBuilder builder = null;
                Iterator i = this.builders.iterator();
                while (i.hasNext()) {
                    ConfigurationBuilder candidate = (ConfigurationBuilder)i.next();
                    plan = candidate.getDeploymentPlan(planFile, module);
                    if (plan == null) continue;
                    builder = candidate;
                    break;
                }
                if (builder == null) {
                    throw new DeploymentException("Syntax error in deployment plan or no deployer service available (currently I can't tell the difference):" + (planFile == null ? "" : " planFile=" + planFile.getAbsolutePath()) + (moduleFile == null ? "" : ", moduleFile" + moduleFile.getAbsolutePath()));
                }
                configurationDir = this.store.createNewConfigurationDir();
                File metaInf = new File(configurationDir, "META-INF");
                metaInf.mkdirs();
                Manifest manifest = new Manifest();
                Attributes mainAttributes = manifest.getMainAttributes();
                mainAttributes.putValue(Attributes.Name.MANIFEST_VERSION.toString(), "1.0");
                if (mainClass != null) {
                    mainAttributes.putValue(Attributes.Name.MAIN_CLASS.toString(), mainClass);
                }
                if (classPath != null) {
                    mainAttributes.putValue(Attributes.Name.CLASS_PATH.toString(), classPath);
                }
                if (endorsedDirs != null) {
                    mainAttributes.putValue(CommandLineManifest.ENDORSED_DIRS.toString(), endorsedDirs);
                }
                ConfigurationData configurationData = builder.buildConfiguration(plan, module, configurationDir);
                try {
                    if (targetFile != null) {
                        ExecutableConfigurationUtil.createExecutableConfiguration((ConfigurationData)configurationData, (Manifest)manifest, (File)configurationDir, (File)targetFile);
                    }
                    if (!install) break block28;
                    this.store.install(configurationData, configurationDir);
                    ArrayList<String> deployedURIs = new ArrayList<String>();
                    deployedURIs.add(configurationData.getId().toString());
                    Iterator iterator = configurationData.getChildConfigurations().iterator();
                    while (iterator.hasNext()) {
                        ConfigurationData childConfiguration = (ConfigurationData)iterator.next();
                        deployedURIs.add(childConfiguration.getId().toString());
                    }
                    ArrayList<String> arrayList = deployedURIs;
                    return arrayList;
                }
                catch (InvalidConfigException e) {
                    try {
                        throw new DeploymentException((Throwable)e);
                    }
                    catch (Throwable e2) {
                        DeploymentUtil.recursiveDelete(configurationDir);
                        if (targetFile != null) {
                            targetFile.delete();
                        }
                        if (e2 instanceof Error) {
                            log.error((Object)"Deployment failed due to ", e2);
                            throw (Error)e2;
                        }
                        if (e2 instanceof DeploymentException) {
                            throw (DeploymentException)e2;
                        }
                        if (e2 instanceof Exception) {
                            log.error((Object)"Deployment failed due to ", e2);
                            throw new DeploymentException(e2);
                        }
                        throw new Error(e2);
                    }
                }
            }
            DeploymentUtil.recursiveDelete(configurationDir);
            List deployedURIs = Collections.EMPTY_LIST;
            return deployedURIs;
        }
        finally {
            DeploymentUtil.close(module);
        }
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = new GBeanInfoBuilder(Deployer.class, DEPLOYER);
        infoFactory.addOperation("deploy", new Class[]{File.class, File.class});
        infoFactory.addOperation("deploy", new Class[]{File.class, File.class, File.class, Boolean.TYPE, String.class, String.class, String.class});
        infoFactory.addReference("Builders", ConfigurationBuilder.class, "ConfigBuilder");
        infoFactory.addReference("Store", ConfigurationStore.class, "ConfigurationStore");
        infoFactory.setConstructor(new String[]{"Builders", "Store"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

