/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.cli;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.jar.JarFile;
import javax.enterprise.deploy.shared.factories.DeploymentFactoryManager;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import javax.enterprise.deploy.spi.factories.DeploymentFactory;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.cli.DeployUtils;
import org.apache.geronimo.deployment.cli.DeploymentSyntaxException;
import org.apache.geronimo.deployment.plugin.factories.AuthenticationFailedException;
import org.apache.geronimo.deployment.plugin.factories.DeploymentFactoryImpl;
import org.apache.geronimo.deployment.plugin.jmx.JMXDeploymentManager;
import org.apache.geronimo.deployment.plugin.jmx.LocalDeploymentManager;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.config.ConfigurationManager;
import org.apache.geronimo.kernel.config.ConfigurationUtil;
import org.apache.geronimo.system.main.LocalServer;
import org.apache.geronimo.util.SimpleEncryption;

public class ServerConnection {
    private static final Map OPTION_HELP = new LinkedHashMap(9);
    private static final String DEFAULT_URI = "deployer:geronimo:jmx";
    private DeploymentManager manager;
    private PrintWriter out;
    private BufferedReader in;
    private SavedAuthentication auth;
    private boolean logToSysErr;
    private boolean verboseMessages;

    public static Map getOptionHelp() {
        return OPTION_HELP;
    }

    public static boolean isGeneralOption(List args, String option) {
        if (OPTION_HELP.containsKey(option) || option.equals("--url")) {
            return true;
        }
        if (args.size() == 0) {
            return false;
        }
        String last = (String)args.get(args.size() - 1);
        return last.equals("--uri") || last.equals("--url") || last.equals("--driver") || last.equals("--user") || last.equals("--password") || last.equals("--host") || last.equals("--port");
    }

    public ServerConnection(String[] args, PrintWriter out, BufferedReader in) throws DeploymentException {
        String uri = null;
        String driver = null;
        String user = null;
        String password = null;
        String host = null;
        Integer port = null;
        this.out = out;
        this.in = in;
        boolean offline = false;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.equals("--uri") || arg.equals("--url")) {
                if (uri != null) {
                    throw new DeploymentSyntaxException("Cannot specify more than one URI");
                }
                if (i >= args.length - 1) {
                    throw new DeploymentSyntaxException("Must specify a URI (e.g. --uri deployer:...)");
                }
                if (host != null || port != null) {
                    throw new DeploymentSyntaxException("Cannot specify a URI as well as a host/port");
                }
                uri = args[++i];
                continue;
            }
            if (arg.equals("--host")) {
                if (host != null) {
                    throw new DeploymentSyntaxException("Cannot specify more than one host");
                }
                if (i >= args.length - 1) {
                    throw new DeploymentSyntaxException("Must specify a hostname (e.g. --host localhost)");
                }
                if (uri != null) {
                    throw new DeploymentSyntaxException("Cannot specify a URI as well as a host/port");
                }
                host = args[++i];
                continue;
            }
            if (arg.equals("--port")) {
                if (port != null) {
                    throw new DeploymentSyntaxException("Cannot specify more than one port");
                }
                if (i >= args.length - 1) {
                    throw new DeploymentSyntaxException("Must specify a port (e.g. --port 1099)");
                }
                if (uri != null) {
                    throw new DeploymentSyntaxException("Cannot specify a URI as well as a host/port");
                }
                try {
                    port = new Integer(args[++i]);
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new DeploymentSyntaxException("Port must be a number (" + e.getMessage() + ")");
                }
            }
            if (arg.equals("--driver")) {
                if (driver != null) {
                    throw new DeploymentSyntaxException("Cannot specify more than one driver");
                }
                if (i >= args.length - 1) {
                    throw new DeploymentSyntaxException("Must specify a driver JAR (--driver jarfile)");
                }
                driver = args[++i];
                continue;
            }
            if (arg.equals("--offline")) {
                offline = true;
                continue;
            }
            if (arg.equals("--user")) {
                if (user != null) {
                    throw new DeploymentSyntaxException("Cannot specify more than one user name");
                }
                if (i >= args.length - 1) {
                    throw new DeploymentSyntaxException("Must specify a username (--user username)");
                }
                user = args[++i];
                continue;
            }
            if (arg.equals("--password")) {
                if (password != null) {
                    throw new DeploymentSyntaxException("Cannot specify more than one password");
                }
                if (i >= args.length - 1) {
                    throw new DeploymentSyntaxException("Must specify a password (--password password)");
                }
                password = args[++i];
                continue;
            }
            if (arg.equals("--verbose")) {
                this.verboseMessages = true;
                continue;
            }
            if (arg.equals("--syserr")) {
                this.logToSysErr = true;
                continue;
            }
            throw new DeploymentException("Invalid option " + arg);
        }
        if (driver != null && uri == null) {
            throw new DeploymentSyntaxException("A custom driver requires a custom URI");
        }
        if (host != null || port != null) {
            uri = "deployer:geronimo:jmx://" + (host == null ? "" : host) + (port == null ? "" : ":" + port);
        }
        if (offline) {
            LocalServer localServer;
            try {
                localServer = new LocalServer("geronimo/j2ee-system//car", "var/config/offline-deployer-list");
            }
            catch (Exception e) {
                throw new DeploymentException("Could not start local server", (Throwable)e);
            }
            Kernel kernel = localServer.getKernel();
            ConfigurationManager configurationManager = ConfigurationUtil.getConfigurationManager((Kernel)kernel);
            configurationManager.setOnline(false);
            this.manager = new LocalDeploymentManager(localServer.getKernel());
        } else {
            this.tryToConnect(uri, driver, user, password, true);
        }
        if (this.manager == null) {
            throw new DeploymentException("Unexpected error; connection failed.");
        }
    }

    public void close() throws DeploymentException {
        if (this.manager != null) {
            this.manager.release();
        }
    }

    Serializable getAuthentication() {
        return this.auth;
    }

    String getServerURI() {
        return this.auth.uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryToConnect(String argURI, String driver, String user, String password, boolean authPrompt) throws DeploymentException {
        String useURI;
        DeploymentFactoryManager mgr = DeploymentFactoryManager.getInstance();
        if (driver != null) {
            this.loadDriver(driver, mgr);
        } else {
            mgr.registerDeploymentFactory((DeploymentFactory)new DeploymentFactoryImpl());
        }
        String string = useURI = argURI == null ? DEFAULT_URI : argURI;
        if (authPrompt && user == null && password == null) {
            File authFile;
            InputStream in = ServerConnection.class.getResourceAsStream("/.geronimo-deployer");
            if (in == null && (authFile = new File(System.getProperty("user.home"), ".geronimo-deployer")).exists() && authFile.canRead()) {
                try {
                    in = new BufferedInputStream(new FileInputStream(authFile));
                }
                catch (FileNotFoundException e) {
                    // empty catch block
                }
            }
            if (in != null) {
                try {
                    Properties props = new Properties();
                    props.load(in);
                    String encryped = props.getProperty("login." + useURI);
                    if (encryped != null) {
                        if (encryped.startsWith("{Standard}")) {
                            SavedAuthentication auth = (SavedAuthentication)SimpleEncryption.decrypt((String)encryped.substring(10));
                            if (auth.uri.equals(useURI)) {
                                user = auth.user;
                                password = new String(auth.password);
                            }
                        } else if (encryped.startsWith("{Plain}")) {
                            int pos = encryped.indexOf("/");
                            user = encryped.substring(7, pos);
                            password = encryped.substring(pos + 1);
                        } else {
                            System.out.print(DeployUtils.reformat("Unknown encryption used in saved login file", 4, 72));
                        }
                    }
                }
                catch (IOException e) {
                    System.out.print(DeployUtils.reformat("Unable to read authentication from saved login file: " + e.getMessage(), 4, 72));
                }
                finally {
                    try {
                        in.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        if (authPrompt && !useURI.equals(DEFAULT_URI) && user == null && password == null) {
            this.doAuthPromptAndRetry(useURI, user, password);
            return;
        }
        try {
            this.manager = mgr.getDeploymentManager(useURI, user, password);
            this.auth = new SavedAuthentication(useURI, user, password == null ? null : password.toCharArray());
        }
        catch (AuthenticationFailedException e) {
            if (authPrompt) {
                this.doAuthPromptAndRetry(useURI, user, password);
                return;
            }
            throw new DeploymentException("Login Failed");
        }
        catch (DeploymentManagerCreationException e) {
            throw new DeploymentException("Unable to connect to server at " + useURI + " -- " + e.getMessage());
        }
        if (this.manager instanceof JMXDeploymentManager) {
            JMXDeploymentManager deploymentManager = (JMXDeploymentManager)this.manager;
            deploymentManager.setLogConfiguration(this.logToSysErr, this.verboseMessages);
        }
    }

    private void loadDriver(String driver, DeploymentFactoryManager mgr) throws DeploymentException {
        File file = new File(driver);
        if (!(file.exists() && file.canRead() && DeployUtils.isJarFile((File)file))) {
            throw new DeploymentSyntaxException("Driver '" + file.getAbsolutePath() + "' is not a readable JAR file");
        }
        String className = null;
        try {
            JarFile jar = new JarFile(file);
            className = jar.getManifest().getMainAttributes().getValue("J2EE-DeploymentFactory-Implementation-Class");
            if (className == null) {
                throw new DeploymentException("The driver JAR " + file.getAbsolutePath() + " does not specify a J2EE-DeploymentFactory-Implementation-Class; cannot load driver.");
            }
            jar.close();
            DeploymentFactory factory = (DeploymentFactory)Class.forName(className).newInstance();
            mgr.registerDeploymentFactory(factory);
        }
        catch (DeploymentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DeploymentSyntaxException("Unable to load driver class " + className + " from JAR " + file.getAbsolutePath(), e);
        }
    }

    private void doAuthPromptAndRetry(String uri, String user, String password) throws DeploymentException {
        try {
            if (user == null) {
                this.out.print("Username: ");
                this.out.flush();
                user = this.in.readLine();
            }
            if (password == null) {
                password = new PasswordPrompt("Password: ", this.out).getPassword(this.in);
            }
        }
        catch (IOException e) {
            throw new DeploymentException("Unable to prompt for login", (Throwable)e);
        }
        this.tryToConnect(uri, null, user, password, false);
    }

    public DeploymentManager getDeploymentManager() {
        return this.manager;
    }

    public boolean isGeronimo() {
        return this.manager.getClass().getName().startsWith("org.apache.geronimo.");
    }

    static {
        OPTION_HELP.put("--uri", "A URI to contact the server.  If not specified, the deployer defaults to operating on a Geronimo server running on the standard port on localhost.\nA URI to connect to Geronimo (including optional host and port parameters) has the form: deployer:geronimo:jmx[://host[:port]] (though you could also just use --host and --port instead).");
        OPTION_HELP.put("--host", "The host name of a Geronimo server to deploy to.  This option is not compatible with --uri, but is often used with --port.");
        OPTION_HELP.put("--port", "The RMI listen port of a Geronimo server to deploy to.  This option is not compatible with --uri, but is often used with --host.  The default port is 1099.");
        OPTION_HELP.put("--driver", "If you want to use this tool with a server other than Geronimo, then you must provide the path to its driver JAR.  Currently, manifest Class-Path entries in that JAR are ignored.");
        OPTION_HELP.put("--user", "If the deployment operation requires authentication, then you can specify the username to use to connect.  If no password is specified, the deployer will attempt to connect to the server with no password, and if that fails, will prompt you for a password.");
        OPTION_HELP.put("--password", "Specifies a password to use to authenticate to the server.");
        OPTION_HELP.put("--syserr", "Enables error logging to syserr.  Disabled by default.");
        OPTION_HELP.put("--verbose", "Enables verbose execution mode.  Disabled by default.");
        OPTION_HELP.put("--offline", "Deploy offline to a local server, using whatever deployers are available in the local server");
    }

    private static final class SavedAuthentication
    implements Serializable {
        private String uri;
        private String user;
        private char[] password;

        public SavedAuthentication(String uri, String user, char[] password) {
            this.uri = uri;
            this.user = user;
            this.password = password;
        }
    }

    public static class PasswordPrompt
    implements Runnable {
        private volatile boolean done = false;
        private String prompt;
        private PrintWriter out;

        public PasswordPrompt(String prompt, PrintWriter out) {
            this.prompt = prompt;
            this.out = out;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            int priority = Thread.currentThread().getPriority();
            try {
                Thread.currentThread().setPriority(10);
                String fullPrompt = "\r" + this.prompt + "          " + "\r" + this.prompt;
                StringBuffer clearline = new StringBuffer();
                clearline.append('\r');
                for (int i = this.prompt.length() + 10; i >= 0; --i) {
                    clearline.append(' ');
                }
                while (!this.done) {
                    this.out.print(fullPrompt);
                    this.out.flush();
                    Thread.sleep(1L);
                }
                this.out.print(clearline.toString());
                this.out.flush();
                this.out.println();
                this.out.flush();
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                Thread.currentThread().setPriority(priority);
            }
            this.prompt = null;
            this.out = null;
        }

        public String getPassword(BufferedReader in) throws IOException {
            Thread t = new Thread((Runnable)this, "Password hiding thread");
            t.start();
            String password = in.readLine();
            this.done = true;
            try {
                t.join();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            return password;
        }
    }
}

