/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.cli;

import java.io.File;
import java.io.PrintWriter;
import javax.enterprise.deploy.spi.DeploymentManager;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.cli.AbstractCommand;
import org.apache.geronimo.deployment.cli.CommandStart;
import org.apache.geronimo.deployment.cli.DeployUtils;
import org.apache.geronimo.deployment.cli.DeploymentSyntaxException;
import org.apache.geronimo.deployment.cli.ServerConnection;
import org.apache.geronimo.deployment.plugin.GeronimoDeploymentManager;
import org.apache.geronimo.kernel.repository.Artifact;
import org.apache.geronimo.system.plugin.DownloadResults;

public class CommandInstallCAR
extends AbstractCommand {
    public CommandInstallCAR() {
        super("install-plugin", "3. Geronimo Plugins", "PluginFile", "Installs a Geronimo plugin you've exported from a Geronimo server or downloaded from an external repository.  The file must be a properly configured Geronimo CAR file.  This is used to add new functionality to the Geronimo server.");
    }

    public CommandInstallCAR(String command, String group, String helpArgumentList, String helpText) {
        super(command, group, helpArgumentList, helpText);
    }

    public void execute(PrintWriter out, ServerConnection connection, String[] args) throws DeploymentException {
        if (args.length == 0) {
            throw new DeploymentSyntaxException("Must specify Plugin CAR file");
        }
        DeploymentManager dmgr = connection.getDeploymentManager();
        if (dmgr instanceof GeronimoDeploymentManager) {
            GeronimoDeploymentManager mgr = (GeronimoDeploymentManager)dmgr;
            File carFile = new File(args[0]);
            if (!(carFile = carFile.getAbsoluteFile()).exists() || !carFile.canRead()) {
                throw new DeploymentException("CAR file cannot be read: " + carFile.getAbsolutePath());
            }
            Object key = mgr.startInstall(carFile, null, null);
            long start = System.currentTimeMillis();
            DownloadResults results = CommandInstallCAR.showProgress(mgr, key);
            int time = (int)(System.currentTimeMillis() - start) / 1000;
            System.out.println();
            if (!results.isFailed()) {
                Artifact uri;
                int i;
                System.out.print(DeployUtils.reformat("**** Installation Complete!", 4, 72));
                for (i = 0; i < results.getDependenciesPresent().length; ++i) {
                    uri = results.getDependenciesPresent()[i];
                    System.out.print(DeployUtils.reformat("Used existing: " + uri, 4, 72));
                }
                for (i = 0; i < results.getDependenciesInstalled().length; ++i) {
                    uri = results.getDependenciesInstalled()[i];
                    System.out.print(DeployUtils.reformat("Installed new: " + uri, 4, 72));
                }
                if (results.getTotalDownloadBytes() > 0L && time > 0) {
                    System.out.println();
                    System.out.print(DeployUtils.reformat("Downloaded " + results.getTotalDownloadBytes() / 1024L + " kB in " + time + "s (" + results.getTotalDownloadBytes() / (long)(1024 * time) + " kB/s)", 4, 72));
                }
            }
            if (results.isFinished() && !results.isFailed() && results.getInstalledConfigIDs().length == 1) {
                Artifact target = results.getInstalledConfigIDs()[0];
                System.out.print(DeployUtils.reformat("Now starting " + target + "...", 4, 72));
                System.out.flush();
                new CommandStart().execute(out, connection, new String[]{target.toString()});
            }
        } else {
            throw new DeploymentException("Cannot install plugins when connected to " + connection.getServerURI());
        }
    }

    static DownloadResults showProgress(GeronimoDeploymentManager mgr, Object key) {
        System.out.println("Checking for status every 1000ms:");
        String last = null;
        while (true) {
            DownloadResults results;
            if ((results = mgr.checkOnInstall(key)).getCurrentFile() != null) {
                String status = results.getCurrentFilePercent() > -1 ? results.getCurrentMessage() + " (" + results.getCurrentFilePercent() + "%)" : results.getCurrentMessage();
                if (last == null || !last.equals(status)) {
                    last = status;
                    System.out.println(status);
                }
            }
            if (results.isFinished()) {
                if (results.isFailed()) {
                    System.err.println("Installation FAILED: " + results.getFailure().getMessage());
                }
                return results;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                return results;
            }
        }
    }
}

