/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.cli;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.util.HashMap;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.geronimo.deployment.cli.ServerConnection;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.jmx.KernelDelegate;

public class StopServer {
    public static final String RMI_NAMING_CONFG_ID = "org/apache/geronimo/RMINaming";
    public static final String DEFAULT_PORT = "1099";
    String port;
    String user;
    String password;
    private String[] args;

    public static void main(String[] args) {
        StopServer cmd = new StopServer();
        cmd.execute(args);
    }

    public void execute(String[] args) {
        this.args = args;
        int i = 0;
        while (i < args.length && args[i].startsWith("--")) {
            if (!this.setParam(i++)) continue;
            ++i;
        }
        if (i < args.length) {
            this.printUsage();
        }
        try {
            if (this.port != null) {
                Integer.parseInt(this.port);
            }
        }
        catch (NumberFormatException e) {
            System.out.println("Invalid port number specified.");
            System.exit(1);
        }
        PrintWriter out = new PrintWriter((Writer)new OutputStreamWriter(System.out), true);
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        try {
            if (this.user == null) {
                out.print("Username: ");
                out.flush();
                this.user = in.readLine();
            }
            if (this.password == null) {
                this.password = new ServerConnection.PasswordPrompt("Password: ", out).getPassword(in);
            }
        }
        catch (IOException e) {
            System.out.println("Unable to prompt for login.");
            System.exit(1);
        }
        try {
            if (this.port == null) {
                this.port = DEFAULT_PORT;
            }
            System.out.print("Locating server on port " + this.port + "... ");
            Kernel kernel = null;
            try {
                kernel = this.getRunningKernel();
            }
            catch (IOException e) {
                System.out.println("\nCould not communicate with the server.  The server may not be running or the port number may be incorrect.");
            }
            if (kernel != null) {
                System.out.println("Server found.");
                System.out.println("Server shutdown begun");
                kernel.shutdown();
                System.out.println("Server shutdown completed");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean argumentHasValue(int i) {
        return i + 1 < this.args.length && !this.args[i + 1].startsWith("--");
    }

    private boolean setParam(int i) {
        if (this.argumentHasValue(i)) {
            if (this.args[i].equals("--user")) {
                this.user = this.args[++i];
            } else if (this.args[i].equals("--password")) {
                this.password = this.args[++i];
            } else if (this.args[i].equals("--port")) {
                this.port = this.args[++i];
            } else {
                this.printUsage();
            }
            return true;
        }
        this.printUsage();
        return false;
    }

    public Kernel getRunningKernel() throws IOException {
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        map.put("jmx.remote.credentials", new String[]{this.user, this.password});
        KernelDelegate kernel = null;
        try {
            JMXServiceURL address = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://localhost:" + this.port + "/JMXConnector");
            JMXConnector jmxConnector = JMXConnectorFactory.connect(address, map);
            MBeanServerConnection mbServerConnection = jmxConnector.getMBeanServerConnection();
            kernel = new KernelDelegate(mbServerConnection);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return kernel;
    }

    public void printUsage() {
        System.out.println();
        System.out.println("Command-line shutdown syntax:");
        System.out.println("    shutdown [options]");
        System.out.println();
        System.out.println("The available options are:");
        System.out.println("    --user");
        System.out.println("    --password");
        System.out.println("    --port");
        System.exit(1);
    }
}

