/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.cli;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.common.GeronimoEnvironment;
import org.apache.geronimo.deployment.cli.CommandDeploy;
import org.apache.geronimo.deployment.cli.CommandDistribute;
import org.apache.geronimo.deployment.cli.CommandListModules;
import org.apache.geronimo.deployment.cli.CommandListTargets;
import org.apache.geronimo.deployment.cli.CommandLogin;
import org.apache.geronimo.deployment.cli.CommandRedeploy;
import org.apache.geronimo.deployment.cli.CommandStart;
import org.apache.geronimo.deployment.cli.CommandStop;
import org.apache.geronimo.deployment.cli.CommandUndeploy;
import org.apache.geronimo.deployment.cli.DeployCommand;
import org.apache.geronimo.deployment.cli.DeployUtils;
import org.apache.geronimo.deployment.cli.DeploymentSyntaxException;
import org.apache.geronimo.deployment.cli.ServerConnection;

public class DeployTool {
    private static final Map commands = new HashMap();
    private boolean failed = false;
    String[] generalArgs = new String[0];
    ServerConnection con = null;
    private boolean multipleCommands = false;

    public static void registerCommand(DeployCommand command) {
        String key = command.getCommandName();
        if (commands.containsKey(key)) {
            throw new IllegalArgumentException("Command " + key + " is already registered!");
        }
        commands.put(key, command);
    }

    private static DeployCommand getCommand(String name) {
        return (DeployCommand)commands.get(name);
    }

    private static DeployCommand[] getAllCommands() {
        DeployCommand[] list = commands.values().toArray(new DeployCommand[0]);
        Arrays.sort(list, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((DeployCommand)o1).getCommandName().compareTo(((DeployCommand)o2).getCommandName());
            }
        });
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public boolean execute(String[] args) {
        block45: {
            out = new PrintWriter((Writer)new OutputStreamWriter(System.out), true);
            in = new BufferedReader(new InputStreamReader(System.in));
            commandArgs = new String[]{};
            if (args.length == 0) {
                command = "help";
            } else {
                temp = this.getCommonArgsAndCommand(args);
                if (temp == null || temp.length == 0) {
                    command = "help";
                } else {
                    command = temp[temp.length - 1];
                    if (this.generalArgs.length == 0 && temp.length > 1) {
                        this.generalArgs = new String[temp.length - 1];
                        System.arraycopy(temp, 0, this.generalArgs, 0, temp.length - 1);
                    }
                    commandArgs = new String[args.length - temp.length];
                    System.arraycopy(args, temp.length, commandArgs, 0, commandArgs.length);
                }
            }
            if (command.equals("help")) {
                this.showHelp(out, commandArgs);
            } else if (command.equals("command-file")) {
                this.multipleCommands = true;
                if (commandArgs.length != 1) {
                    this.processException(out, (Exception)new DeploymentSyntaxException("Must provide a command file to read from and no other arguments"));
                } else {
                    arg = commandArgs[0];
                    source = new File(arg);
                    if (!source.exists() || !source.canRead() || source.isDirectory()) {
                        this.processException(out, (Exception)new DeploymentSyntaxException("Cannot read command file " + source.getAbsolutePath()));
                    } else {
                        try {
                            commands = new BufferedReader(new FileReader(source));
                            oneFailed = false;
                            while ((line = commands.readLine()) != null) {
                                if ((line = line.trim()).equals("")) continue;
                                lineArgs = DeployTool.splitCommand(line);
                                if (this.failed) {
                                    oneFailed = true;
                                }
                                this.failed = false;
                                this.execute(lineArgs);
                            }
                            this.failed = oneFailed;
                        }
                        catch (IOException e) {
                            this.processException(out, (Exception)new DeploymentException("Unable to read command file", (Throwable)e));
                        }
                        finally {
                            try {
                                this.con.close();
                            }
                            catch (DeploymentException e) {
                                this.processException(out, (Exception)e);
                            }
                        }
                    }
                }
            } else {
                dc = DeployTool.getCommand(command);
                if (dc == null) {
                    out.println();
                    this.processException(out, (Exception)new DeploymentSyntaxException("No such command: '" + command + "'"));
                    this.showHelp(out, new String[0]);
                } else {
                    try {
                        if (this.con == null) {
                            this.con = new ServerConnection(this.generalArgs, out, in);
                        }
                        try {
                            dc.execute(out, this.con, commandArgs);
                            var15_20 = null;
                            ** if (this.multipleCommands) goto lbl-1000
                        }
                        catch (Throwable var14_28) {
                            var15_23 = null;
                            if (!this.multipleCommands) {
                                try {
                                    this.con.close();
                                }
                                catch (DeploymentException e) {
                                    this.processException(out, (Exception)e);
                                }
                            }
                            throw var14_28;
                        }
lbl-1000:
                        // 1 sources

                        {
                            try {
                                this.con.close();
                            }
                            catch (DeploymentException e) {
                                this.processException(out, (Exception)e);
                            }
                        }
lbl-1000:
                        // 2 sources

                        {
                            break block45;
                            catch (DeploymentSyntaxException e) {
                                this.processException(out, (Exception)e);
                                var15_21 = null;
                                if (!this.multipleCommands) {
                                    try {
                                        this.con.close();
                                    }
                                    catch (DeploymentException e) {
                                        this.processException(out, (Exception)e);
                                    }
                                }
                                break block45;
                            }
                            catch (DeploymentException e) {
                                this.processException(out, (Exception)e);
                                var15_22 = null;
                                if (!this.multipleCommands) {
                                    try {
                                        this.con.close();
                                    }
                                    catch (DeploymentException e) {
                                        this.processException(out, (Exception)e);
                                    }
                                }
                            }
                        }
                    }
                    catch (DeploymentException e) {
                        this.processException(out, (Exception)e);
                    }
                }
            }
        }
        out.flush();
        System.out.flush();
        return this.failed == false;
    }

    public static String[] splitCommand(String line) {
        String[] chunks = line.split("\"");
        LinkedList<String> list = new LinkedList<String>();
        for (int i = 0; i < chunks.length; ++i) {
            String chunk = chunks[i];
            if (i % 2 == 1) {
                list.add(chunk);
                continue;
            }
            list.addAll(Arrays.asList(chunk.split("\\s")));
        }
        Iterator it = list.iterator();
        while (it.hasNext()) {
            String test = (String)it.next();
            if (!test.trim().equals("")) continue;
            it.remove();
        }
        return list.toArray(new String[list.size()]);
    }

    private void processException(PrintWriter out, Exception e) {
        this.failed = true;
        out.println(DeployUtils.reformat("Error: " + e.getMessage(), 4, 72));
        if (e.getCause() != null) {
            e.getCause().printStackTrace(out);
        }
    }

    private void showHelp(PrintWriter out, String[] args) {
        out.println();
        out.println("Command-line deployer syntax:");
        out.println("    deployer [general options] command [command options]");
        out.println();
        if (args.length > 0) {
            DeployCommand command = DeployTool.getCommand(args[0]);
            if (command != null) {
                out.println("Help for command: " + command.getCommandName());
                out.println();
                out.println("    deployer " + this.hangingIndent(command.getCommandName() + " " + command.getHelpArgumentList(), 13));
                out.println();
                out.println(DeployUtils.reformat(command.getHelpText(), 8, 72));
                out.println();
                return;
            }
            if (args[0].equals("options")) {
                out.println("Help on general options:");
                out.println();
                Map map = ServerConnection.getOptionHelp();
                Iterator it = map.keySet().iterator();
                while (it.hasNext()) {
                    String s = (String)it.next();
                    out.println("   " + s);
                    out.println();
                    out.println(DeployUtils.reformat((String)map.get(s), 8, 72));
                }
                return;
            }
            if (args[0].equals("all")) {
                DeployCommand[] all = DeployTool.getAllCommands();
                out.println();
                out.println("All commands");
                out.println();
                for (int i = 0; i < all.length; ++i) {
                    DeployCommand cmd = all[i];
                    out.println("    deployer " + this.hangingIndent(cmd.getCommandName() + " " + cmd.getHelpArgumentList(), 13));
                    out.println(DeployUtils.reformat(cmd.getHelpText(), 8, 72));
                }
                out.println();
                return;
            }
        }
        out.println("The general options are:");
        Map map = ServerConnection.getOptionHelp();
        Iterator it = map.keySet().iterator();
        while (it.hasNext()) {
            String s = (String)it.next();
            out.println("    " + s);
        }
        out.println();
        out.println("The available commands are:");
        this.renderCommandList(out, DeployTool.getAllCommands());
        out.println();
        out.println("For more information about a specific command, run");
        out.println("    deployer help [command name]");
        out.println();
        out.println("For more information about general options, run");
        out.println("    deployer help options");
        out.println();
    }

    private String hangingIndent(String source, int cols) {
        String s = DeployUtils.reformat(source, cols, 72);
        return s.substring(cols);
    }

    private void renderCommandList(PrintWriter out, DeployCommand[] all) {
        HashMap<String, ArrayList<String>> temp = new HashMap<String, ArrayList<String>>();
        for (int i = 0; i < all.length; ++i) {
            DeployCommand command = all[i];
            ArrayList<String> list = (ArrayList<String>)temp.get(command.getCommandGroup());
            if (list == null) {
                list = new ArrayList<String>();
                temp.put(command.getCommandGroup(), list);
            }
            list.add(command.getCommandName());
        }
        ArrayList groups = new ArrayList(temp.keySet());
        Collections.sort(groups);
        for (int i = 0; i < groups.size(); ++i) {
            String name = (String)groups.get(i);
            out.println("    " + name);
            List list = (List)temp.get(name);
            Collections.sort(list);
            for (int j = 0; j < list.size(); ++j) {
                String cmd = (String)list.get(j);
                out.println("        " + cmd);
            }
        }
    }

    private String[] getCommonArgsAndCommand(String[] all) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < all.length; ++i) {
            String s = all[i];
            boolean option = ServerConnection.isGeneralOption(list, s);
            list.add(s);
            if (!option) break;
        }
        return list.toArray(new String[list.size()]);
    }

    public static void main(String[] args) {
        if (!new DeployTool().execute(args)) {
            System.exit(1);
        } else {
            System.exit(0);
        }
    }

    static {
        GeronimoEnvironment.init();
        DeployTool.registerCommand(new CommandLogin());
        DeployTool.registerCommand(new CommandDeploy());
        DeployTool.registerCommand(new CommandDistribute());
        DeployTool.registerCommand(new CommandListModules());
        DeployTool.registerCommand(new CommandListTargets());
        DeployTool.registerCommand(new CommandRedeploy());
        DeployTool.registerCommand(new CommandStart());
        DeployTool.registerCommand(new CommandStop());
        DeployTool.registerCommand(new CommandUndeploy());
    }
}

