/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.cli;

import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.cli.AbstractCommand;
import org.apache.geronimo.deployment.cli.DeployUtils;
import org.apache.geronimo.deployment.cli.DeploymentSyntaxException;
import org.apache.geronimo.deployment.cli.ServerConnection;

public class CommandDistribute
extends AbstractCommand {
    public CommandDistribute() {
        super("distribute", "2. Other Commands", "[--targets target;target;...] [module] [plan]", "Processes a module and adds it to the server environment, but does not start it or mark it to be started in the future.Normally both a module and plan are passed to the deployer.  Sometimes the module contains a plan, or requires no plan, in which case the plan may be omitted.  Sometimes the plan references a module already deployed in the Geronimo server environment, in which case a module does not need to be provided.\nIf no targets are provided, the module is distributed to all available targets.  Geronimo only provides one target (ever), so this is primarily useful when using a different driver.");
    }

    protected CommandDistribute(String command, String group, String helpArgumentList, String helpText) {
        super(command, group, helpArgumentList, helpText);
    }

    protected ProgressObject runCommand(DeploymentManager mgr, PrintWriter out, Target[] tlist, File module, File plan) throws DeploymentException {
        return mgr.distribute(tlist, module, plan);
    }

    protected String getAction() {
        return "Distributed";
    }

    public void execute(PrintWriter out, ServerConnection connection, String[] args) throws DeploymentException {
        File test;
        if (args.length == 0) {
            throw new DeploymentSyntaxException("Must specify a module or plan (or both)");
        }
        ArrayList targets = new ArrayList();
        if ((args = this.processTargets(args, targets)).length > 2) {
            throw new DeploymentSyntaxException("Too many arguments");
        }
        File module = null;
        File plan = null;
        if (args.length > 0) {
            test = new File(args[0]);
            if (DeployUtils.isJarFile(test) || test.isDirectory()) {
                if (module != null) {
                    throw new DeploymentSyntaxException("Module and plan cannot both be JAR files or directories!");
                }
                module = test;
            } else {
                if (plan != null) {
                    throw new DeploymentSyntaxException("Module or plan must be a JAR file or directory!");
                }
                plan = test;
            }
        }
        if (args.length > 1) {
            test = new File(args[1]);
            if (DeployUtils.isJarFile(test) || test.isDirectory()) {
                if (module != null) {
                    throw new DeploymentSyntaxException("Module and plan cannot both be JAR files or directories!");
                }
                module = test;
            } else {
                if (plan != null) {
                    throw new DeploymentSyntaxException("Module or plan must be a JAR file or directory!");
                }
                plan = test;
            }
        }
        if (module != null) {
            module = module.getAbsoluteFile();
        }
        if (plan != null) {
            plan = plan.getAbsoluteFile();
        }
        this.executeOnline(connection, targets, out, module, plan);
    }

    private void executeOnline(ServerConnection connection, List targets, PrintWriter out, File module, File plan) throws DeploymentException {
        ProgressObject po;
        boolean multipleTargets;
        Target[] tlist;
        DeploymentManager mgr = connection.getDeploymentManager();
        if (targets.size() > 0) {
            tlist = CommandDistribute.identifyTargets(targets, mgr);
            multipleTargets = tlist.length > 1;
            po = this.runCommand(mgr, out, tlist, module, plan);
            this.waitForProgress(out, po);
        } else {
            tlist = mgr.getTargets();
            multipleTargets = tlist.length > 1;
            po = this.runCommand(mgr, out, tlist, module, plan);
            this.waitForProgress(out, po);
        }
        TargetModuleID[] results = po.getResultTargetModuleIDs();
        for (int i = 0; i < results.length; ++i) {
            TargetModuleID result = results[i];
            out.println(DeployUtils.reformat(this.getAction() + " " + result.getModuleID() + (multipleTargets ? " to " + result.getTarget().getName() : "") + (result.getWebURL() == null || !this.getAction().equals("Deployed") ? "" : " @ " + result.getWebURL()), 4, 72));
            if (result.getChildTargetModuleID() == null) continue;
            for (int j = 0; j < result.getChildTargetModuleID().length; ++j) {
                TargetModuleID child = result.getChildTargetModuleID()[j];
                out.println(DeployUtils.reformat("  `-> " + child.getModuleID() + (child.getWebURL() == null || !this.getAction().equals("Deployed") ? "" : " @ " + child.getWebURL()), 4, 72));
            }
        }
        if (po.getDeploymentStatus().isFailed()) {
            throw new DeploymentException("Operation failed: " + po.getDeploymentStatus().getMessage());
        }
    }

    private String[] processTargets(String[] args, List targets) {
        if (args.length >= 2 && args[0].equals("--targets")) {
            String value = args[1];
            StringTokenizer tok = new StringTokenizer(value, ";", false);
            while (tok.hasMoreTokens()) {
                targets.add(tok.nextToken());
            }
            String[] temp = new String[args.length - 2];
            System.arraycopy(args, 2, temp, 0, temp.length);
            args = temp;
        }
        return args;
    }
}

