/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.cli;

import java.io.PrintWriter;
import javax.enterprise.deploy.spi.Target;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.cli.AbstractCommand;
import org.apache.geronimo.deployment.cli.ServerConnection;

public class CommandListTargets
extends AbstractCommand {
    public CommandListTargets() {
        super("list-targets", "2. Other Commands", "", "Lists the targets known to the server you've connected to.\nIn the case of Geronimo, each configuration store is a separate target.  Geronimo does not yet support clusters as targets.");
    }

    public void execute(PrintWriter out, ServerConnection connection, String[] args) throws DeploymentException {
        if (!connection.isOnline()) {
            throw new DeploymentException("This command cannot be run unless connecting to a running server.  Specify --url if server is not running on the default port on localhost.");
        }
        Target[] list = connection.getDeploymentManager().getTargets();
        out.println("Available Targets:");
        for (int i = 0; i < list.length; ++i) {
            Target target = list[i];
            out.println("  " + target.getName());
        }
    }
}

