/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.cli;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import javax.enterprise.deploy.shared.factories.DeploymentFactoryManager;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import javax.enterprise.deploy.spi.factories.DeploymentFactory;
import javax.management.ObjectName;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.cli.DeployUtils;
import org.apache.geronimo.deployment.cli.DeploymentSyntaxException;
import org.apache.geronimo.deployment.plugin.factories.AuthenticationFailedException;
import org.apache.geronimo.deployment.plugin.factories.DeploymentFactoryImpl;
import org.apache.geronimo.deployment.plugin.jmx.JMXDeploymentManager;
import org.apache.geronimo.system.main.CommandLine;
import org.apache.geronimo.system.main.CommandLineManifest;

public class ServerConnection {
    private static final Map OPTION_HELP = new LinkedHashMap(4);
    private static final String DEFAULT_URI = "deployer:geronimo:jmx:rmi://localhost/jndi/rmi:/JMXConnector";
    private DeploymentManager manager;
    private KernelWrapper kernel;
    private PrintWriter out;
    private BufferedReader in;

    public static Map getOptionHelp() {
        return OPTION_HELP;
    }

    public ServerConnection(String[] args, boolean forceLocal, PrintWriter out, BufferedReader in) throws DeploymentException {
        String uri = null;
        String driver = null;
        String user = null;
        String password = null;
        JMXDeploymentManager.CommandContext commandContext = new JMXDeploymentManager.CommandContext();
        this.out = out;
        this.in = in;
        for (int i = 0; i < args.length; ++i) {
            String value;
            String arg = args[i];
            if (arg.equals("--uri") || arg.equals("--url")) {
                if (uri != null) {
                    throw new DeploymentSyntaxException("Cannot specify more than one URI");
                }
                if (i >= args.length - 1) {
                    throw new DeploymentSyntaxException("Must specify a URI (--uri deployer:...)");
                }
                uri = args[++i];
                continue;
            }
            if (arg.equals("--driver")) {
                if (driver != null) {
                    throw new DeploymentSyntaxException("Cannot specify more than one driver");
                }
                if (i >= args.length - 1) {
                    throw new DeploymentSyntaxException("Must specify a driver JAR (--driver jarfile)");
                }
                driver = args[++i];
                continue;
            }
            if (arg.equals("--user")) {
                if (user != null) {
                    throw new DeploymentSyntaxException("Cannot specify more than one user name");
                }
                if (i >= args.length - 1) {
                    throw new DeploymentSyntaxException("Must specify a username (--user username)");
                }
                user = args[++i];
                continue;
            }
            if (arg.equals("--password")) {
                if (password != null) {
                    throw new DeploymentSyntaxException("Cannot specify more than one password");
                }
                if (i >= args.length - 1) {
                    throw new DeploymentSyntaxException("Must specify a password (--password password)");
                }
                password = args[++i];
                continue;
            }
            if (arg.equals("--verbose")) {
                if ((value = args[++i]).equals("true")) {
                    commandContext.setVerbose(true);
                    continue;
                }
                if (value.equals("false")) {
                    commandContext.setVerbose(false);
                    continue;
                }
                throw new DeploymentSyntaxException("--quiet must be either true or false.");
            }
            if (arg.equals("--syserr")) {
                if ((value = args[++i]).equals("true")) {
                    commandContext.setLogErrors(true);
                    continue;
                }
                if (value.equals("false")) {
                    commandContext.setLogErrors(false);
                    continue;
                }
                throw new DeploymentSyntaxException("--syserr must be either true or false.");
            }
            throw new DeploymentException("Invalid option " + arg);
        }
        if (driver != null && uri == null) {
            throw new DeploymentSyntaxException("A custom driver requires a custom URI");
        }
        if (forceLocal && (uri != null || driver != null || user != null || password != null)) {
            throw new DeploymentSyntaxException("This command does not use normal server connectivity.  No standard options are allowed.");
        }
        if (!forceLocal) {
            this.tryToConnect(uri, commandContext, driver, user, password, true);
            if (this.manager == null) {
                this.initializeKernel();
            }
        } else {
            this.initializeKernel();
        }
    }

    private void initializeKernel() throws DeploymentException {
        if (this.kernel != null) {
            throw new IllegalStateException("Kernel is already running!");
        }
        this.kernel = new KernelWrapper();
        this.kernel.start();
    }

    public void close() throws DeploymentException {
        if (this.manager != null) {
            this.manager.release();
        }
        if (this.kernel != null) {
            this.kernel.stop();
        }
    }

    private void tryToConnect(String uri, JMXDeploymentManager.CommandContext commandContext, String driver, String user, String password, boolean authPrompt) throws DeploymentException {
        block7: {
            DeploymentFactoryManager mgr = DeploymentFactoryManager.getInstance();
            if (driver != null) {
                this.loadDriver(driver, mgr);
            } else {
                mgr.registerDeploymentFactory((DeploymentFactory)new DeploymentFactoryImpl());
            }
            try {
                this.manager = mgr.getDeploymentManager(uri == null ? DEFAULT_URI : uri, user, password);
            }
            catch (AuthenticationFailedException e) {
                if (authPrompt && (user == null || password == null)) {
                    this.doAuthPromptAndRetry(uri, commandContext, user, password);
                }
                throw new DeploymentException("Login Failed");
            }
            catch (DeploymentManagerCreationException e) {
                if (uri == null) break block7;
                throw new DeploymentException("Unable to connect to server at " + uri + " -- " + e.getMessage());
            }
        }
        if (this.manager instanceof JMXDeploymentManager) {
            JMXDeploymentManager deploymentManager = (JMXDeploymentManager)this.manager;
            deploymentManager.setCommandContext(commandContext);
        }
    }

    private void loadDriver(String driver, DeploymentFactoryManager mgr) throws DeploymentException {
        File file = new File(driver);
        if (!(file.exists() && file.canRead() && DeployUtils.isJarFile(file))) {
            throw new DeploymentSyntaxException("Driver '" + file.getAbsolutePath() + "' is not a readable JAR file");
        }
        String className = null;
        try {
            JarFile jar = new JarFile(file);
            className = jar.getManifest().getMainAttributes().getValue("J2EE-DeploymentFactory-Implementation-Class");
            if (className == null) {
                throw new DeploymentException("The driver JAR " + file.getAbsolutePath() + " does not specify a J2EE-DeploymentFactory-Implementation-Class; cannot load driver.");
            }
            jar.close();
            DeploymentFactory factory = (DeploymentFactory)Class.forName(className).newInstance();
            mgr.registerDeploymentFactory(factory);
        }
        catch (DeploymentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DeploymentSyntaxException("Unable to load driver class " + className + " from JAR " + file.getAbsolutePath(), e);
        }
    }

    private void doAuthPromptAndRetry(String uri, JMXDeploymentManager.CommandContext commandContext, String user, String password) throws DeploymentException {
        try {
            if (user == null) {
                this.out.print("Username: ");
                this.out.flush();
                user = this.in.readLine();
            }
            if (password == null) {
                password = new PasswordPrompt("Password: ", this.out).getPassword(this.in);
            }
        }
        catch (IOException e) {
            throw new DeploymentException("Unable to prompt for login", (Throwable)e);
        }
        this.tryToConnect(uri, commandContext, null, user, password, false);
    }

    public DeploymentManager getDeploymentManager() {
        return this.manager;
    }

    public boolean isOnline() {
        return this.manager != null;
    }

    public Object invokeOfflineDeployer(Object[] args, String[] argTypes) throws DeploymentException {
        if (this.kernel == null) {
            throw new IllegalStateException("Cannot attempt to package when no local kernel is available");
        }
        return this.kernel.invoke(args, argTypes);
    }

    static {
        OPTION_HELP.put("--uri", "A URI to contact the server.  The server must be running for this to work.  If not specified, the deployer default to operating on a Geronimo server running on the standard port on localhost, or if nothing is available there, then the Geronimo server installation that the deployer JAR is part of.\nA URI to connect to Geronimo has the form: deployer:geronimo:jmx:rmi://localhost/jndi/rmi:/JMXConnector");
        OPTION_HELP.put("--driver", "If you want to use this tool with a server other than Geronimo, then you must provide the path to its driver JAR.  Currently, manifest Class-Path entries in that JAR are ignored.");
        OPTION_HELP.put("--user", "If the deployment operation requires authentication, then you can specify the username to use to connect.  If no password is specified, the deployer will attempt to connect to the server with no password, and if that fails, will prompt you for a password.");
        OPTION_HELP.put("--password", "Specifies a password to use to authenticate to the server.");
        OPTION_HELP.put("--syserr", "Log errors to syserr. Can be either true or false. The default value is false.");
        OPTION_HELP.put("--verbose", "Verbose execution mode. Can be either true or false. The default value is false.");
    }

    public static class PasswordPrompt
    implements Runnable {
        private volatile boolean done = false;
        private String prompt;
        private PrintWriter out;

        public PasswordPrompt(String prompt, PrintWriter out) {
            this.prompt = prompt;
            this.out = out;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            int priority = Thread.currentThread().getPriority();
            try {
                Thread.currentThread().setPriority(10);
                String fullPrompt = "\r" + this.prompt + "          " + "\r" + this.prompt;
                StringBuffer clearline = new StringBuffer();
                clearline.append('\r');
                for (int i = this.prompt.length() + 10; i >= 0; --i) {
                    clearline.append(' ');
                }
                while (!this.done) {
                    this.out.print(fullPrompt);
                    this.out.flush();
                    Thread.sleep(1L);
                }
                this.out.print(clearline.toString());
                this.out.flush();
                this.out.println();
                this.out.flush();
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                Thread.currentThread().setPriority(priority);
            }
            this.prompt = null;
            this.out = null;
        }

        public String getPassword(BufferedReader in) throws IOException {
            Thread t = new Thread((Runnable)this, "Password hiding thread");
            t.start();
            String password = in.readLine();
            this.done = true;
            try {
                t.join();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            return password;
        }
    }

    private static class KernelWrapper
    extends CommandLine {
        private ObjectName mainGbean;
        private String mainMethod;
        private List configurations;

        public KernelWrapper() {
            CommandLineManifest entries = CommandLineManifest.getManifestEntries();
            this.configurations = entries.getConfigurations();
            this.mainGbean = entries.getMainGBean();
            this.mainMethod = entries.getMainMethod();
        }

        public Object invoke(Object[] args, String[] argTypes) throws DeploymentException {
            try {
                return this.getKernel().invoke(this.mainGbean, this.mainMethod, args, argTypes);
            }
            catch (Exception e) {
                throw new DeploymentException("Unable to connect to local deployer service", (Throwable)e);
            }
        }

        public void start() throws DeploymentException {
            try {
                super.startKernel(this.configurations);
            }
            catch (Exception e) {
                throw new DeploymentException("Unable to start local kernel", (Throwable)e);
            }
        }

        public void stop() throws DeploymentException {
            try {
                super.stopKernel();
            }
            catch (Exception e) {
                throw new DeploymentException("Unable to stop local kernel", (Throwable)e);
            }
        }
    }
}

