/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.cli;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringReader;
import org.apache.geronimo.common.DeploymentException;

public class DeployUtils {
    public static String reformat(String source, int indent, int endCol) {
        StringBuffer buf = new StringBuffer((int)((double)source.length() * 1.1));
        String prefix = indent == 0 ? "" : DeployUtils.buildIndent(indent);
        try {
            String line;
            BufferedReader in = new BufferedReader(new StringReader(source));
            block2: while ((line = in.readLine()) != null) {
                if (buf.length() > 0) {
                    buf.append('\n');
                }
                while (line.length() > 0) {
                    line = prefix + line;
                    if (line.length() > endCol) {
                        int pos = line.lastIndexOf(32, endCol);
                        if (pos < indent && (pos = line.indexOf(32, endCol)) < indent) {
                            pos = line.length();
                        }
                        buf.append(line.substring(0, pos)).append('\n');
                        if (pos >= line.length() - 1) continue block2;
                        line = line.substring(pos + 1);
                        continue;
                    }
                    buf.append(line).append("\n");
                    continue block2;
                }
            }
        }
        catch (IOException e) {
            throw new AssertionError((Object)"This should be impossible");
        }
        return buf.toString();
    }

    private static String buildIndent(int indent) {
        StringBuffer buf = new StringBuffer(indent);
        for (int i = 0; i < indent; ++i) {
            buf.append(' ');
        }
        return buf.toString();
    }

    public static boolean isJarFile(File file) throws DeploymentException {
        if (file.isDirectory()) {
            return false;
        }
        if (!file.canRead()) {
            throw new DeploymentException("Cannot read file " + file.getAbsolutePath());
        }
        if (file.length() < 4L) {
            return false;
        }
        try {
            DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
            int test = in.readInt();
            in.close();
            return test == 1347093252;
        }
        catch (IOException e) {
            throw new DeploymentException("Cannot read from file " + file.getAbsolutePath(), (Throwable)e);
        }
    }

    public static void main(String[] args) {
        String msg = "/home/ammulder/cvs/geronimo/modules/security/target/geronimo-security-1.0-SNAPSHOT.jar does not specify a J2EE-DeploymentFactory-Implementation-Class; cannot load driver.";
        System.out.println(DeployUtils.reformat("Error: " + msg, 4, 72));
    }
}

