/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.cli;

import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.TargetException;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.cli.AbstractCommand;
import org.apache.geronimo.deployment.cli.DeployUtils;
import org.apache.geronimo.deployment.cli.DeploymentSyntaxException;
import org.apache.geronimo.deployment.cli.ServerConnection;

public class CommandRedeploy
extends AbstractCommand {
    public CommandRedeploy() {
        super("redeploy", "1. Common Commands", "[module] [plan] [ModuleID|TargetModuleID+]", "A shortcut to undeploy a module from one or more servers, then deploy a new version.  This is not a smooth cutover -- some client requests may be rejected while the redeploy takes place.\nNormally both a module and plan are passed to the deployer. Sometimes the module contains a plan, or requires no plan, in which case the plan may be omitted.  Sometimes the plan references a module already deployed in the Geronimo server environment, in which case a module does not need to be provided.\nIf more than one TargetModuleID is provided, all TargetModuleIDs must refer to the same module (just running on different targets).\nRegardless of whether the old module was running or not, the new module will be started (if the server is running) or marked to start (if the server is not running).\nNote: To specify a TargetModuleID, use the form TargetName|ModuleName");
    }

    public void execute(PrintWriter out, ServerConnection connection, String[] args) throws DeploymentException {
        if (!connection.isOnline()) {
            throw new DeploymentException("This command cannot be run unless connecting to a running server.  Specify --url if server is not running on the default port on localhost.");
        }
        if (args.length < 2) {
            throw new DeploymentSyntaxException("Must specify a module or plan (or both) and one or more module IDs to replace");
        }
        DeploymentManager mgr = connection.getDeploymentManager();
        Target[] allTargets = mgr.getTargets();
        TargetModuleID[] allModules = new TargetModuleID[]{};
        try {
            allModules = mgr.getAvailableModules(null, allTargets);
        }
        catch (TargetException e) {
            throw new DeploymentException("Unable to load modules from server", (Throwable)e);
        }
        ArrayList modules = new ArrayList();
        File module = null;
        File plan = null;
        File test = new File(args[0]);
        if (!test.exists()) {
            throw new DeploymentSyntaxException("Must specify a module or plan (or both) and one or more module IDs to replace");
        }
        if (!test.canRead()) {
            throw new DeploymentException("Cannot read file " + test.getAbsolutePath());
        }
        if (DeployUtils.isJarFile(test) || test.isDirectory()) {
            if (module != null) {
                throw new DeploymentSyntaxException("Module and plan cannot both be JAR files or directories!");
            }
            module = test;
        } else {
            if (plan != null) {
                throw new DeploymentSyntaxException("Module or plan must be a JAR file or directory!");
            }
            plan = test;
        }
        test = new File(args[1]);
        if (test.exists() && test.canRead()) {
            if (DeployUtils.isJarFile(test) || test.isDirectory()) {
                if (module != null) {
                    throw new DeploymentSyntaxException("Module and plan cannot both be JAR files or directories!");
                }
                module = test;
            } else {
                if (plan != null) {
                    throw new DeploymentSyntaxException("Module or plan must be a JAR file or directory!");
                }
                plan = test;
            }
        } else {
            modules.addAll(CommandRedeploy.identifyTargetModuleIDs(allModules, args[1]));
        }
        for (int i = 2; i < args.length; ++i) {
            modules.addAll(CommandRedeploy.identifyTargetModuleIDs(allModules, args[i]));
        }
        if (module != null) {
            module = module.getAbsoluteFile();
        }
        if (plan != null) {
            plan = plan.getAbsoluteFile();
        }
        TargetModuleID[] ids = modules.toArray(new TargetModuleID[modules.size()]);
        boolean multiple = CommandRedeploy.isMultipleTargets(ids);
        ProgressObject po = mgr.redeploy(ids, module, plan);
        CommandRedeploy.waitForProgress(out, po);
        TargetModuleID[] done = po.getResultTargetModuleIDs();
        for (int i = 0; i < done.length; ++i) {
            TargetModuleID id = done[i];
            out.println(DeployUtils.reformat("Redeployed " + id.getModuleID() + (multiple ? " on " + id.getTarget().getName() : ""), 4, 72));
        }
        if (po.getDeploymentStatus().isFailed()) {
            throw new DeploymentException("Operation failed: " + po.getDeploymentStatus().getMessage());
        }
    }
}

