/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.cli;

import java.io.PrintWriter;
import java.util.ArrayList;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.TargetException;
import org.apache.geronimo.common.DeploymentException;
import org.apache.geronimo.deployment.cli.AbstractCommand;
import org.apache.geronimo.deployment.cli.DeploymentSyntaxException;
import org.apache.geronimo.deployment.cli.ServerConnection;

public class CommandListModules
extends AbstractCommand {
    public CommandListModules() {
        super("list-modules", "2. Other Commands", "[--all|--started|--stopped] [target*]", "Lists the modules available on the specified targets.  If --started or --stopped is specified, only started or stopped modules will be listed; otherwise all modules will be listed.  If no targets are specified, then modules on all targets will be listed; otherwise only modules on the specified targets.");
    }

    public void execute(PrintWriter out, ServerConnection connection, String[] args) throws DeploymentException {
        TargetModuleID[] results;
        if (!connection.isOnline()) {
            throw new DeploymentException("This command cannot be run unless connecting to a running server.  Specify --url if server is not running on the default port on localhost.");
        }
        ArrayList<String> targets = new ArrayList<String>();
        Boolean started = null;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.startsWith("--")) {
                if (arg.equals("--all")) {
                    if (started == null) continue;
                    throw new DeploymentSyntaxException("Cannot specify more than one of --all, --started, --stopped");
                }
                if (arg.equals("--started")) {
                    if (started != null) {
                        throw new DeploymentSyntaxException("Cannot specify more than one of --all, --started, --stopped");
                    }
                    started = Boolean.TRUE;
                    continue;
                }
                if (arg.equals("--stopped")) {
                    if (started != null) {
                        throw new DeploymentSyntaxException("Cannot specify more than one of --all, --started, --stopped");
                    }
                    started = Boolean.FALSE;
                    continue;
                }
                throw new DeploymentSyntaxException("Unrecognized option '" + arg + "'");
            }
            targets.add(arg);
        }
        DeploymentManager mgr = connection.getDeploymentManager();
        Target[] tlist = CommandListModules.identifyTargets(targets, mgr);
        if (tlist.length == 0) {
            tlist = mgr.getTargets();
        }
        try {
            results = started == null ? mgr.getAvailableModules(null, tlist) : (started.booleanValue() ? mgr.getRunningModules(null, tlist) : mgr.getNonRunningModules(null, tlist));
        }
        catch (TargetException e) {
            throw new DeploymentException("Unable to query modules", (Throwable)e);
        }
        catch (IllegalStateException e) {
            throw new DeploymentSyntaxException(e.getMessage());
        }
        if (results == null) {
            results = new TargetModuleID[]{};
        }
        out.println("Found " + results.length + " module" + (results.length != 1 ? "s" : ""));
        for (int i = 0; i < results.length; ++i) {
            TargetModuleID result = results[i];
            out.println("    " + result.getModuleID() + (tlist.length > 1 ? " on " + result.getTarget().getName() : ""));
        }
    }
}

