/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment;

import java.io.File;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.geronimo.deployment.service.ServiceConfigBuilder;
import org.apache.geronimo.deployment.util.DeploymentUtil;
import org.apache.geronimo.deployment.xbeans.ConfigurationDocument;
import org.apache.geronimo.deployment.xbeans.ConfigurationType;
import org.apache.geronimo.kernel.config.ConfigurationData;
import org.apache.geronimo.kernel.repository.Repository;
import org.apache.geronimo.system.configuration.ExecutableConfigurationUtil;
import org.apache.geronimo.system.configuration.LocalConfigStore;
import org.apache.geronimo.system.main.CommandLineManifest;
import org.apache.geronimo.system.repository.ReadOnlyRepository;

public class Bootstrap {
    private String deployerJar;
    private String storeDir;
    private String repositoryDir;
    private String deployerSystemPlan;
    private String j2eeDeployerPlan;
    private String deployerClassPath;
    private String deployerEndorsedDirs;
    private String deployerGBean;
    private String deploymentFactory;

    public String getDeployerJar() {
        return this.deployerJar;
    }

    public void setDeployerJar(String deployerJar) {
        this.deployerJar = deployerJar;
    }

    public String getStoreDir() {
        return this.storeDir;
    }

    public void setStoreDir(String storeDir) {
        this.storeDir = storeDir;
    }

    public String getRepositoryDir() {
        return this.repositoryDir;
    }

    public void setRepositoryDir(String repositoryDir) {
        this.repositoryDir = repositoryDir;
    }

    public String getDeployerSystemPlan() {
        return this.deployerSystemPlan;
    }

    public void setDeployerSystemPlan(String deployerSystemPlan) {
        this.deployerSystemPlan = deployerSystemPlan;
    }

    public String getJ2eeDeployerPlan() {
        return this.j2eeDeployerPlan;
    }

    public void setJ2eeDeployerPlan(String j2eeDeployerPlan) {
        this.j2eeDeployerPlan = j2eeDeployerPlan;
    }

    public String getDeployerClassPath() {
        return this.deployerClassPath;
    }

    public void setDeployerClassPath(String deployerClassPath) {
        this.deployerClassPath = deployerClassPath;
    }

    public String getDeployerEndorsedDirs() {
        return this.deployerEndorsedDirs;
    }

    public void setDeployerEndorsedDirs(String deployerEndorsedDirs) {
        this.deployerEndorsedDirs = deployerEndorsedDirs;
    }

    public String getDeployerGBean() {
        return this.deployerGBean;
    }

    public void setDeployerGBean(String deployerGBean) {
        this.deployerGBean = deployerGBean;
    }

    public String getDeploymentFactory() {
        return this.deploymentFactory;
    }

    public void setDeploymentFactory(String deploymentFactory) {
        this.deploymentFactory = deploymentFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bootstrap() throws Exception {
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(Bootstrap.class.getClassLoader());
            ConfigurationType deployerSystemConfig = ConfigurationDocument.Factory.parse((File)new File(this.deployerSystemPlan)).getConfiguration();
            ConfigurationType j2eeDeployerConfig = ConfigurationDocument.Factory.parse((File)new File(this.j2eeDeployerPlan)).getConfiguration();
            LocalConfigStore configStore = new LocalConfigStore(new File(this.storeDir));
            ReadOnlyRepository repository = new ReadOnlyRepository(new File(this.repositoryDir));
            ServiceConfigBuilder builder = new ServiceConfigBuilder(null, (Repository)repository);
            Manifest manifest = new Manifest();
            Attributes mainAttributes = manifest.getMainAttributes();
            mainAttributes.putValue(Attributes.Name.MANIFEST_VERSION.toString(), "1.0");
            mainAttributes.putValue(Attributes.Name.MAIN_CLASS.toString(), "org.apache.geronimo.deployment.cli.DeployTool");
            mainAttributes.putValue(Attributes.Name.CLASS_PATH.toString(), this.deployerClassPath);
            mainAttributes.putValue(CommandLineManifest.MAIN_GBEAN.toString(), this.deployerGBean);
            mainAttributes.putValue(CommandLineManifest.MAIN_METHOD.toString(), "deploy");
            mainAttributes.putValue(CommandLineManifest.CONFIGURATIONS.toString(), j2eeDeployerConfig.getConfigId());
            mainAttributes.putValue(CommandLineManifest.ENDORSED_DIRS.toString(), this.deployerEndorsedDirs);
            mainAttributes.putValue("J2EE-DeploymentFactory-Implementation-Class", this.deploymentFactory);
            File configurationDir = null;
            try {
                configurationDir = configStore.createNewConfigurationDir();
                ConfigurationData configurationData = builder.buildConfiguration((Object)deployerSystemConfig, null, configurationDir);
                ExecutableConfigurationUtil.createExecutableConfiguration((ConfigurationData)configurationData, (Manifest)manifest, (File)configurationDir, (File)new File(this.deployerJar));
                configStore.install(configurationData, configurationDir);
            }
            catch (Throwable e) {
                DeploymentUtil.recursiveDelete((File)configurationDir);
                if (e instanceof Error) {
                    throw (Error)e;
                }
                if (e instanceof Exception) {
                    throw (Exception)e;
                }
                throw new Error(e);
            }
            String domain = deployerSystemConfig.getDomain();
            String server = deployerSystemConfig.getServer();
            try {
                configurationDir = configStore.createNewConfigurationDir();
                ConfigurationData configurationData = builder.buildConfiguration(j2eeDeployerConfig, domain, server, configurationDir);
                configStore.install(configurationData, configurationDir);
            }
            catch (Throwable e) {
                DeploymentUtil.recursiveDelete((File)configurationDir);
                if (e instanceof Error) {
                    throw (Error)e;
                }
                if (e instanceof Exception) {
                    throw (Exception)e;
                }
                throw new Error(e);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCL);
        }
    }
}

