/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.plugin.factories;

import java.io.IOException;
import java.util.HashMap;
import javax.enterprise.deploy.shared.factories.DeploymentFactoryManager;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import javax.enterprise.deploy.spi.factories.DeploymentFactory;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.geronimo.deployment.plugin.DisconnectedDeploymentManager;
import org.apache.geronimo.deployment.plugin.factories.AuthenticationFailedException;
import org.apache.geronimo.deployment.plugin.jmx.LocalDeploymentManager;
import org.apache.geronimo.deployment.plugin.jmx.RemoteDeploymentManager;
import org.apache.geronimo.kernel.KernelRegistry;

public class DeploymentFactoryImpl
implements DeploymentFactory {
    public static final String URI_PREFIX = "deployer:geronimo:";
    private static final int DEFAULT_PORT = 1099;

    public String getDisplayName() {
        return "Apache Geronimo";
    }

    public String getProductVersion() {
        return "1.0";
    }

    public boolean handlesURI(String uri) {
        return this.parseURI(uri) != null;
    }

    private ConnectParams parseURI(String uri) {
        if (!(uri = uri.trim()).startsWith(URI_PREFIX)) {
            return null;
        }
        int pos = (uri = uri.substring(URI_PREFIX.length())).indexOf(":");
        String protocol = pos == -1 ? uri : uri.substring(0, pos);
        String string = uri = pos == -1 ? "" : uri.substring(pos + 1);
        if (protocol.equals("jmx")) {
            if (!uri.startsWith("//")) {
                return new ConnectParams(protocol, "localhost", 1099);
            }
            pos = (uri = uri.substring(2)).indexOf(58);
            if (pos == -1) {
                return new ConnectParams(protocol, uri.equals("") ? "localhost" : uri, 1099);
            }
            if (uri.indexOf(47, pos + 1) > -1) {
                return null;
            }
            if (uri.indexOf(58, pos + 1) > -1) {
                return null;
            }
            String host = uri.substring(0, pos);
            String port = uri.substring(pos + 1);
            try {
                return new ConnectParams(protocol, host.equals("") ? "localhost" : host, Integer.parseInt(port));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        if (protocol.equals("inVM")) {
            if (uri.startsWith("//")) {
                String kernel = uri.substring(2);
                return new ConnectParams(protocol, kernel, -1);
            }
            return new ConnectParams(protocol, KernelRegistry.getSingleKernel() == null ? null : KernelRegistry.getSingleKernel().getKernelName(), -1);
        }
        return null;
    }

    public DeploymentManager getDisconnectedDeploymentManager(String uri) throws DeploymentManagerCreationException {
        if (!this.handlesURI(uri)) {
            return null;
        }
        return new DisconnectedDeploymentManager();
    }

    public DeploymentManager getDeploymentManager(String uri, String username, String password) throws DeploymentManagerCreationException {
        ConnectParams params = this.parseURI(uri);
        if (params == null) {
            return null;
        }
        try {
            if (params.getProtocol().equals("jmx")) {
                HashMap<String, String[]> environment = new HashMap<String, String[]>();
                String[] credentials = new String[]{username, password};
                environment.put("jmx.remote.credentials", credentials);
                try {
                    JMXServiceURL address = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://" + params.getHost() + ":" + params.getPort() + "/JMXConnector");
                    JMXConnector jmxConnector = JMXConnectorFactory.connect(address, environment);
                    RemoteDeploymentManager manager = new RemoteDeploymentManager(jmxConnector, params.getHost());
                    if (!manager.isSameMachine()) {
                        manager.setAuthentication(username, password);
                    }
                    return manager;
                }
                catch (IOException e) {
                    throw (DeploymentManagerCreationException)new DeploymentManagerCreationException(e.getMessage()).initCause((Throwable)e);
                }
                catch (SecurityException e) {
                    throw (AuthenticationFailedException)((Object)new AuthenticationFailedException("Invalid login.").initCause(e));
                }
            }
            if (params.getProtocol().equals("inVM")) {
                return new LocalDeploymentManager(KernelRegistry.getKernel((String)params.getHost()));
            }
            throw new DeploymentManagerCreationException("Invalid URI: " + uri);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw e;
        }
        catch (Error e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static void main(String[] args) {
        System.out.println("Parsed: " + new DeploymentFactoryImpl().parseURI("deployer:geronimo:inVM"));
    }

    static {
        DeploymentFactoryManager manager = DeploymentFactoryManager.getInstance();
        manager.registerDeploymentFactory((DeploymentFactory)new DeploymentFactoryImpl());
    }

    private static final class ConnectParams {
        private String protocol;
        private String host;
        private int port;

        public ConnectParams(String protocol, String host, int port) {
            this.protocol = protocol;
            this.host = host;
            this.port = port;
        }

        public String getProtocol() {
            return this.protocol;
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        public String toString() {
            return this.protocol + " / " + this.host + " / " + this.port;
        }
    }
}

