/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.deployment.plugin;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.enterprise.deploy.model.DDBeanRoot;
import javax.enterprise.deploy.model.DeployableObject;
import javax.enterprise.deploy.spi.DConfigBeanRoot;
import javax.enterprise.deploy.spi.DeploymentConfiguration;
import javax.enterprise.deploy.spi.exceptions.BeanNotFoundException;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import org.apache.geronimo.deployment.plugin.DConfigBeanRootSupport;
import org.apache.xmlbeans.XmlException;

public abstract class DeploymentConfigurationSupport
implements DeploymentConfiguration {
    private final DeployableObject deployable;
    protected DConfigBeanRootSupport dConfigRoot;

    public DeploymentConfigurationSupport(DeployableObject deployable, DConfigBeanRootSupport dConfigRoot) {
        this.deployable = deployable;
        this.dConfigRoot = dConfigRoot;
    }

    public DeployableObject getDeployableObject() {
        return this.deployable;
    }

    public DConfigBeanRoot getDConfigBeanRoot(DDBeanRoot bean) throws ConfigurationException {
        if (this.getDeployableObject().getDDBeanRoot().equals(bean)) {
            return this.dConfigRoot;
        }
        return null;
    }

    public void removeDConfigBean(DConfigBeanRoot bean) throws BeanNotFoundException {
    }

    public void save(OutputStream outputArchive) throws ConfigurationException {
        try {
            this.dConfigRoot.toXML(outputArchive);
            outputArchive.flush();
        }
        catch (IOException e) {
            throw (ConfigurationException)new ConfigurationException("Unable to save configuration").initCause((Throwable)e);
        }
    }

    public void restore(InputStream inputArchive) throws ConfigurationException {
        try {
            this.dConfigRoot.fromXML(inputArchive);
        }
        catch (IOException e) {
            throw (ConfigurationException)new ConfigurationException("Error reading configuration input").initCause((Throwable)e);
        }
        catch (XmlException e) {
            throw (ConfigurationException)new ConfigurationException("Error parsing configuration input").initCause((Throwable)e);
        }
    }

    public void saveDConfigBean(OutputStream outputArchive, DConfigBeanRoot bean) throws ConfigurationException {
        try {
            ((DConfigBeanRootSupport)bean).toXML(outputArchive);
            outputArchive.flush();
        }
        catch (IOException e) {
            throw (ConfigurationException)new ConfigurationException("Unable to save configuration").initCause((Throwable)e);
        }
    }

    public DConfigBeanRoot restoreDConfigBean(InputStream inputArchive, DDBeanRoot bean) throws ConfigurationException {
        return null;
    }
}

