/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.pool;

import EDU.oswego.cs.dl.util.concurrent.PooledExecutor;
import EDU.oswego.cs.dl.util.concurrent.ThreadFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.j2ee.statistics.BoundedRangeStatistic;
import javax.management.j2ee.statistics.CountStatistic;
import javax.management.j2ee.statistics.Statistic;
import javax.management.j2ee.statistics.Stats;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.management.J2EEManagedObject;
import org.apache.geronimo.management.StatisticsProvider;
import org.apache.geronimo.management.geronimo.stats.ThreadPoolStats;
import org.apache.geronimo.management.stats.BoundedRangeImpl;
import org.apache.geronimo.management.stats.CountStatisticImpl;
import org.apache.geronimo.management.stats.StatsImpl;
import org.apache.geronimo.pool.GeronimoExecutor;

public class ThreadPool
implements GeronimoExecutor,
GBeanLifecycle,
J2EEManagedObject,
StatisticsProvider {
    private PooledExecutor executor;
    private ClassLoader classLoader;
    private ObjectName objectName;
    private boolean waitWhenBlocked;
    private boolean statsActive = true;
    private PoolStatsImpl stats = new PoolStatsImpl();
    private Map clients = new HashMap();
    public static final GBeanInfo GBEAN_INFO;

    public ThreadPool(int poolSize, String poolName, long keepAliveTime, ClassLoader classLoader, String objectName) {
        PooledExecutor p = new PooledExecutor(poolSize);
        p.abortWhenBlocked();
        p.setKeepAliveTime(keepAliveTime);
        p.setMinimumPoolSize(poolSize);
        p.setThreadFactory((ThreadFactory)new ThreadPoolThreadFactory(poolName, classLoader));
        try {
            this.objectName = ObjectName.getInstance(objectName);
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalStateException("Bad object name injected: " + e.getMessage());
        }
        this.executor = p;
        this.classLoader = classLoader;
    }

    public String getName() {
        return this.objectName.getKeyProperty("name");
    }

    public String getObjectName() {
        return this.objectName.getCanonicalName();
    }

    public boolean isEventProvider() {
        return true;
    }

    public boolean isStateManageable() {
        return true;
    }

    public boolean isStatisticsProvider() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stats getStats() {
        this.stats.threadsInUse.setLowerBound(0L);
        this.stats.threadsInUse.setUpperBound((long)this.executor.getMaximumPoolSize());
        int inUse = this.executor.getPoolSize();
        this.stats.threadsInUse.setCurrent((long)inUse);
        if ((long)inUse < this.stats.threadsInUse.getLowWaterMark()) {
            this.stats.threadsInUse.setLowWaterMark((long)inUse);
        }
        if ((long)inUse > this.stats.threadsInUse.getHighWaterMark()) {
            this.stats.threadsInUse.setHighWaterMark((long)inUse);
        }
        if (this.statsActive) {
            ThreadPool threadPool = this;
            synchronized (threadPool) {
                this.stats.prepareConsumers(this.clients);
            }
        } else {
            this.stats.prepareConsumers(Collections.EMPTY_MAP);
        }
        return this.stats;
    }

    public int getPoolSize() {
        return this.executor.getMaximumPoolSize();
    }

    public void execute(Runnable command) throws InterruptedException {
        this.execute("Unknown", command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(final String consumerName, final Runnable runnable) throws InterruptedException {
        PooledExecutor p;
        Runnable command = this.statsActive ? new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                ThreadPool.this.startWork(consumerName);
                try {
                    runnable.run();
                }
                finally {
                    ThreadPool.this.finishWork(consumerName);
                }
            }
        } : runnable;
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            p = this.executor;
        }
        if (p == null) {
            throw new IllegalStateException("ThreadPool has been stopped");
        }
        ContextClassLoaderRunnable task = new ContextClassLoaderRunnable(command, this.classLoader);
        p.execute((Runnable)task);
    }

    private synchronized void startWork(String consumerName) {
        Integer test = (Integer)this.clients.get(consumerName);
        if (test == null) {
            this.clients.put(consumerName, new Integer(1));
        } else {
            this.clients.put(consumerName, new Integer(test + 1));
        }
    }

    private synchronized void finishWork(String consumerName) {
        Integer test = (Integer)this.clients.get(consumerName);
        if (test == 1) {
            this.clients.remove(consumerName);
        } else {
            this.clients.put(consumerName, new Integer(test - 1));
        }
    }

    public void setWaitWhenBlocked(boolean wait) {
        this.waitWhenBlocked = wait;
        if (wait) {
            this.executor.waitWhenBlocked();
        } else {
            this.executor.abortWhenBlocked();
        }
    }

    public boolean isWaitWhenBlocked() {
        return this.waitWhenBlocked;
    }

    public void doStart() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doStop() throws Exception {
        PooledExecutor p;
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            p = this.executor;
            this.executor = null;
            this.classLoader = null;
        }
        if (p != null) {
            p.shutdownNow();
        }
    }

    public void doFail() {
        try {
            this.doStop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = GBeanInfoBuilder.createStatic((Class)ThreadPool.class);
        infoFactory.addAttribute("poolSize", Integer.TYPE, true);
        infoFactory.addAttribute("poolName", String.class, true);
        infoFactory.addAttribute("keepAliveTime", Long.TYPE, true);
        infoFactory.addAttribute("waitWhenBlocked", Boolean.TYPE, true);
        infoFactory.addAttribute("objectName", String.class, false);
        infoFactory.addAttribute("classLoader", ClassLoader.class, false);
        infoFactory.addInterface(GeronimoExecutor.class);
        infoFactory.setConstructor(new String[]{"poolSize", "poolName", "keepAliveTime", "classLoader", "objectName"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }

    private static final class ContextClassLoaderRunnable
    implements Runnable {
        private Runnable task;
        private ClassLoader classLoader;

        public ContextClassLoaderRunnable(Runnable task, ClassLoader classLoader) {
            this.task = task;
            this.classLoader = classLoader;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Runnable myTask = this.task;
            ClassLoader myClassLoader = this.classLoader;
            this.task = null;
            this.classLoader = null;
            if (myClassLoader != null) {
                try {
                    myTask.run();
                }
                finally {
                    Thread.currentThread().setContextClassLoader(myClassLoader);
                }
            }
        }
    }

    private static final class ThreadPoolThreadFactory
    implements ThreadFactory {
        private final String poolName;
        private final ClassLoader classLoader;
        private int nextWorkerID = 0;

        public ThreadPoolThreadFactory(String poolName, ClassLoader classLoader) {
            this.poolName = poolName;
            this.classLoader = classLoader;
        }

        public Thread newThread(Runnable arg0) {
            Thread thread = new Thread(arg0, this.poolName + " " + this.getNextWorkerID());
            thread.setContextClassLoader(this.classLoader);
            return thread;
        }

        private synchronized int getNextWorkerID() {
            return this.nextWorkerID++;
        }
    }

    public static class PoolStatsImpl
    extends StatsImpl
    implements ThreadPoolStats {
        private BoundedRangeImpl threadsInUse = new BoundedRangeImpl("Threads In Use", "", "The number of threads in use by this thread pool");
        private Map consumers = new HashMap();

        public PoolStatsImpl() {
            this.addStat(this.threadsInUse.getName(), (Statistic)this.threadsInUse);
        }

        public BoundedRangeStatistic getThreadsInUse() {
            return this.threadsInUse;
        }

        public CountStatistic getCountForConsumer(String consumer) {
            return (CountStatistic)this.consumers.get(consumer);
        }

        public String[] getThreadConsumers() {
            return this.consumers.keySet().toArray(new String[this.consumers.size()]);
        }

        public void prepareConsumers(Map clients) {
            String client;
            HashMap<String, CountStatisticImpl> result = new HashMap<String, CountStatisticImpl>();
            Iterator it = clients.keySet().iterator();
            while (it.hasNext()) {
                client = (String)it.next();
                Integer count = (Integer)clients.get(client);
                CountStatisticImpl stat = (CountStatisticImpl)this.consumers.get(client);
                if (stat == null) {
                    stat = new CountStatisticImpl("Threads for " + client, "", "The number of threads used by the client known as '" + client + "'", (long)count.intValue());
                    this.addStat(stat.getName(), (Statistic)stat);
                } else {
                    this.consumers.remove(client);
                    stat.setCount((long)count.intValue());
                }
                result.put(client, stat);
            }
            it = this.consumers.keySet().iterator();
            while (it.hasNext()) {
                client = (String)it.next();
                this.removeStat(((CountStatisticImpl)this.consumers.get(client)).getName());
            }
            this.consumers = result;
        }
    }
}

