/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.validator;

import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.enterprise.deploy.shared.ModuleType;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.validator.ValidationContext;
import org.apache.geronimo.validator.ValidationException;
import org.apache.geronimo.validator.ValidationResult;
import org.apache.geronimo.validator.ValidationTest;
import org.apache.geronimo.validator.Validator;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlObject;

public abstract class AbstractValidator
implements Validator {
    private static final Log log = LogFactory.getLog((Class)AbstractValidator.class);
    private ValidationContext context;
    static /* synthetic */ Class class$org$apache$geronimo$validator$ValidationTest;
    static /* synthetic */ Class class$org$apache$geronimo$validator$ValidationResult;

    public abstract Class[] getTestClasses();

    public boolean initialize(PrintWriter out, String moduleName, ClassLoader loader, ModuleType type, XmlObject[] standardDD, Object[] serverDD) {
        this.context = new ValidationContext(loader, moduleName, out, serverDD, standardDD, type);
        return true;
    }

    public ValidationResult validate() {
        ValidationResult result;
        try {
            result = this.validateAllModules();
        }
        catch (ValidationException e) {
            this.context.out.println("Validator ERROR (in " + this.context.moduleName + "): validation aborted with fatal error: " + e.getMessage());
            result = ValidationResult.ABORTED;
        }
        catch (Throwable t) {
            log.error((Object)"Unexpected failure during validation", t);
            this.context.out.println("Validator ERROR (in " + this.context.moduleName + "): validation failed due to unexpected error: " + t);
            result = ValidationResult.ABORTED;
        }
        return result;
    }

    private ValidationResult validateAllModules() {
        ValidationResult result = ValidationResult.PASSED;
        Class[] classes = this.getTestClasses();
        HashMap<SchemaType, XmlObject> map = new HashMap<SchemaType, XmlObject>();
        for (int i = 0; i < this.context.standardDD.length; ++i) {
            XmlObject object = this.context.standardDD[i];
            map.put(object.schemaType(), object);
        }
        HashSet<SchemaType> missing = new HashSet<SchemaType>();
        block4: for (int i = 0; i < classes.length; ++i) {
            Class cls;
            if (!(class$org$apache$geronimo$validator$ValidationTest == null ? AbstractValidator.class$("org.apache.geronimo.validator.ValidationTest") : class$org$apache$geronimo$validator$ValidationTest).isAssignableFrom(cls = classes[i])) {
                throw new IllegalArgumentException("Class " + cls.getName() + " for Validator " + this.getClass().getName() + " is not a ValidationTest!");
            }
            try {
                Object ddRoot;
                ValidationTest test = (ValidationTest)cls.newInstance();
                SchemaType dd = test.getSchemaType();
                String xpath = test.getXpath();
                if (dd == null) {
                    ValidationResult temp = this.executeTest(cls, test, this.context);
                    if ((result = this.resolveResult(result, temp)) != ValidationResult.ABORTED) continue;
                    break;
                }
                if (xpath == null) {
                    ddRoot = map.get(dd);
                    if (ddRoot == null) {
                        if (missing.contains(dd)) continue;
                        log.info((Object)("No " + dd + " available for validation"));
                        missing.add(dd);
                        continue;
                    }
                    this.context.setCurrentStandardDD(ddRoot);
                    this.context.setCurrentNode(null);
                    ValidationResult temp = this.executeTest(cls, test, this.context);
                    result = this.resolveResult(result, temp);
                    if (result != ValidationResult.ABORTED) continue;
                    break;
                }
                ddRoot = map.get(dd);
                if (ddRoot == null) {
                    if (missing.contains(dd)) continue;
                    log.info((Object)("No " + dd + " available for validation"));
                    missing.add(dd);
                    continue;
                }
                JXPathContext ctx = JXPathContext.newContext(ddRoot);
                xpath = this.javify(xpath);
                log.debug((Object)("Looking for XPath " + xpath + " on bean " + ddRoot.getClass().getName()));
                Iterator it = ctx.iterate(xpath);
                while (it.hasNext()) {
                    this.context.setCurrentStandardDD(ddRoot);
                    this.context.setCurrentNode(it.next());
                    ValidationResult temp = this.executeTest(cls, test, this.context);
                    if ((result = this.resolveResult(result, temp)) != ValidationResult.ABORTED) continue;
                    break block4;
                }
                continue;
            }
            catch (InstantiationException e) {
                log.error((Object)("Class " + cls.getName() + " for Validator " + this.getClass().getName() + " cannot be instantiated"), (Throwable)e);
                throw new IllegalArgumentException("Class " + cls.getName() + " for Validator " + this.getClass().getName() + " cannot be instantiated");
            }
            catch (IllegalAccessException e) {
                log.error((Object)("Class " + cls.getName() + " for Validator " + this.getClass().getName() + " cannot be instantiated"), (Throwable)e);
                throw new IllegalArgumentException("Class " + cls.getName() + " for Validator " + this.getClass().getName() + " cannot be instantiated");
            }
        }
        return result;
    }

    private String javify(String xpath) {
        StringBuffer buf = new StringBuffer();
        int last = 0;
        int pos = xpath.indexOf(45);
        while (pos > -1) {
            buf.append(xpath.substring(last, pos));
            buf.append(Character.toUpperCase(xpath.charAt(pos + 1)));
            last = pos + 2;
            pos = xpath.indexOf(45, last);
        }
        buf.append(xpath.substring(last));
        return buf.toString();
    }

    private ValidationResult resolveResult(ValidationResult current, ValidationResult latest) {
        if (latest == ValidationResult.ABORTED || latest == ValidationResult.FAILED) {
            return latest;
        }
        if (latest == ValidationResult.PASSED_WITH_WARNINGS) {
            if (current == ValidationResult.FAILED) {
                return current;
            }
            return latest;
        }
        if (latest == ValidationResult.PASSED) {
            return current;
        }
        throw new IllegalArgumentException("Unexpected ValidationResult " + latest);
    }

    private ValidationResult executeTest(Class cls, ValidationTest test, ValidationContext context) {
        if (!cls.getName().equals(test.getClass().getName())) {
            throw new IllegalArgumentException("Unexpected test/class mismatch (" + cls.getName() + "<>" + test.getClass().getName() + ")");
        }
        log.debug((Object)("Executing tests on " + cls.getName()));
        ValidationResult result = ValidationResult.PASSED;
        ValidationResult temp = test.initializeTest(context);
        result = this.resolveResult(result, temp);
        if (result == ValidationResult.ABORTED) {
            return result;
        }
        if (temp == ValidationResult.FAILED) {
            return result;
        }
        Method[] ms = cls.getMethods();
        for (int i = 0; i < ms.length; ++i) {
            Method m = ms[i];
            if (!m.getName().startsWith("test") || !Modifier.isPublic(m.getModifiers()) || Modifier.isStatic(m.getModifiers()) || m.getParameterTypes().length != 0) continue;
            try {
                log.debug((Object)("Running test: " + m.getName()));
                Object o = m.invoke((Object)test, new Object[0]);
                if (!m.getReturnType().equals(class$org$apache$geronimo$validator$ValidationResult == null ? AbstractValidator.class$("org.apache.geronimo.validator.ValidationResult") : class$org$apache$geronimo$validator$ValidationResult) || (result = this.resolveResult(result, (ValidationResult)o)) != ValidationResult.ABORTED) continue;
                return result;
            }
            catch (IllegalAccessException e) {
                log.error((Object)("Cannot invoke method " + m.getName() + " on test class " + cls.getName() + " for Validator " + this.getClass().getName()), (Throwable)e);
                throw new IllegalArgumentException("Cannot invoke method " + m.getName() + " on test class " + cls.getName() + " for Validator " + this.getClass().getName());
            }
            catch (IllegalArgumentException e) {
                log.error((Object)("Cannot invoke method " + m.getName() + " on test class " + cls.getName() + " for Validator " + this.getClass().getName()), (Throwable)e);
                throw new IllegalArgumentException("Cannot invoke method " + m.getName() + " on test class " + cls.getName() + " for Validator " + this.getClass().getName());
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() instanceof RuntimeException) {
                    throw (RuntimeException)e.getTargetException();
                }
                log.error((Object)("Unexpected exception invoking method " + m.getName() + " on test class " + cls.getName() + " for Validator " + this.getClass().getName()), (Throwable)e);
                throw new ValidationException("Unexpected exception from a test method: " + e.getClass().getName());
            }
        }
        return result;
    }
}

