/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.lock;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.transaction.Synchronization;
import org.apache.geronimo.lock.InstanceLock;
import org.apache.geronimo.lock.LockDomain;
import org.apache.geronimo.lock.LockReentranceException;

public abstract class LockContext
implements Synchronization {
    protected final Set locks = new HashSet();

    public abstract void sharedLock(LockDomain var1, Object var2) throws LockReentranceException, InterruptedException;

    public abstract void exclusiveLock(LockDomain var1, Object var2) throws LockReentranceException, InterruptedException;

    public abstract void release(LockDomain var1, Object var2);

    protected synchronized void sharedLock(InstanceLock lock) throws InterruptedException {
        lock.sharedLock(this);
        this.locks.add(lock);
    }

    protected synchronized void exclusiveLock(InstanceLock lock) throws InterruptedException {
        lock.exclusiveLock(this);
        this.locks.add(lock);
    }

    protected synchronized void releaseLock(InstanceLock lock) {
        lock.release(this);
        this.locks.remove(lock);
    }

    public void beforeCompletion() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterCompletion(int status) {
        LockContext lockContext = this;
        synchronized (lockContext) {
            Iterator i = this.locks.iterator();
            while (i.hasNext()) {
                InstanceLock lock = (InstanceLock)i.next();
                lock.release(this);
            }
            this.locks.clear();
        }
    }
}

