/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.enterprise.deploy.tool;

import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import javax.enterprise.deploy.model.DDBean;
import javax.enterprise.deploy.model.DDBeanRoot;
import javax.enterprise.deploy.model.XpathListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Node;

public class DDBeanImpl
implements DDBean {
    private static final Log log = LogFactory.getLog((Class)DDBeanImpl.class);
    protected Node node;
    protected String id;
    protected DDBeanRoot root;
    protected String text;
    protected String xPath;
    protected HashMap listeners;

    DDBeanImpl() {
    }

    DDBeanImpl(Node node, String xpath) {
        this.node = node;
        this.id = node.getName();
        this.text = node.getText();
        this.xPath = xpath;
    }

    public void addXpathListener(String str, XpathListener xpathListener) {
        if (this.listeners == null) {
            this.listeners = new HashMap();
        }
        this.listeners.put(str, xpathListener);
    }

    public DDBean[] getChildBean(String str) {
        String tempXPath = this.createXPath(str);
        List nodes = this.node.selectNodes(tempXPath);
        int count = nodes.size();
        DDBean[] ddBeans = new DDBeanImpl[count];
        for (int i = 0; i < count; ++i) {
            Node node = (Node)nodes.get(i);
            ddBeans[i] = new DDBeanImpl(node, str);
        }
        return ddBeans;
    }

    public String[] getText(String str) {
        String tempXPath = this.createXPath(str);
        List nodes = this.node.selectNodes(tempXPath);
        int count = nodes.size();
        String[] text = new String[count];
        for (int i = 0; i < count; ++i) {
            Node node = (Node)nodes.get(i);
            text[i] = node.getText();
        }
        return text;
    }

    private String createXPath(String path) {
        StringTokenizer tokens = new StringTokenizer(path, "/");
        StringBuffer buffer = new StringBuffer(100);
        while (tokens.hasMoreTokens()) {
            if (buffer.length() > 0) {
                buffer.append("/");
            }
            buffer.append("*[name()='").append(tokens.nextToken()).append("']");
        }
        return buffer.toString();
    }

    public String getId() {
        return this.id;
    }

    public DDBeanRoot getRoot() {
        return this.root;
    }

    public String getText() {
        return this.text;
    }

    public String getXpath() {
        return this.xPath;
    }

    public void removeXpathListener(String str, XpathListener xpathListener) {
        if (this.listeners != null) {
            this.listeners.remove(str);
        }
    }

    public String[] getAttributeNames() {
        return new String[0];
    }

    public String getAttributeValue(String attrName) {
        return null;
    }

    public int hashCode() {
        return this.node.hashCode();
    }

    public boolean equals(Object obj) {
        try {
            return this.node.equals(((DDBeanImpl)obj).node);
        }
        catch (ClassCastException e) {
            return false;
        }
    }
}

