/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.core.service;

import java.io.ObjectStreamException;
import java.io.Serializable;
import org.apache.geronimo.core.service.Invocation;
import org.apache.geronimo.core.service.InvocationKey;
import org.apache.geronimo.core.service.StringInvocationKey;

public final class InvocationType
implements Serializable,
InvocationKey {
    private static final StringInvocationKey INVOCATION_TYPE_KEY;
    private static int MAX_ORDINAL;
    private static final InvocationType[] values;
    public static final InvocationType REMOTE;
    public static final InvocationType HOME;
    public static final InvocationType LOCAL;
    public static final InvocationType LOCALHOME;
    private final transient String name;
    private final transient boolean local;
    private final transient boolean home;
    private final int ordinal;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static InvocationType getType(Invocation invocation) {
        return (InvocationType)invocation.get(INVOCATION_TYPE_KEY);
    }

    public static void putType(Invocation invocation, InvocationType type) {
        invocation.put(INVOCATION_TYPE_KEY, type);
    }

    private InvocationType(String name, int ordinal, boolean local, boolean home) {
        if (!$assertionsDisabled && ordinal > MAX_ORDINAL) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && values[ordinal] != null) {
            throw new AssertionError();
        }
        this.name = name;
        this.local = local;
        this.home = home;
        this.ordinal = ordinal;
        InvocationType.values[ordinal] = this;
    }

    public boolean isTransient() {
        return false;
    }

    public boolean isRemoteInvocation() {
        return !this.local;
    }

    public boolean isLocalInvocation() {
        return this.local;
    }

    public boolean isHomeInvocation() {
        return this.home;
    }

    public boolean isBeanInvocation() {
        return !this.home;
    }

    public String toString() {
        return this.name;
    }

    Object readResolve() throws ObjectStreamException {
        return values[this.ordinal];
    }

    static {
        $assertionsDisabled = !InvocationType.class.desiredAssertionStatus();
        INVOCATION_TYPE_KEY = new StringInvocationKey("INVOCATION_TYPE_KEY", false);
        MAX_ORDINAL = 3;
        values = new InvocationType[MAX_ORDINAL + 1];
        REMOTE = new InvocationType("REMOTE", 0, false, false);
        HOME = new InvocationType("HOME", 1, false, true);
        LOCAL = new InvocationType("LOCAL", 2, true, false);
        LOCALHOME = new InvocationType("LOCALHOME", 3, false, false);
    }
}

