/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.console.cli.controller;

import java.io.File;
import java.io.IOException;
import java.util.jar.JarFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.console.cli.DeploymentContext;
import org.apache.geronimo.console.cli.TextController;
import org.apache.geronimo.console.cli.module.EJBJARInfo;
import org.apache.geronimo.console.cli.module.WARInfo;

public class SelectModule
extends TextController {
    private static final Log log = LogFactory.getLog((Class)SelectModule.class);

    public SelectModule(DeploymentContext context) {
        super(context);
    }

    public void execute() {
        File file;
        this.context.out.println("\nCurrent directory is " + this.context.saveDir);
        this.context.out.println("Select an EJB JAR or WAR file to load.");
        while (true) {
            String choice;
            this.context.out.print("File Name: ");
            this.context.out.flush();
            try {
                choice = this.context.in.readLine().trim();
            }
            catch (IOException e) {
                log.error((Object)"Unable to read user input", (Throwable)e);
                return;
            }
            file = new File(this.context.saveDir, choice);
            if (file.canRead() && !file.isDirectory()) break;
            this.context.out.println("ERROR: cannot read from this file.  Please try again.");
        }
        this.context.saveDir = file.getParentFile();
        if (file.getName().endsWith(".jar")) {
            this.context.moduleInfo = new EJBJARInfo(this.context);
        } else if (file.getName().endsWith(".war")) {
            this.context.moduleInfo = new WARInfo(this.context);
        } else {
            this.context.out.println("ERROR: Expecting file name to end in .jar or .war");
        }
        try {
            this.context.moduleInfo.file = file;
            this.context.moduleInfo.jarFile = new JarFile(file);
        }
        catch (IOException e) {
            this.context.out.println("ERROR: " + file + " is not a valid JAR file!");
            this.context.moduleInfo = null;
            return;
        }
        if (!this.context.moduleInfo.initialize()) {
            this.context.moduleInfo = null;
            return;
        }
    }
}

