/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.console.cli.controller;

import java.io.IOException;
import javax.enterprise.deploy.shared.factories.DeploymentFactoryManager;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.console.cli.DeploymentContext;
import org.apache.geronimo.console.cli.TextController;

public class ConnectDeploymentManager
extends TextController {
    private static final Log log = LogFactory.getLog((Class)ConnectDeploymentManager.class);
    public static final String DEFAULT_URI = "deployer:geronimo:jmx:rmi://localhost/jndi/rmi:/JMXConnector";

    public ConnectDeploymentManager(DeploymentContext context) {
        super(context);
    }

    public void execute() {
        this.context.out.println("\n\nEnter deployment server URI. Leave blank for the default URL 'deployer:geronimo:jmx:rmi://localhost/jndi/rmi:/JMXConnector'");
        this.context.out.print("URI: ");
        this.context.out.flush();
        try {
            String uri = this.context.in.readLine();
            if (uri.equals("")) {
                uri = DEFAULT_URI;
            }
            this.context.out.println("Enter an optional username");
            this.context.out.print("Username: ");
            this.context.out.flush();
            String username = this.context.in.readLine();
            if (username.equals("")) {
                username = null;
            }
            this.context.out.println("Enter an optional password");
            this.context.out.print("Password: ");
            this.context.out.flush();
            String password = this.context.in.readLine();
            if (password.equals("")) {
                password = null;
            }
            this.context.out.println("\nConnecting to DeploymentManager " + username + "@" + uri + "...");
            this.context.deployer = DeploymentFactoryManager.getInstance().getDeploymentManager(uri, username, password);
            this.context.out.println("Connected.");
            this.context.connected = true;
            this.context.uri = uri;
            this.context.username = username;
            this.context.password = password;
        }
        catch (DeploymentManagerCreationException e) {
            log.error((Object)"Can't create deployment manager", (Throwable)e);
            return;
        }
        catch (IOException e) {
            log.error((Object)"Unable to read user input", (Throwable)e);
            return;
        }
    }
}

