/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.console.cli.controller;

import java.io.IOException;
import javax.enterprise.deploy.spi.Target;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.console.cli.DeploymentContext;
import org.apache.geronimo.console.cli.TextController;

public class AddServer
extends TextController {
    private static final Log log = LogFactory.getLog((Class)AddServer.class);
    private Target[] all;

    public AddServer(DeploymentContext context, Target[] all) {
        super(context);
        this.all = all;
    }

    public void execute() {
        Target[] available;
        do {
            int i;
            int i2;
            available = this.available(this.all, this.context.targets);
            this.newScreen("Add Target");
            this.println("Selected Targets");
            for (i2 = 0; i2 < this.context.targets.length; ++i2) {
                this.println("  " + this.context.targets[i2].getName() + " (" + this.truncate(this.context.targets[i2].getDescription(), 69 - this.context.targets[i2].getName().length()) + ")");
            }
            this.println("Available Targets");
            for (i2 = 0; i2 < available.length; ++i2) {
                this.println("  " + (i2 + 1) + ") " + available[i2].getName() + " (" + this.truncate(available[i2].getDescription(), 66 - available[i2].getName().length()) + ")");
            }
            while (true) {
                String choice;
                this.context.out.print("Action (Add Target [1" + (available.length > 1 ? "-" + available.length : "") + "] or [B]ack): ");
                this.context.out.flush();
                try {
                    choice = this.context.in.readLine().trim().toLowerCase();
                }
                catch (IOException e) {
                    log.error((Object)"Unable to read user input", (Throwable)e);
                    return;
                }
                if (choice.equals("b")) {
                    return;
                }
                i = 0;
                try {
                    i = Integer.parseInt(choice);
                }
                catch (NumberFormatException e) {
                    continue;
                }
                if (i >= 1 && i <= available.length) break;
                this.println("  ERROR: There are only " + available.length + " target(s) available");
            }
            Target[] list = new Target[this.context.targets.length + 1];
            System.arraycopy(this.context.targets, 0, list, 0, this.context.targets.length);
            list[this.context.targets.length] = available[i - 1];
            this.context.targets = list;
        } while (available.length > 1);
    }
}

