/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.cache;

import java.util.HashMap;
import org.apache.geronimo.cache.InstanceCache;
import org.apache.geronimo.cache.LRURunner;

public final class LRUInstanceCache
implements InstanceCache {
    private final HashMap active = new HashMap();
    private final HashMap inactive = new HashMap();
    private final Entry header = new Entry();

    public synchronized int size() {
        return this.active.size() + this.inactive.size();
    }

    public synchronized void putActive(Object key, Object value) {
        Entry entry = (Entry)this.inactive.remove(key);
        if (entry != null) {
            entry.remove();
        }
        this.active.put(key, value);
    }

    public synchronized void putInactive(Object key, Object value) {
        this.active.remove(key);
        Entry entry = new Entry(key, value);
        this.inactive.put(key, entry);
        this.header.addAfter(entry);
    }

    public synchronized Object get(Object key) {
        Object value = this.active.get(key);
        if (value != null) {
            return value;
        }
        Entry entry = (Entry)this.inactive.remove(key);
        if (entry != null) {
            value = entry.getValue();
            entry.remove();
            this.active.put(key, value);
        }
        return value;
    }

    public synchronized Object remove(Object key) {
        Object value = this.active.remove(key);
        Entry entry = (Entry)this.inactive.remove(key);
        if (entry != null) {
            value = entry.getValue();
            entry.remove();
        }
        return value;
    }

    public synchronized Object peek(Object key) {
        Object value = this.active.get(key);
        if (value != null) {
            return value;
        }
        Entry entry = (Entry)this.inactive.get(key);
        if (entry != null) {
            return entry.getValue();
        }
        return null;
    }

    public synchronized boolean isActive(Object key) {
        return this.active.containsKey(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(LRURunner runner) {
        Entry entry = this.header;
        while (runner.shouldContinue()) {
            Object value;
            Object key;
            LRUInstanceCache lRUInstanceCache = this;
            synchronized (lRUInstanceCache) {
                do {
                    if ((entry = entry.getPrevious()) == this.header) {
                        return;
                    }
                    key = entry.getKey();
                    value = entry.getValue();
                } while (entry.isRemoved() || !runner.shouldRemove(key, value));
                this.inactive.remove(key);
                entry.remove();
            }
            runner.remove(key, value);
        }
    }

    private static final class Entry {
        private Entry next;
        private Entry previous;
        private Object key;
        private Object value;
        private boolean removed = false;

        public Entry() {
            this.next = this;
            this.previous = this;
        }

        public Entry(Object key, Object value) {
            this.key = key;
            this.value = value;
        }

        public Entry getPrevious() {
            return this.previous;
        }

        public Entry getNext() {
            return this.next;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public boolean isRemoved() {
            return this.removed;
        }

        public void addAfter(Entry entry) {
            entry.previous = this;
            entry.next = this.next;
            this.next.previous = entry;
            this.next = entry;
        }

        public void addBefore(Entry entry) {
            entry.next = this;
            entry.previous = this.previous;
            this.previous.next = entry;
            this.previous = entry;
        }

        public void remove() {
            if (!this.removed) {
                this.previous.next = this.next;
                this.next.previous = this.previous;
                this.next = null;
                this.key = null;
                this.value = null;
                this.removed = true;
            }
        }
    }
}

